/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.canvas.FigTrafo2D;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.objects.FigAttribs;
import jfig.objects.FigEllipse;
import jfig.objects.FigObject;
import jfig.utils.MouseMapper;
import jfig.utils.SetupManager;

public class CreateBulletCommand
extends Command {
    protected FigObject ellipse;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.ellipse};
        return figObjectArray;
    }

    public void execute() {
        if (this.ellipse != null) {
            this.editor.insertIntoObjectList(this.ellipse);
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void undo() {
        if (this.ellipse != null) {
            this.editor.deleteFromObjectList(this.ellipse);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        FigTrafo2D figTrafo2D = this.objectCanvas.getTrafo();
        FigAttribs figAttribs = this.editor.getCurrentAttribs().getClone();
        int n = SetupManager.getInteger("jfig.commands.CreateBulletCommand.DefaultRadius", 120);
        Point point3 = new Point(point);
        Point point4 = new Point(point3.x + n, point3.y + n);
        if (MouseMapper.isMiddleClick(figCanvasEvent)) {
            figAttribs.fillStyle = 1;
        } else {
            if (MouseMapper.isRightClick(figCanvasEvent)) {
                this.ready = true;
                return;
            }
            figAttribs.setFillStyle("pure");
        }
        this.ellipse = new FigEllipse(point3, point4, figAttribs, figTrafo2D);
        this.execute();
        this.ready = true;
        this.notifyEditor();
    }

    public String getDescription() {
        return "create bullet";
    }

    public String toString() {
        return "jfig.commands.CreateBulletCommand[]";
    }

    public CreateBulletCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("L: filled bullet,  M: open bullet");
        figBasicEditor.hideAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.ready = false;
    }
}

