/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.canvas.FigTrafo2D;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.objects.FigAttribs;
import jfig.objects.FigBezier;
import jfig.objects.FigBezierXSpline;
import jfig.objects.FigObject;
import jfig.utils.MouseMapper;
import jfig.utils.SetupManager;

public class CreateBezierCommand
extends Command {
    protected int n_points;
    protected FigObject bezier;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.bezier};
        return figObjectArray;
    }

    public void execute() {
        if (this.bezier != null) {
            this.editor.insertIntoObjectList(this.bezier);
            this.editor.deleteTmpObject(this.bezier);
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void undo() {
        if (this.bezier != null) {
            this.editor.deleteFromObjectList(this.bezier);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void cancel() {
        if (this.bezier != null) {
            this.editor.deleteTmpObject(this.bezier);
        }
        this.objectCanvas.doFullRedraw();
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        if (this.n_points == 0) {
            FigAttribs figAttribs = this.editor.getCurrentAttribs().getClone();
            FigTrafo2D figTrafo2D = this.objectCanvas.getTrafo();
            this.bezier = SetupManager.getBoolean("jfig.enableXSplines", true) ? new FigBezierXSpline(point.x, point.y, false, figAttribs, figTrafo2D) : new FigBezier(point.x, point.y, false, figAttribs, figTrafo2D);
            this.editor.addTmpObject(this.bezier);
            this.objectCanvas.setRubberbandBasePoint(point2);
            this.objectCanvas.changeRubberbandMode(2);
            this.objectCanvas.doSimpleRedraw();
            this.statusMessage("L: next point, M: final point, R: cancel");
            ++this.n_points;
        } else if (MouseMapper.isMiddleClick(figCanvasEvent) || MouseMapper.isShiftDown(figCanvasEvent)) {
            this.bezier.appendPoint(point);
            this.objectCanvas.changeRubberbandMode(1);
            this.execute();
            this.ready = true;
            this.notifyEditor();
        } else if (MouseMapper.isRightClick(figCanvasEvent)) {
            this.n_points = 0;
            if (this.bezier != null) {
                this.editor.deleteTmpObject(this.bezier);
            }
            this.bezier = null;
            this.objectCanvas.changeRubberbandMode(1);
            this.objectCanvas.doFullRedraw();
            this.statusMessage("L: first bezier point");
        } else {
            this.bezier.appendPoint(point);
            this.objectCanvas.setRubberbandBasePoint(point2);
            this.objectCanvas.doSimpleRedraw();
            this.statusMessage("L: next point, M: final point, R: cancel");
            ++this.n_points;
        }
    }

    public String getDescription() {
        return "create bezier";
    }

    public String toString() {
        return "jfig.commands.CreateBezierCommand[]";
    }

    public CreateBezierCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("L: first bezier point");
        figBasicEditor.hideAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.n_points = 0;
        this.ready = false;
    }
}

