/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.canvas.FigTrafo2D;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.objects.FigArc;
import jfig.objects.FigAttribs;
import jfig.objects.FigBezier;
import jfig.objects.FigBezierXSpline;
import jfig.objects.FigEllipse;
import jfig.objects.FigNormalXSpline;
import jfig.objects.FigObject;
import jfig.objects.FigPolyline;
import jfig.objects.FigRectangle;
import jfig.objects.FigSpline;
import jfig.utils.MouseMapper;
import jfig.utils.SetupManager;

public class ConvertObjectCommand
extends Command {
    protected FigObject object;
    protected FigObject newObject;
    protected FigAttribs attribs;
    protected FigTrafo2D trafo;
    protected int n_points;

    public FigObject[] getModifiedObjects() {
        FigObject[] figObjectArray = new FigObject[]{this.object, this.newObject};
        return figObjectArray;
    }

    public void execute() {
        if (this.object != null) {
            if (this.object instanceof FigPolyline) {
                this.convertPolyline();
            } else if (this.object instanceof FigEllipse) {
                this.convertEllipse();
            } else if (this.object instanceof FigRectangle) {
                this.convertRectangle();
            } else {
                this.statusMessage("Cannot convert such object, sorry!");
                return;
            }
            this.editor.getUndoStack().push(this);
            this.objectCanvas.doFullRedraw();
        }
    }

    private void convertPolyline() {
        Point[] pointArray = this.object.getPoints();
        FigAttribs figAttribs = this.object.getAttributes();
        boolean bl = this.object.isClosed();
        Point point = this.object.getPosition();
        int n = point.x;
        int n2 = point.y;
        if (this.object instanceof FigArc) {
            return;
        }
        this.newObject = this.object instanceof FigBezierXSpline ? new FigPolyline(n, n2, bl, figAttribs, this.trafo) : (this.object instanceof FigNormalXSpline ? new FigBezierXSpline(n, n2, bl, figAttribs, this.trafo) : (this.object instanceof FigBezier ? new FigPolyline(n, n2, bl, figAttribs, this.trafo) : (this.object instanceof FigSpline ? new FigBezier(n, n2, bl, figAttribs, this.trafo) : (SetupManager.getBoolean("jfig.enableXSplines", true) ? new FigNormalXSpline(n, n2, bl, figAttribs, this.trafo) : new FigSpline(n, n2, bl, figAttribs, this.trafo)))));
        this.newObject.setPoints(pointArray);
        this.editor.deleteFromObjectList(this.object);
        this.editor.insertIntoObjectList(this.newObject);
    }

    private void convertRectangle() {
        Point[] pointArray = this.object.getPoints();
        FigAttribs figAttribs = this.object.getAttributes();
        boolean bl = ((FigRectangle)this.object).isRounded();
        if (bl) {
            int n = (pointArray[0].x + pointArray[1].x) / 2;
            int n2 = (pointArray[0].y + pointArray[1].y) / 2;
            int n3 = Math.abs(n - pointArray[0].x);
            int n4 = Math.abs(n2 - pointArray[0].y);
            this.newObject = new FigEllipse(new Point(n, n2), new Point(n3, n4), figAttribs, this.trafo);
        } else {
            FigAttribs figAttribs2 = this.editor.getCurrentAttribs().getClone();
            figAttribs.cornerRadius = figAttribs2.cornerRadius;
            this.newObject = new FigRectangle(pointArray[0].x, pointArray[0].y, pointArray[1].x, pointArray[1].y, true, figAttribs, this.trafo);
        }
        this.newObject.setPoints(pointArray);
        this.editor.deleteFromObjectList(this.object);
        this.editor.insertIntoObjectList(this.newObject);
    }

    private void convertEllipse() {
        Point[] pointArray = this.object.getPoints();
        FigAttribs figAttribs = this.object.getAttributes();
        figAttribs.cornerRadius = 0;
        int n = pointArray[0].x;
        int n2 = pointArray[0].y;
        int n3 = pointArray[1].x;
        int n4 = pointArray[1].y;
        this.newObject = new FigRectangle(n - n3, n2 - n4, n + n3, n2 + n4, false, figAttribs, this.trafo);
        this.newObject.setPoints(pointArray);
        this.editor.deleteFromObjectList(this.object);
        this.editor.insertIntoObjectList(this.newObject);
    }

    public void undo() {
        if (this.object != null && this.newObject != null) {
            this.editor.deleteFromObjectList(this.newObject);
            this.editor.insertIntoObjectList(this.object);
            this.objectCanvas.doFullRedraw();
        }
    }

    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        Point point3 = new Point(0, 0);
        if (MouseMapper.isShiftDown(figCanvasEvent)) {
            this.object = this.editor.findObjectAt(point);
            if (this.object == null) {
                this.statusMessage("Click on the object to convert! (line > spline > bezier, rectangle > oval > ellipse)");
                return;
            }
            this.newObject = this.object;
            FigAttribs figAttribs = this.object.getAttributes().getClone();
            if (figAttribs.fillStyle == 1) {
                figAttribs.fillStyle = 2;
            } else if (figAttribs.fillStyle == 2) {
                figAttribs.fillStyle = 1;
            }
            this.newObject.setAttributes(figAttribs);
        } else if (this.n_points == 0) {
            this.object = this.editor.findObjectAt(point);
            if (this.object == null) {
                this.statusMessage("Click on the object to convert! (line > spline > bezier, rectangle > oval > ellipse)");
                return;
            }
            this.execute();
        }
        this.ready = true;
        this.notifyEditor();
    }

    public String getDescription() {
        return "ccnvert object";
    }

    public String toString() {
        return "jfig.commands.ConvertObjectCommand[]";
    }

    public ConvertObjectCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("Click on the object to convert! (line > spline > bezier, rectangle > oval > ellipse)");
        figBasicEditor.showAllObjectCorners();
        figCanvas.changeRubberbandMode(1);
        this.trafo = figCanvas.getTrafo();
        this.n_points = 0;
        this.ready = false;
    }
}

