/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import java.util.Enumeration;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.objects.FigCompound;
import jfig.objects.FigObject;

public class BreakCompoundCommand
extends Command {
    protected int n_points;
    protected FigObject object;
    protected Point P1;
    protected Point P2;
    protected Point P3;

    public void showAllCompounds() {
        Enumeration enumeration = this.editor.getObjects();
        while (enumeration.hasMoreElements()) {
            FigObject figObject = (FigObject)enumeration.nextElement();
            if (figObject instanceof FigCompound) {
                figObject.showPoints();
                continue;
            }
            figObject.deselect();
        }
        this.objectCanvas.doFullRedraw();
    }

    public FigObject[] getModifiedObjects() {
        if (this.object == null) {
            return new FigObject[0];
        }
        FigObject[] figObjectArray = new FigObject[]{this.object};
        return figObjectArray;
    }

    public void setCompound(FigCompound figCompound) {
        this.object = figCompound;
    }

    public void execute() {
        if (this.object == null) {
            return;
        }
        Enumeration enumeration = ((FigCompound)this.object).getMembers().elements();
        while (enumeration.hasMoreElements()) {
            this.editor.insertIntoObjectList((FigObject)enumeration.nextElement());
        }
        this.editor.deleteFromObjectList(this.object);
        this.editor.getUndoStack().push(this);
        this.objectCanvas.doFullRedraw();
    }

    public void undo() {
        if (this.object == null) {
            return;
        }
        Enumeration enumeration = ((FigCompound)this.object).getMembers().elements();
        while (enumeration.hasMoreElements()) {
            this.editor.deleteFromObjectList((FigObject)enumeration.nextElement());
        }
        this.editor.insertIntoObjectList(this.object);
        this.objectCanvas.doFullRedraw();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        if (figCanvasEvent.isShiftDown()) {
            if (this.object != null) {
                this.object.deselect();
            }
            this.object = this.findNextCompound(point, this.object);
            if (this.object != null) {
                this.object.select();
                return;
            }
            this.statusMessage("No compound at that position!Please click on/near the compound to break");
            return;
        }
        if (this.object == null) {
            this.object = this.findNextCompound(point, null);
        }
        if (this.object != null && this.object instanceof FigCompound) {
            this.execute();
            this.ready = true;
            this.notifyEditor();
            return;
        }
        if (this.object != null) {
            this.statusMessage("No compound at that position! Please click on the compound to break");
            return;
        }
        this.statusMessage("No object at that position! Please click on/near the compound to break");
    }

    public FigObject findNextCompound(Point point, FigObject figObject) {
        if (figObject == null) {
            FigObject figObject2 = this.editor.findObjectAt(point);
            if (figObject2 instanceof FigCompound) {
                return figObject2;
            }
            FigObject figObject3 = this.editor.findNextObjectAt(point, figObject2);
            while (figObject3 != null && figObject3 != figObject2) {
                if (figObject3 instanceof FigCompound) {
                    return figObject3;
                }
                figObject2 = figObject3;
                figObject3 = this.editor.findNextObjectAt(point, figObject2);
            }
            return null;
        }
        if (figObject instanceof FigCompound) {
            FigObject figObject4 = figObject;
            FigObject figObject5 = this.editor.findNextObjectAt(point, figObject4);
            while (figObject5 != null && figObject5 != figObject4) {
                if (figObject5 instanceof FigCompound) {
                    return figObject5;
                }
                figObject4 = figObject5;
                figObject5 = this.editor.findNextObjectAt(point, figObject4);
            }
            return null;
        }
        return null;
    }

    public String getDescription() {
        return "break compound";
    }

    public String toString() {
        return "jfig.commands.BreakCompoundCommand[]";
    }

    public BreakCompoundCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.showAllCompounds();
        figCanvas.changeRubberbandMode(1);
        this.statusMessage("Click on the compound to break");
        this.n_points = 0;
        this.ready = false;
    }
}

