/*
 * Decompiled with CFR 0.152.
 */
package jfig.commands;

import java.awt.Point;
import java.lang.reflect.Method;
import java.util.Enumeration;
import jfig.canvas.FigCanvas;
import jfig.canvas.FigCanvasEvent;
import jfig.commands.Command;
import jfig.commands.FigBasicEditor;
import jfig.objects.FigBbox;
import jfig.objects.FigCompound;
import jfig.objects.FigObject;

public class AlignObjectsCommand
extends Command {
    protected Point P1;
    protected int n_points;
    protected FigObject object;
    protected int alignX;
    protected int alignY;

    public void showAllCompounds() {
        Enumeration enumeration = this.editor.getObjects();
        while (enumeration.hasMoreElements()) {
            FigObject figObject = (FigObject)enumeration.nextElement();
            if (figObject instanceof FigCompound) {
                figObject.showPoints();
                continue;
            }
            figObject.deselect();
        }
        this.objectCanvas.doFullRedraw();
    }

    public FigObject[] getModifiedObjects() {
        if (this.object == null) {
            return new FigObject[0];
        }
        FigObject[] figObjectArray = new FigObject[]{this.object};
        return figObjectArray;
    }

    public void execute() {
        FigCompound figCompound = (FigCompound)this.object;
        if (figCompound != null) {
            this.alignX = this._reflect("getObjectAlignmentModeX", 0);
            this.alignY = this._reflect("getObjectAlignmentModeY", 0);
            FigBbox figBbox = figCompound.getBbox();
            FigObject figObject = null;
            Enumeration enumeration = null;
            enumeration = figCompound.getMembers().elements();
            while (enumeration.hasMoreElements()) {
                figObject = (FigObject)enumeration.nextElement();
                this.alignObject(figObject, figBbox);
            }
            this.editor.getUndoStack().push(this);
        }
        this.objectCanvas.doFullRedraw();
    }

    private int _reflect(String string, int n) {
        try {
            Object[] objectArray = new Object[]{};
            Class[] classArray = new Class[]{};
            Method method = this.editor.getClass().getMethod(string, classArray);
            Object object = method.invoke((Object)this.editor, objectArray);
            return (Integer)object;
        }
        catch (Exception exception) {
            this.message("-E- internal in AlignObjectCommand._reflect: " + exception);
            exception.printStackTrace();
            return n;
        }
    }

    public void undo() {
        this.message("-E- undo not yet supported for AlignObjectCommand!");
        this.objectCanvas.doFullRedraw();
    }

    private void alignObject(FigObject figObject, FigBbox figBbox) {
        FigBbox figBbox2 = figObject.getBbox();
        int n = figBbox.getXl();
        int n2 = figBbox.getXr();
        int n3 = figBbox.getYt();
        int n4 = figBbox.getYb();
        int n5 = figBbox2.getXl();
        int n6 = figBbox2.getXr();
        int n7 = figBbox2.getYt();
        int n8 = figBbox2.getYb();
        switch (this.alignX) {
            case 1: {
                int n9 = n;
                figObject.move(n9 - n5, 0);
                break;
            }
            case 2: {
                int n10 = n + (n2 - n - (n6 - n5)) / 2;
                figObject.move(n10 - n5, 0);
                break;
            }
            case 3: {
                int n11 = n2 - (n6 - n5);
                figObject.move(n11 - n5, 0);
                break;
            }
        }
        switch (this.alignY) {
            case 3: {
                int n12 = n3;
                figObject.move(0, n12 - n7);
                break;
            }
            case 2: {
                int n13 = n3 + (n4 - n3 - (n8 - n7)) / 2;
                figObject.move(0, n13 - n7);
                break;
            }
            case 1: {
                int n14 = n4 - (n8 - n7);
                figObject.move(0, n14 - n7);
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void mousePressed(FigCanvasEvent figCanvasEvent) {
        Point point = figCanvasEvent.getWorldCoordinatePoint();
        Point point2 = figCanvasEvent.getScreenCoordinatePoint();
        if (figCanvasEvent.isShiftDown()) {
            if (this.object != null) {
                this.object.deselect();
            }
            this.object = this.findNextCompound(point, this.object);
            if (this.object != null) {
                this.object.select();
                return;
            }
            this.statusMessage("No compound at that position!Please click on/near the compound tou align");
            return;
        }
        if (this.object == null) {
            this.object = this.findNextCompound(point, null);
        }
        if (this.object != null && this.object instanceof FigCompound) {
            this.execute();
            this.ready = true;
            this.notifyEditor();
            return;
        }
        if (this.object == null) return;
        this.statusMessage("No compound at that position! Please click on the compound to align");
    }

    private FigObject findNextCompound(Point point, FigObject figObject) {
        if (figObject == null) {
            FigObject figObject2 = this.editor.findObjectAt(point);
            if (figObject2 instanceof FigCompound) {
                return figObject2;
            }
            FigObject figObject3 = this.editor.findNextObjectAt(point, figObject2);
            while (figObject3 != null && figObject3 != figObject2) {
                if (figObject3 instanceof FigCompound) {
                    return figObject3;
                }
                figObject2 = figObject3;
                figObject3 = this.editor.findNextObjectAt(point, figObject2);
            }
            return null;
        }
        if (figObject instanceof FigCompound) {
            FigObject figObject4 = figObject;
            FigObject figObject5 = this.editor.findNextObjectAt(point, figObject4);
            while (figObject5 != null && figObject5 != figObject4) {
                if (figObject5 instanceof FigCompound) {
                    return figObject5;
                }
                figObject4 = figObject5;
                figObject5 = this.editor.findNextObjectAt(point, figObject4);
            }
            return null;
        }
        return null;
    }

    public String getDescription() {
        return "align compound";
    }

    public String toString() {
        return "jfig.commands.AlignObjectsCommand[]";
    }

    public AlignObjectsCommand(FigBasicEditor figBasicEditor, FigCanvas figCanvas) {
        super(figBasicEditor, figCanvas);
        this.statusMessage("Click on the compound to align ");
        this.showAllCompounds();
        figCanvas.changeRubberbandMode(1);
        this.n_points = 0;
        this.ready = false;
    }
}

