/*
 * Decompiled with CFR 0.152.
 */
package hades.utils.vhdl;

import java.util.Hashtable;

public class VHDLNameMangler {
    private static Hashtable _nameTable;
    private static String[] _keyWords;

    private static void initKeywords() {
        int i = 0;
        while (i < _keyWords.length) {
            _nameTable.put(_keyWords[i].toLowerCase(), _keyWords[i]);
            ++i;
        }
    }

    public static boolean isKeyword(String s) {
        return _nameTable.contains(s.toLowerCase());
    }

    public static boolean isAllowedChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_';
    }

    public static boolean isAllowedFirstChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static String getValidVHDLName(String s) {
        if (s == null) {
            return "Xnull";
        }
        if (s == "") {
            return "Xempty";
        }
        StringBuffer sb = new StringBuffer();
        char c = s.charAt(0);
        if (VHDLNameMangler.isAllowedChar(c) && !VHDLNameMangler.isAllowedFirstChar(c)) {
            sb.append('Z');
        }
        int i = 0;
        while (i < s.length()) {
            c = s.charAt(i);
            if (VHDLNameMangler.isAllowedChar(c)) {
                sb.append(c);
            } else {
                sb.append('X');
            }
            ++i;
        }
        String s2 = sb.toString();
        if (VHDLNameMangler.isKeyword(s2)) {
            return "X" + s2;
        }
        return s2;
    }

    public static String getValidUniqueVHDLName(String s) {
        return "hugo";
    }

    public static void main(String[] argv) throws Exception {
    }

    static {
        _keyWords = new String[]{"abs", "access", "after", "alias", "all", "allow", "and", "architecture", "array", "assert", "attribute", "begin", "block", "body", "buffer", "bus", "case", "component", "configuration", "constant", "disconnect", "downto", "element", "else", "elsif", "end", "entity", "exit", "file", "for", "function", "generate", "generic", "group", "guarded", "if", "impure", "in", "initial", "is", "label", "library", "linkage", "literal", "loop", "map", "mod", "nand", "new", "next", "nor", "not", "null", "of", "on", "open", "or", "others", "out", "package", "port", "postponed", "private", "procedure", "process", "pure", "range", "record", "register", "reject", "rem", "report", "return", "rol", "ror", "select", "severity", "signal", "shared", "sla", "sll", "sra", "srl", "subtype", "then", "to", "transport", "type", "unaffected", "units", "until", "use", "variable", "wait", "when", "while", "with", "xnor", "xor"};
        _nameTable = new Hashtable();
        VHDLNameMangler.initKeywords();
    }
}

