/*
 * Decompiled with CFR 0.152.
 */
package hades.utils;

import hades.gui.Console;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.gui.PropertySheet;
import hades.manager.TreeManager;
import hades.manager.tree.FileRootTreeNode;
import hades.manager.tree.RootTreeNode;
import hades.manager.tree.SortedTreeNode;
import hades.models.Design;
import hades.simulator.SimObject;
import java.awt.Point;
import java.awt.Robot;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import jfig.utils.AntiDeadlock;
import jfig.utils.SetupManager;

public class TestLoadAllDesigns {
    private static long DELAY = 250L;
    static Hashtable simObjectConfiguredTable = new Hashtable();
    static String[] dummies = new String[]{"hades.models.io.Ipin", "hades.models.io.Ipin", "hades.models.io.ClockGen", "hades.models.io.Opin", "hades.models.gates.And2"};
    static Point[] points = new Point[]{new Point(2400, 2400), new Point(2400, 4800), new Point(2400, 9600), new Point(9600, 2400), new Point(6000, 6000)};

    public static void msg(String s) {
        System.out.println(s);
    }

    public static void usage() {
        TestLoadAllDesigns.msg("Usage: java -Xmx256M hades.utils.TestLoadAllDesigns [options]");
        TestLoadAllDesigns.msg("where options include: ");
        TestLoadAllDesigns.msg("-filelist      writes list of .hds files to stdout,");
        TestLoadAllDesigns.msg("-execute       reads list of .hds files from stdin and loads them,");
        TestLoadAllDesigns.msg("-all           generates file list and loads files.");
        System.exit(0);
    }

    public static void printMemoryStats() {
        Runtime rt = Runtime.getRuntime();
        System.gc();
        long total = rt.totalMemory();
        long free = rt.freeMemory();
        TestLoadAllDesigns.msg("-#- memory: total= " + TestLoadAllDesigns._dec10(total) + " free= " + TestLoadAllDesigns._dec10(free));
    }

    public static String _dec10(long value) {
        if (value < 0L) {
            return "" + value;
        }
        if (value < 10L) {
            return "         " + value;
        }
        if (value < 100L) {
            return "        " + value;
        }
        if (value < 1000L) {
            return "       " + value;
        }
        if (value < 10000L) {
            return "      " + value;
        }
        if (value < 100000L) {
            return "     " + value;
        }
        if (value < 1000000L) {
            return "    " + value;
        }
        if (value < 10000000L) {
            return "   " + value;
        }
        if (value < 100000000L) {
            return "  " + value;
        }
        if (value < 1000000000L) {
            return " " + value;
        }
        if (value < 10000000000L) {
            return "" + value;
        }
        return "" + value;
    }

    public static void main(String[] argv) throws Exception {
        SetupManager.setProperty("Hades.UseSwingGUI", "true");
        SetupManager.loadGlobalProperties("hades/.hadesrc");
        SetupManager.loadUserProperties(".hadesrc");
        SetupManager.loadLocalProperties(".hadesrc");
        Editor editor = null;
        Console console = null;
        Vector fileList = null;
        int n_files = 0;
        if (argv.length != 1) {
            TestLoadAllDesigns.usage();
        }
        if (argv[0].equals("-filelist")) {
            TestLoadAllDesigns.writeFileList();
        } else if (argv[0].equals("-execute")) {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            String line = null;
            editor = TestLoadAllDesigns.createEditor();
            console = TestLoadAllDesigns.createConsole(editor);
            TestLoadAllDesigns.basicEditorChecks(editor);
            while ((line = br.readLine()) != null) {
                TestLoadAllDesigns.msg("\n\n");
                TestLoadAllDesigns.msg("-#- n_files= " + n_files + " configured classes= " + simObjectConfiguredTable.size());
                TestLoadAllDesigns.printMemoryStats();
                TestLoadAllDesigns.loadOneDesign(editor, line);
                TestLoadAllDesigns.testOneDesign(editor);
                ++n_files;
            }
            console.println("-I- checked and loaded " + n_files + " designs.");
            console.println("-I- TestLoadAllDesigns ok.");
        } else if (argv[0].equals("-all")) {
            fileList = TestLoadAllDesigns.generateFileList();
            editor = TestLoadAllDesigns.createEditor();
            console = TestLoadAllDesigns.createConsole(editor);
            TestLoadAllDesigns.basicEditorChecks(editor);
            Enumeration e = fileList.elements();
            while (e.hasMoreElements()) {
                TestLoadAllDesigns.loadOneDesign(editor, (String)e.nextElement());
                TestLoadAllDesigns.testOneDesign(editor);
                ++n_files;
            }
            console.println("-I- checked and loaded " + n_files + " designs.");
            console.println("-I- TestLoadAllDesigns ok.");
        } else {
            TestLoadAllDesigns.msg("Unknown option: " + argv[0]);
        }
        System.exit(0);
    }

    public static void writeFileList() {
        Vector fileList = TestLoadAllDesigns.generateFileList();
        Enumeration e = fileList.elements();
        while (e.hasMoreElements()) {
            TestLoadAllDesigns.msg(e.nextElement().toString());
        }
    }

    public static Vector generateFileList() {
        Vector<String> fileList = new Vector<String>();
        FileRootTreeNode cwd = new FileRootTreeNode();
        cwd.setUserObject(".");
        TreeManager tm = new TreeManager();
        tm.setRootNode(new RootTreeNode());
        tm.getRootNode().add(cwd);
        tm.traverseFileTree(new File("."), cwd);
        Enumeration<TreeNode> e = cwd.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            SortedTreeNode tmp = (SortedTreeNode)e.nextElement();
            String name = tmp.toString();
            if (!name.endsWith(".hds") || !tmp.isLeaf()) continue;
            fileList.addElement(TreeManager.getFullPathname(tmp));
        }
        return fileList;
    }

    public static Editor createEditor() {
        SetupManager.setProperty("Hades.Editor.AutoStartSimulation", "false");
        Editor editor = new Editor();
        return editor;
    }

    public static Console createConsole(Editor editor) {
        Console console = Console.getConsole();
        console.setLogFileName("test.log");
        console.setLogFileEnable(true);
        return console;
    }

    public static void basicEditorChecks(Editor editor) {
        TestLoadAllDesigns.msg("-I- basic editor checks...");
        try {
            Point sp;
            Robot robot = new Robot();
            editor.doStartNewDesign();
            ObjectCanvas canvas = editor.getObjectCanvas();
            Point p0 = canvas.getComponent().getLocationOnScreen();
            TestLoadAllDesigns.msg("-I- canvas location on screen: " + p0);
            TestLoadAllDesigns.msg("-I- popup create...");
            int i = 0;
            while (i < dummies.length) {
                sp = canvas.getTrafo().getScreenCoords(points[i]);
                TestLoadAllDesigns.msg("-I- wc: " + points[i] + " sp: " + sp);
                editor.doPopupCreate(dummies[i]);
                robot.mouseMove(p0.x + sp.x, p0.y + sp.y);
                robot.mousePress(16);
                robot.mouseMove(p0.x + 10, p0.y + 10);
                robot.mousePress(4);
                ++i;
            }
            AntiDeadlock.sleep(DELAY);
            TestLoadAllDesigns.msg("-I- popup move...");
            sp = canvas.getTrafo().getScreenCoords(new Point(6600, 6600));
            robot.mouseMove(p0.x + sp.x, p0.y + sp.y);
            robot.mousePress(4);
            editor.doPopupMove();
            robot.mouseMove(p0.x + sp.x + 50, p0.y + sp.y + 50);
            robot.mousePress(16);
            AntiDeadlock.sleep(DELAY);
            TestLoadAllDesigns.msg("-I- editor move undo...");
            editor.doUndo();
            AntiDeadlock.sleep(DELAY);
            robot.mouseMove(p0.x + sp.x, p0.y + sp.y);
            robot.mousePress(4);
            editor.doPopupCopy();
            Point tp = canvas.getTrafo().getScreenCoords(new Point(9600, 9600));
            robot.mouseMove(p0.x + tp.x, p0.y + tp.y);
            robot.mousePress(16);
            AntiDeadlock.sleep(DELAY);
            AntiDeadlock.sleep(DELAY);
        }
        catch (Throwable t) {
            TestLoadAllDesigns.msg("-E- in basicEditorChecks: " + t);
            t.printStackTrace();
        }
    }

    public static void loadOneDesign(Editor editor, String designName) {
        try {
            String s = "-I- loading design '" + designName + "'...";
            TestLoadAllDesigns.msg(s);
            Console.getConsole().println(s);
            editor.doFlushSymbolCache();
            editor.doOpenDesign(designName, false);
            editor.doZoomFit();
        }
        catch (Throwable t) {
            TestLoadAllDesigns.msg("   got an exception: " + t);
            t.printStackTrace();
        }
    }

    public static void testOneDesign(Editor editor) {
        try {
            TestLoadAllDesigns.msg("-I- testing design...");
            editor.doZoomOut();
            Design design = editor.getDesign();
            Enumeration e = design.getComponents();
            while (e.hasMoreElements()) {
                SimObject so = (SimObject)e.nextElement();
                String classname = so.getClass().getName();
                if (simObjectConfiguredTable.get(classname) != null) continue;
                TestLoadAllDesigns.msg("-I- configuring: " + classname);
                simObjectConfiguredTable.put(classname, classname);
                if (classname.equals("hades.models.Design")) {
                    TestLoadAllDesigns.msg("-W- skipping Design.configure...");
                    continue;
                }
                so.configure();
                AntiDeadlock.sleep(DELAY);
                so.getPropertySheet().setVisible(false);
                ((PropertySheet)so.getPropertySheet()).dispose();
            }
            editor.doZoomIn();
            editor.doRunSimulation();
            AntiDeadlock.sleep(DELAY);
            AntiDeadlock.sleep(DELAY);
            editor.doPauseSimulation();
        }
        catch (Throwable t) {
            TestLoadAllDesigns.msg("   got an exception: " + t);
            t.printStackTrace();
        }
    }
}

