/*
 * Decompiled with CFR 0.152.
 */
package hades.utils;

public class ShellSort {
    public static void shellSort(double[] A, Object[] O) {
        int N = A.length;
        int h = 1;
        while (h <= N / 9) {
            h = 3 * h + 1;
        }
        while (h > 0) {
            int i = h + 1;
            while (i <= N) {
                double v = A[i - 1];
                Object w = O[i - 1];
                int j = i - 1;
                while (j > h - 1 && A[j - h] > v) {
                    A[j] = A[j - h];
                    O[j] = O[j - h];
                    j -= h;
                }
                A[j] = v;
                O[j] = w;
                ++i;
            }
            h /= 3;
        }
    }

    public static void shellSort(String[] A) {
        int N = A.length;
        int h = 1;
        while (h <= N / 9) {
            h = 3 * h + 1;
        }
        while (h > 0) {
            int i = h + 1;
            while (i <= N) {
                String v = A[i - 1];
                int j = i - 1;
                while (j > h - 1 && A[j - h].compareTo(v) > 0) {
                    A[j] = A[j - h];
                    j -= h;
                }
                A[j] = v;
                ++i;
            }
            h /= 3;
        }
    }

    private static void msg(String msg) {
        System.out.println(msg);
    }

    public static void main(String[] argv) {
        System.out.println("Shellsort self test started...");
        int N = 0;
        if (argv.length < 1) {
            System.out.println("Usage: java Shellsort <arraylength> [doPrint]");
            return;
        }
        N = Integer.parseInt(argv[0]);
        System.out.println("generating random strings...");
        String[] data = new String[N];
        int i = 0;
        while (i < N) {
            int value = 100000 + (int)(10000.0 * Math.random());
            data[i] = "" + value;
            ++i;
        }
        System.out.println("sorting...");
        ShellSort.shellSort(data);
        System.out.println("ready:");
        int i2 = 0;
        while (i2 < N) {
            System.out.println(data[i2]);
            ++i2;
        }
        System.out.println("...generating random numbers...");
        double[] d = new double[N];
        Object[] o = new Double[N];
        double sum = 0.0;
        int i3 = 0;
        while (i3 < N) {
            d[i3] = (int)(100000.0 * Math.random());
            o[i3] = new Double(d[i3]);
            ++i3;
        }
        int i4 = 0;
        while (i4 < N) {
            sum += d[i4];
            ++i4;
        }
        System.out.println("...sorting...");
        ShellSort.shellSort(d, o);
        System.out.println("...checking...");
        double sum2 = 0.0;
        int i5 = 0;
        while (i5 < N) {
            double ovalue = (Double)o[i5];
            if (d[i5] != ovalue) {
                ShellSort.msg("d[i] != o[i]: " + d[i5] + " " + o[i5]);
            }
            if (i5 > 0 && d[i5] < d[i5 - 1]) {
                ShellSort.msg("not sorted: " + d[i5] + " " + d[i5 - 1]);
            }
            sum2 += ovalue;
            ++i5;
        }
        if (sum != sum2) {
            ShellSort.msg("checksum mismatch: " + sum + " " + sum2);
        }
        if (argv.length >= 2) {
            int i6 = 0;
            while (i6 < N) {
                System.out.println(i6 + " " + d[i6] + " " + o[i6]);
                ++i6;
            }
        }
        System.out.println("ok.");
    }
}

