/*
 * Decompiled with CFR 0.152.
 */
package hades.utils;

import hades.gui.ObjectCanvas;
import java.awt.Point;
import java.util.Random;
import javax.swing.SwingUtilities;

public class RedrawStressTest
implements Runnable {
    ObjectCanvas objectCanvas = null;
    Random generator = new Random();
    int N = 10000;

    public RedrawStressTest(ObjectCanvas objectCanvas) {
        this.objectCanvas = objectCanvas;
    }

    public void setIterations(int n_iterations) {
        this.N = n_iterations;
    }

    public void start() {
        new Thread(this).start();
    }

    public void run() {
        System.out.println("-#- RedrawStressTest started... ");
        double t_start = System.currentTimeMillis();
        int i = 1;
        while (i < this.N) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        Point anchor = RedrawStressTest.this.objectCanvas.getTrafo().getAnchor();
                        int x = anchor.x + RedrawStressTest.this.generator.nextInt(201) - 100;
                        int y = anchor.y + RedrawStressTest.this.generator.nextInt(201) - 100;
                        RedrawStressTest.this.objectCanvas.getTrafo().setAnchor(new Point(x, y));
                        RedrawStressTest.this.objectCanvas.doFullRedraw();
                    }
                });
                Thread.sleep(10L);
                if (i < 10 || i % 100 == 0) {
                    double t_now = System.currentTimeMillis();
                    double fps = 1000.0 * (double)i / (t_now - t_start);
                    System.out.println("-#- doRedrawStressTest repaints= " + i + " fps= " + fps);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            ++i;
        }
        System.out.println("-#- RedrawStressTest ok... ");
    }
}

