/*
 * Decompiled with CFR 0.152.
 */
package hades.utils;

import hades.gui.Console;
import hades.manager.DesignManager;
import hades.models.Design;
import hades.signals.Signal;
import hades.simulator.SimObject;
import hades.symbols.Symbol;
import hades.symbols.SymbolManager;
import hades.utils.NameMangler;
import hades.utils.StringTokenizer;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import jfig.utils.ExceptionTracer;

public class Parser {
    static Console console;
    static final int IDLE = 1;
    static final int NAME = 2;
    static final int COMPONENTS = 3;
    static final int SIGNALS = 4;

    static boolean isCommentLine(String line) {
        return line.length() < 1 || line.startsWith("#") || line.startsWith("//");
    }

    static boolean isKeyword(String line, String keyword) {
        return line.startsWith(keyword);
    }

    public static void parseComponent(String line, Design design) throws Exception {
        String className = null;
        String instanceName = null;
        String restOfLine = null;
        String orientation = null;
        DesignManager designManager = DesignManager.getDesignManager();
        StringTokenizer st = new StringTokenizer(line);
        className = st.nextToken();
        instanceName = NameMangler.decodeUnicodeEscapes(st.nextToken());
        int x = Integer.parseInt(st.nextToken());
        int y = Integer.parseInt(st.nextToken());
        restOfLine = st.restOfLine();
        orientation = st.nextToken();
        if (orientation.startsWith("@")) {
            restOfLine = st.restOfLine();
        } else {
            orientation = null;
        }
        SimObject component = designManager.getSimObject(className);
        component.setEditor(design.getEditor());
        component.setName(instanceName);
        component.setParent(design);
        if (component instanceof Design) {
            Design subDesign = (Design)component;
            subDesign.setVisible(false);
            subDesign.initialize(restOfLine);
        } else {
            component.initialize(restOfLine);
        }
        if (design.isVisible()) {
            component.setVisible(true);
            SymbolManager SM = SymbolManager.getSymbolManager();
            Symbol symbol = SM.getSymbol(component);
            if (orientation != null) {
                symbol.setOrientation(orientation);
            }
            component.setSymbol(symbol);
        } else {
            component.setVisible(false);
        }
        if (component.getSymbol() != null) {
            component.getSymbol().move(x, y);
        }
        design.addComponent(component);
    }

    static void parseSignal(String line, Design design) throws Exception {
        int index = line.indexOf(" ");
        String className = line.substring(0, index);
        Signal signal = (Signal)Class.forName(className).newInstance();
        signal.setVisible(design.isVisible());
        signal.readFromString(line.substring(index), design);
        if (signal.countSendersAndReceivers() == 0 && signal.countSegments() == 0) {
            Parser.msg("-E- Ignoring zombie signal (not connected/no segments): " + signal);
        } else {
            design.addSignal(signal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int parseDesign(Design design, InputStream is) {
        if (design.getDebug()) {
            Parser.msg("parseDesign started...");
        }
        String line = null;
        String magic = "# hades.models.Design file";
        LineNumberReader reader = null;
        int phase = 0;
        if (is == null) {
            Parser.msg("-E- parseDesign: InputStream is null!");
            return 0;
        }
        try {
            reader = new LineNumberReader(new InputStreamReader(is));
        }
        catch (Throwable e) {
            Parser.msg("-E- parseDesign: failed to construct the InputStreamReader");
            ExceptionTracer.trace(e);
            return 0;
        }
        try {
            line = reader.readLine();
            if (!magic.equals(line)) {
                throw new Exception("Not a Hades design file! Expected: " + magic);
            }
            phase = 1;
            while ((line = reader.readLine()) != null) {
                if (Parser.isCommentLine(line) || !Parser.isKeyword(line, "[name]")) continue;
                if (design.getParent() == null) {
                    String tmpname = line.substring(line.indexOf(32) + 1);
                    design.setDesignName(NameMangler.decodeUnicodeEscapes(tmpname));
                } else if (design.getDebug()) {
                    Parser.msg("-I- parseDesign(): ignored  setDesignName() for subdesign " + design.getFullName());
                }
                phase = 2;
                break;
            }
            if (phase != 2) {
                throw new Exception("[name] section missing!");
            }
            while ((line = reader.readLine()) != null) {
                if (Parser.isCommentLine(line) || !Parser.isKeyword(line, "[components]")) continue;
                phase = 3;
                break;
            }
            if (phase != 3) {
                throw new Exception("[components] section missing!");
            }
            while ((line = reader.readLine()) != null) {
                if (Parser.isCommentLine(line)) continue;
                if (Parser.isKeyword(line, "[end components]")) {
                    phase = 4;
                    break;
                }
                try {
                    Parser.parseComponent(line, design);
                }
                catch (Exception e) {
                    Parser.msg("-E- Exception while parsing components: " + e.toString());
                    Parser.msg("-E- on line " + reader.getLineNumber() + ": '" + line + "'");
                    ExceptionTracer.trace(e);
                    Parser.msg("-I- Trying to continue, with fingers crossed...");
                }
            }
            if (phase != 4) {
                throw new Exception("[end components] keyword missing!");
            }
            while ((line = reader.readLine()) != null) {
                if (Parser.isCommentLine(line) || !Parser.isKeyword(line, "[signals]")) continue;
                phase = 5;
                break;
            }
            if (phase != 5) {
                throw new Exception("[signals] section missing!");
            }
            while ((line = reader.readLine()) != null) {
                if (Parser.isCommentLine(line)) continue;
                if (Parser.isKeyword(line, "[end signals]")) {
                    phase = 6;
                    break;
                }
                try {
                    Parser.parseSignal(line, design);
                }
                catch (Exception e) {
                    Parser.msg("-E- Exception while parsing signals: " + e);
                    Parser.msg("-E- on line " + reader.getLineNumber() + ": '" + line + "'");
                    ExceptionTracer.trace(e);
                    Parser.msg("-I- Trying to continue, with fingers crossed...");
                }
            }
            if (phase == 6) return 0;
            throw new Exception("[end signals] keyword missing!");
        }
        catch (Exception e) {
            Parser.msg("-E- parseDesign: " + e.getMessage());
            Parser.msg("-E- on line " + reader.getLineNumber() + ": '" + line + "'");
            ExceptionTracer.trace(e);
            return 0;
        }
        finally {
            try {
                reader.close();
                is.close();
            }
            catch (Throwable e) {
                Parser.msg("-E- parseDesign: couldn't close: " + e);
                System.err.println("-E- parseDesign: couldn't close: " + e);
            }
        }
    }

    public static void dbg(String msg) {
        ExceptionTracer.message("-@- " + msg);
    }

    static void msg(String msg) {
        if (console == null) {
            console = Console.getConsole();
        }
        console.println(msg);
    }
}

