/*
 * Decompiled with CFR 0.152.
 */
package hades.utils;

import hades.gui.Console;

public class NameMangler {
    private static String[] spaces = new String[]{"0000", "000", "00", "0", ""};

    public static String getValidName(String name) {
        String newname = new String(name);
        if (newname.indexOf(32) > 0 || newname.indexOf(9) > 0) {
            newname = newname.replace(' ', '_');
            newname = newname.replace('\t', '_');
            Console.getConsole().message("-W- name contains spaces/tabs, changed to: " + newname);
        }
        return newname;
    }

    public static boolean isAsciiLetterOrDigitOrSomething(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '/' || c == '_' || c == '-' || c == ':' || c == '.';
    }

    public static String getUnicodeEscape(char c) {
        String hex = Integer.toHexString(c);
        return "\\u" + spaces[hex.length()] + hex;
    }

    public static String encodeWithUnicodeEscapes(String src) {
        if (src == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int max = src.length();
        while (i < max) {
            char c = src.charAt(i);
            if (NameMangler.isAsciiLetterOrDigitOrSomething(c)) {
                sb.append(c);
            } else {
                sb.append(NameMangler.getUnicodeEscape(c));
            }
            ++i;
        }
        return sb.toString();
    }

    public static String decodeUnicodeEscapes(String src) {
        if (src == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int max = src.length();
        while (i < max) {
            char c = src.charAt(i);
            if (c == '\\') {
                if (src.charAt(i + 1) == 'u') {
                    int j = Integer.parseInt(src.substring(i + 2, i + 6), 16);
                    sb.append((char)j);
                    i += 5;
                } else {
                    sb.append(c);
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String getBindkey(Object sobj, String s) {
        if (s == null) {
            return "";
        }
        if (s.length() == 0) {
            return "";
        }
        if ("null".equals(s)) {
            return "";
        }
        char c = s.charAt(0);
        if (c >= 'a' && c <= 'z') {
            return "" + c;
        }
        if (c >= '0' && c <= '9') {
            return "" + c;
        }
        System.err.println("-#- NameMangler.getBindkey: " + sobj.toString() + " invalid input: " + s);
        return "";
    }

    public static void usage() {
        System.out.println("Usage: java hades.utils.NameMangler <command> {argument}\nwhere command is one of -encode -decode -selftest\nand {argument} is the string to be encoded or decoded\nExample:\njava hades.utils.NameMangler -encode \"foo$bar@spa ce>>baz\"\n");
        System.exit(1);
    }

    public static void main(String[] argv) {
        block5: {
            try {
                String command = argv[0];
                if ("-encode".equals(command)) {
                    System.out.println(NameMangler.encodeWithUnicodeEscapes(argv[1]));
                    break block5;
                }
                if ("-decode".equals(command)) {
                    System.out.println(NameMangler.decodeUnicodeEscapes(argv[1]));
                    break block5;
                }
                if ("-selftest".equals(command)) {
                    NameMangler.selftest();
                    break block5;
                }
                NameMangler.usage();
            }
            catch (Exception e) {
                NameMangler.usage();
            }
        }
    }

    public static void selftest() {
        System.out.println("Unicode encoding/decoding selftest...");
        String[] tests = new String[]{"Abba", "Baywatch", "Christiane", "delta t", "epsilon theta tau", "c:\\Program Files\\User Data\\Garbage Collectors Item.hds", "_01234_56769_", "_abcde_fghij_klmno_pqrst_uvwxy_z", "_ABCDE_FGHIJ_KLMNO_PQRST_UVWXY_Z", "_!?<>^_@#$%&_*(){{}_[]:;.,/_+|~=\\_"};
        int i = 0;
        while (i < tests.length) {
            String original = tests[i];
            String encoded = NameMangler.encodeWithUnicodeEscapes(original);
            String decoded = NameMangler.decodeUnicodeEscapes(encoded);
            System.out.println(original + "\n" + encoded + "\n" + original.equals(decoded) + "\n");
            ++i;
        }
    }
}

