/*
 * Decompiled with CFR 0.152.
 */
package hades.utils;

import hades.manager.DesignManager;
import java.io.InputStream;
import jfig.gui.ColorCache;
import jfig.gui.FontCache;
import jfig.objects.FigAttribs;
import jfig.utils.SetupManager;

public class MatlabAdapter {
    SetupManager setupManager = null;
    DesignManager designManager = null;
    FigAttribs attribs = null;
    FontCache fontCache = null;
    ColorCache colorCache = null;
    public static boolean debug = false;

    public MatlabAdapter() {
        if (debug) {
            this.msg(" -#- MatlabAdapter.<init>...");
        }
        this.setupManager = SetupManager.getSetupManager();
        this.designManager = DesignManager.getDesignManager();
        this.colorCache = ColorCache.getColorCache();
        this.fontCache = FontCache.getFontCache();
        this.attribs = new FigAttribs();
    }

    public void setHadesUseAWT() {
        SetupManager.setProperty("Hades.UseSwingGUI", "false");
    }

    public SetupManager getSetupManager() {
        return this.setupManager;
    }

    public DesignManager getDesignManager() {
        return this.designManager;
    }

    public ColorCache getColorCache() {
        return this.colorCache;
    }

    public FontCache getFontCache() {
        return this.fontCache;
    }

    public void setMatlabPath(String s) {
        this.getDesignManager().setMatlabPath(s);
    }

    public String[] getMatlabPath() {
        return this.getDesignManager().getMatlabPath();
    }

    public void loadProperties(String filename) {
        try {
            InputStream IS = this.getDesignManager().getInputStream(null, filename);
            SetupManager.loadLocalProperties(IS);
        }
        catch (Throwable t) {
            this.msg("-E- MatlabAdapter.loadProperties: " + t);
        }
    }

    public String getProperty(String key) {
        return SetupManager.getProperty(key);
    }

    public void setProperty(String key, String value) {
        SetupManager.setProperty(key, value);
    }

    public boolean getFalse() {
        return false;
    }

    public boolean getTrue() {
        return true;
    }

    public Thread currentThread() {
        return Thread.currentThread();
    }

    public void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {}
    }

    public void msg(String s) {
        System.out.println(s);
    }

    public static void main(String[] argv) {
        MatlabAdapter ma = new MatlabAdapter();
        System.out.println("MatlabAdapter ma: " + ma);
    }
}

