/*
 * Decompiled with CFR 0.152.
 */
package hades.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class MakeJarFromClassList {
    private ZipOutputStream ZOS = null;
    private Hashtable zipEntryTable = null;
    public static String[] magicResources = new String[]{"hades/doc/README", "hades/.hadesrc", "hades/gui/images/hades.gif", "hades/gui/images/iconEditor.gif", "hades/gui/images/simcontrol.gif", "hades/gui/images/wavebuttons.gif", "hades/gui/ImageCanvas.class", "hades/gui/PopupMenu.txt", "hades/gui/ViewModePopupMenu.txt", "hades/gui/EditorInApplet.class", "hades/gui/JConsole.class", "hades/gui/JPropertiesViewer.class", "jfig/gui/JPropertiesViewer.class", "jfig/gui/PrintManager.class", "jfig/gui/PrintManager$Manager2D.class", "jfig/utils/ShellSort.class", "hades/gui/JObjectCanvas.class", "hades/gui/JObjectCanvas$1.class", "hades/gui/JCanvasScroller.class", "hades/gui/JCanvasScroller$Filler.class", "hades/gui/JCanvasScroller$InfoLabel.class", "hades/gui/JCanvasScroller$DummyObjectEnumerator.class", "jfig/canvas/FigSwingCanvas.class", "jfig/canvas/FigSwingCanvas$Options2D.class", "hades/gui/JConsole.class", "hades/gui/JConsole$Updater.class", "hades/gui/JConsole$Timer.class", "hades/gui/JConsole$LogManager.class", "hades/gui/JythonConsole.class", "hades/gui/JythonConsole$ConsoleStream.class", "hades/gui/JythonConsole$History.class", "hades/gui/JythonConsole$PyTxtFileFilter.class", "hades/gui/JythonConsole$PythonRunner.class", "hades/gui/JythonConsole$History.class", "hades/gui/OKtoQuit.class", "hades/gui/ConfirmDialog.class", "hades/gui/JConfirmDialog.class", "hades/gui/ZoomRegionCommand.class", "hades/gui/AddProbeToSignalCommand.class", "hades/gui/DeleteProbeFromSignalCommand.class", "hades/models/gates/NandMetastable2.class", "hades/models/gates/NandMetastable2.sym", "hades/models/gates/NandMetastable3.class", "hades/models/gates/NandMetastable3.sym", "hades/utils/IntegerFormatter.class", "hades/utils/TimeFormatter.class", "hades/simulator/Assignable.class", "hades/simulator/BatchModeSimKernel.class", "hades/simulator/CommandQueue$Node.class", "hades/simulator/CommandQueue$SelftestFeeder.class", "hades/simulator/CommandQueue$SelftestFetcher.class", "hades/simulator/CommandQueue.class", "hades/simulator/DeleteAllEventsFromSourceCommand.class", "hades/simulator/EventList$EventNode.class", "hades/simulator/EventList.class", "hades/simulator/InteractiveSimKernel.class", "hades/simulator/Port.class", "hades/simulator/RealTimeSimKernel.class", "hades/simulator/SignalEvent.class", "hades/simulator/SimDebugPanel.class", "hades/simulator/SimEvent.class", "hades/simulator/SimEvent1164.class", "hades/simulator/SimEventRecycler.class", "hades/simulator/SimKernel.class", "hades/simulator/SimObject.class", "hades/simulator/Simulatable.class", "hades/simulator/SimulatorCommand.class", "hades/simulator/SimulatorInterruptEvent.class", "hades/simulator/SimulatorScheduleCommand.class", "hades/simulator/SimulatorSingleStepCommand.class", "hades/simulator/VhdlBatchSimKernel.class", "hades/simulator/VhdlSimKernel$DeleteAllEventsFromSourceCommand.class", "hades/simulator/VhdlSimKernel$NOP.class", "hades/simulator/VhdlSimKernel.class", "hades/simulator/Wakeable.class", "hades/simulator/WakeupEvent.class", "jfig/utils/AntiDeadlock.class"};
    public static String[] styxResources = new String[]{"hades/gui/images/hades.gif", "hades/gui/images/wavebuttons.gif", "hades/gui/ImageButton.class", "hades/styx/NameCanvas.class", "hades/styx/TimeFormatter.class", "hades/styx/TimePanel.class", "hades/styx/Transformation.class", "hades/styx/WaveCanvas.class", "hades/styx/WaveInteger.class", "hades/styx/WaveStdLogic1164.class", "hades/styx/WaveStdLogicVector.class", "hades/styx/WaveString.class", "hades/styx/Waveform.class", "hades/styx/WaveformViewer$ShowSignalNameListener.class", "hades/styx/WaveformViewer$WavePanel.class", "hades/styx/WaveformViewer.class", "hades/styx/Xscroller.class", "hades/styx/Yscroller.class", "hades/styx/shortcut-keys.txt", "hades/symbols/ProbeSymbol.class", "jfig/gui/JConsole.class", "jfig/gui/JStatusCanvas.class", "jfig/gui/JTextViewer.class", "jfig/utils/AntiDeadlock.class"};
    public static String[] commandsAndUtils = new String[]{"hades/gui/Editor.class", "hades/gui/Editor$1.class", "hades/gui/Editor$DoCallMethodListener.class", "hades/doc/FAQ", "hades/doc/CHANGES", "hades/gui/JAboutDialog.class", "jfig/gui/JAboutDialog.class", "jfig/gui/JConsole.class", "hades/gui/AddProbeToSignalCommand.class", "hades/gui/AddSegmentToSignalCommand.class", "hades/gui/AutoconnectCommand.class", "hades/gui/ChangeNameCommand.class", "hades/gui/ChangeSignalNameCommand.class", "hades/gui/ColibriCreateCommand.class", "hades/gui/Command.class", "hades/gui/CopyCommand.class", "hades/gui/CreateByNameCommand.class", "hades/gui/CreateCommand.class", "hades/gui/CreateSignalCommand.class", "hades/gui/CreateSubdesignCommand.class", "hades/gui/DeleteAllCommand.class", "hades/gui/DeleteCommand.class", "hades/gui/DeleteComponentCommand.class", "hades/gui/DeleteProbeFromSignalCommand.class", "hades/gui/DeleteSegmentFromSignalCommand.class", "hades/gui/DeleteSelectionCommand.class", "hades/gui/DeleteSignalCommand.class", "hades/gui/DeselectAllCommand.class", "hades/gui/DisconnectCommand.class", "hades/gui/DisconnectPortCommand.class", "hades/gui/EditCommand.class", "hades/gui/InsertVertexIntoSignalCommand.class", "hades/gui/MirrorXCommand.class", "hades/gui/MirrorYCommand.class", "hades/gui/MoveCommand.class", "hades/gui/MoveSelectionCommand.class", "hades/gui/MoveToPositiveQuadrantCommand.class", "hades/gui/OpenDesignCommand.class", "hades/gui/SelectAllCommand.class", "hades/gui/SelectObjectCommand.class", "hades/gui/SelectRegionCommand.class", "hades/gui/SetDesignNameCommand.class", "hades/gui/SignalMovePointCommand.class", "hades/gui/SignalSetValueCommand.class", "hades/gui/ZoomRegionCommand.class", "jfig/gui/JWindowCloser.class", "hades/manager/DesignManager.class", "hades/manager/DesignManager$SwingFileChooser.class", "hades/manager/SimObjectNotFoundException.class", "hades/manager/SimObjectVersionNotFoundException.class", "hades/manager/ExtensionFileFilter.class", "hades/manager/HadesTreeCellRenderer.class", "hades/symbols/ErrorMarker.class", "hades/symbols/HighlightRectangle.class", "hades/symbols/HighlightWireSegment.class", "hades/utils/AudioFileLoader.class", "hades/utils/AudioPlayer.class", "hades/utils/ContextToolTip.class", "hades/utils/DecimalFormat.class", "hades/utils/DesignHierarchyNavigator.class", "hades/utils/EndsWithFilter.class", "hades/utils/Exporter$WindowCloser.class", "hades/utils/Exporter.class", "hades/utils/FigWriter.class", "hades/utils/Flatten.class", "hades/utils/HexFormat.class", "hades/utils/IntegerFormatter.class", "hades/utils/IntelHexFile.class", "hades/utils/JavaVersionCheck$1.class", "hades/utils/JavaVersionCheck.class", "hades/utils/LFSR32.class", "hades/utils/MemoryDec2HexConverter.class", "hades/utils/MemoryMultiple2SingleConverter.class", "hades/utils/NameListener.class", "hades/utils/NameMangler.class", "hades/utils/Parser.class", "hades/utils/Selection.class", "hades/utils/ShellSort.class", "hades/utils/SignalEnumerator.class", "hades/utils/StringTokenizer.class", "hades/utils/TimeFormatter.class", "hades/utils/ToolTipManager$1.class", "hades/utils/ToolTipManager.class", "hades/utils/ValidName.class"};
    public static String[] ke15Files = new String[]{"hades/gui/PopupMenuKE15.txt", "hades/models/rtl/Reg4.hds", "hades/models/rtl/Reg4.sym", "hades/models/ttl74/SN7483.hds", "hades/models/ttl74/SN7483.sym", "hades/models/ttl74/SN7483_stage.hds", "hades/models/ttl74/SN7483_stage.sym", "hades/models/hagen/Adder8.hds", "hades/models/hagen/Adder8.sym", "hades/models/hagen/Mux8.hds", "hades/models/hagen/Mux8.sym", "hades/models/hagen/Schalter.hds", "hades/models/hagen/Schalter.sym"};

    public void createZipOutputStream(String filename) throws Exception {
        this.ZOS = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
        this.zipEntryTable = new Hashtable();
    }

    public void closeZipOutputStream() throws Exception {
        this.ZOS.flush();
        this.ZOS.close();
    }

    public void copyAllFilesFromZipArchive(String filename) throws IOException {
        byte[] buffer = new byte[1024];
        int length = 0;
        System.out.println("copying files from " + filename);
        ZipFile source = new ZipFile(filename);
        Enumeration<? extends ZipEntry> e = source.entries();
        while (e.hasMoreElements()) {
            ZipEntry ZE = null;
            try {
                ZE = e.nextElement();
                System.out.println("copying entry: " + ZE.getName() + " " + ZE.getSize());
                InputStream IS = source.getInputStream(ZE);
                this.zipEntryTable.put(ZE.getName(), ZE.getName());
                this.ZOS.putNextEntry(ZE);
                while ((length = IS.read(buffer, 0, buffer.length)) >= 0) {
                    this.ZOS.write(buffer, 0, length);
                }
                this.ZOS.closeEntry();
                IS.close();
            }
            catch (Exception ee) {
                System.out.println("-W- Could not copy Zip entry: " + ZE);
            }
        }
    }

    public void readClassListFile(String filename) throws IOException {
        FileInputStream fis = new FileInputStream(filename);
        BufferedReader br = new BufferedReader(new InputStreamReader(fis));
        String line = null;
        String name = null;
        while ((line = br.readLine()) != null) {
            if (line.startsWith("[Opened") || line.startsWith("[Unloading")) continue;
            if (line.startsWith("[Loaded")) {
                name = line.substring(8, line.length() - 1);
                if (name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("sun.") || name.startsWith("com.sun.")) continue;
                String classname = name.replace('.', '/') + ".class";
                this.copySingleFile(classname, classname, true);
                if (!name.startsWith("hades.models") && !name.startsWith("hades/models")) continue;
                String symname = name.replace('.', '/') + ".sym";
                this.copySingleFile(symname, symname, false);
                String figname = name.replace('.', '/') + ".fig";
                this.copySingleFile(figname, figname, false);
                continue;
            }
            if (line.startsWith("-I-") || line.startsWith("-W-") || line.startsWith("-E-") || line.startsWith("-F-") || line.startsWith("-#-")) continue;
            name = line;
            this.copySingleFile(name, name, true);
        }
        br.close();
        fis.close();
    }

    public void copySingleFile(String zipname, String filename, boolean verbose) throws IOException {
        BufferedInputStream IS = null;
        byte[] buffer = new byte[1024];
        int length = 0;
        try {
            IS = new BufferedInputStream(new FileInputStream(filename));
        }
        catch (FileNotFoundException e) {
            if (verbose) {
                System.out.println("-W- file not found: '" + filename + "'");
            }
            return;
        }
        if (this.zipEntryTable.containsKey(zipname)) {
            System.out.println("-I- ignoring double entry: '" + zipname + "'");
            return;
        }
        System.out.println("-I- copying file '" + filename + "'");
        this.zipEntryTable.put(zipname, zipname);
        this.ZOS.putNextEntry(new ZipEntry(zipname));
        while ((length = ((InputStream)IS).read(buffer, 0, buffer.length)) >= 0) {
            this.ZOS.write(buffer, 0, length);
        }
        this.ZOS.closeEntry();
        ((InputStream)IS).close();
    }

    public void includeMagicResources() throws Exception {
        int i = 0;
        while (i < magicResources.length) {
            String name = magicResources[i];
            try {
                this.copySingleFile(name, name, true);
            }
            catch (ZipException ze) {
                System.out.println("-W- " + ze);
            }
            ++i;
        }
    }

    public void includeStyxResources() throws Exception {
        int i = 0;
        while (i < styxResources.length) {
            String name = styxResources[i];
            try {
                this.copySingleFile(name, name, true);
            }
            catch (ZipException ze) {
                System.out.println("-W- " + ze);
            }
            ++i;
        }
    }

    public void includeEditorResources() throws Exception {
        int i = 0;
        while (i < commandsAndUtils.length) {
            String name = commandsAndUtils[i];
            try {
                this.copySingleFile(name, name, true);
            }
            catch (ZipException ze) {
                System.out.println("-W- " + ze);
            }
            ++i;
        }
    }

    public void includeKE15Resources() throws Exception {
        int i = 0;
        while (i < ke15Files.length) {
            String name = ke15Files[i];
            try {
                this.copySingleFile(name, name, true);
            }
            catch (ZipException ze) {
                System.out.println("-W- " + ze);
            }
            ++i;
        }
    }

    public void createMainClassManifestEntry() throws IOException {
        String s = "Manifest-Version: 1.0\nMain-Class: jfig.gui.PresentationViewer\n";
        ByteArrayInputStream manifestSource = new ByteArrayInputStream(s.getBytes());
        byte[] buffer = new byte[1024];
        int length = 0;
        System.out.println("adding MainClass Manifest entry 'jfig.gui.PresentationViewer'...");
        ZipEntry ZE = new ZipEntry("META-INF/MANIFEST.MF");
        this.ZOS.putNextEntry(ZE);
        while ((length = manifestSource.read(buffer, 0, buffer.length)) >= 0) {
            this.ZOS.write(buffer, 0, length);
        }
        this.ZOS.closeEntry();
    }

    public static void usage() {
        System.out.println("Usage: java hades.utils.MakeJarFromClassList <jarfile> <classlistfile>\nExample: java hades.utils.MakeJarFromClassList /tmp/foo.jar /tmp/bar.txt\nOptions: -magic   include a few important Hades resources\nOptions: -editor  include editor and styx resources\n");
        System.exit(0);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            MakeJarFromClassList.usage();
        }
        try {
            MakeJarFromClassList builder = new MakeJarFromClassList();
            builder.createZipOutputStream(args[0]);
            builder.readClassListFile(args[1]);
            if (args.length > 2 && "-magic".equals(args[2])) {
                builder.includeMagicResources();
            }
            if (args.length > 2 && "-editor".equals(args[2])) {
                builder.includeMagicResources();
                builder.includeStyxResources();
                builder.includeEditorResources();
            }
            if (args.length > 2 && "-ke15".equals(args[2])) {
                builder.includeMagicResources();
                builder.includeStyxResources();
                builder.includeEditorResources();
                builder.includeKE15Resources();
            }
            builder.closeZipOutputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println();
            MakeJarFromClassList.usage();
        }
    }
}

