/*
 * Decompiled with CFR 0.152.
 */
package hades.utils;

import hades.gui.Command;
import hades.gui.Editor;
import hades.gui.ObjectCanvas;
import hades.manager.DesignManager;
import hades.simulator.SimObject;
import hades.utils.NameMangler;
import hades.utils.StringTokenizer;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Constructor;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jfig.canvas.FigTrafo2D;
import jfig.utils.SetupManager;

public class LogPlaybackManager {
    private LineNumberReader reader;
    private Editor editor;
    private JFrame controlFrame;
    private JButton stepButton;
    private JButton stopButton;
    private JButton runButton;
    private JTextField delayTF;
    private JTextField stepsTF;
    private JTextField logTF;
    private JLabel lineNoLabel;
    static /* synthetic */ Class class$hades$gui$Editor;
    static /* synthetic */ Class class$hades$simulator$SimObject;

    public LogPlaybackManager() {
        this.createGUI();
        this.createEditor();
    }

    public void createGUI() {
        this.controlFrame = new JFrame("Control LogPlaybackManager");
        this.stepButton = new JButton("Execute");
        this.stepsTF = new JTextField("5", 6);
        this.delayTF = new JTextField("250", 20);
        this.lineNoLabel = new JLabel("0000");
        this.logTF = new JTextField("", 40);
        this.logTF.setEditable(false);
        JPanel stepsPanel = new JPanel(new FlowLayout(0));
        stepsPanel.add(new JButton("Number of Steps: "));
        stepsPanel.add(this.stepsTF);
        stepsPanel.add(this.stepButton);
        JPanel delayPanel = new JPanel(new FlowLayout(0));
        delayPanel.add(new JButton("Delay [ms]:"));
        delayPanel.add(this.delayTF);
        JPanel statusPanel = new JPanel();
        statusPanel.add(this.lineNoLabel);
        statusPanel.add(this.logTF);
        this.stepButton.addActionListener(new StepListener());
        this.controlFrame.getContentPane().add("North", stepsPanel);
        this.controlFrame.getContentPane().add("Center", delayPanel);
        this.controlFrame.getContentPane().add("South", statusPanel);
        this.controlFrame.pack();
        this.controlFrame.show();
    }

    public void createEditor() {
        SetupManager.setProperty("Hades.UseSwingGUI", "true");
        SetupManager.loadGlobalProperties("hades/.hadesrc");
        SetupManager.loadUserProperties(".hadesrc");
        SetupManager.loadLocalProperties(".hadesrc");
        SetupManager.setProperty("hades.gui.LogManager.enable", "false");
        this.editor = new Editor();
        DesignManager.getDesignManager().setDialogWindowsParentFrame(this.editor.getFrame());
        ObjectCanvas canvas = this.editor.getObjectCanvas();
        canvas.getComponent().removeMouseMotionListener(canvas);
    }

    public void handleMousePressed(String line) {
        StringTokenizer st = new StringTokenizer(line, ", \t");
        String dummy = st.nextToken();
        int sx = Integer.parseInt(st.nextToken());
        int sy = Integer.parseInt(st.nextToken());
        int wx = Integer.parseInt(st.nextToken());
        int wy = Integer.parseInt(st.nextToken());
        String sacm = st.nextToken();
        int ax = Integer.parseInt(st.nextToken());
        int ay = Integer.parseInt(st.nextToken());
        double zoom = Double.parseDouble(st.nextToken());
        int clickCount = 1;
        int modifiers = this.getModifiers(sacm);
        boolean popupTrigger = false;
        final Point anchor = new Point(ax, ay);
        final double z = zoom;
        final MouseEvent MM = new MouseEvent(this.editor.getObjectCanvas().getComponent(), 503, System.currentTimeMillis(), 0, sx, sy, clickCount, false);
        final MouseEvent MP = new MouseEvent(this.editor.getObjectCanvas().getComponent(), 501, System.currentTimeMillis(), modifiers, sx, sy, clickCount, popupTrigger);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    LogPlaybackManager.this.checkTransformationChanged(anchor, z);
                    LogPlaybackManager.this.editor.getObjectCanvas().mouseMoved(MM);
                    LogPlaybackManager.this.editor.getObjectCanvas().mousePressed(MP);
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void handleMouseMoved(String line) {
        StringTokenizer st = new StringTokenizer(line, ", \t");
        String dummy = st.nextToken();
        int sx = Integer.parseInt(st.nextToken());
        int sy = Integer.parseInt(st.nextToken());
        int wx = Integer.parseInt(st.nextToken());
        int wy = Integer.parseInt(st.nextToken());
        String sacm = st.nextToken();
        int ax = Integer.parseInt(st.nextToken());
        int ay = Integer.parseInt(st.nextToken());
        double zoom = Double.parseDouble(st.nextToken());
        int clickCount = 1;
        int modifiers = this.getModifiers(sacm);
        boolean popupTrigger = false;
        final Point anchor = new Point(ax, ay);
        final double z = zoom;
        final MouseEvent me = new MouseEvent(this.editor.getObjectCanvas().getComponent(), 503, System.currentTimeMillis(), modifiers, sx, sy, clickCount, popupTrigger);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    LogPlaybackManager.this.checkTransformationChanged(anchor, z);
                    LogPlaybackManager.this.editor.getObjectCanvas().mouseMoved(me);
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void handleMouseReleased(String line) {
        StringTokenizer st = new StringTokenizer(line, ", \t");
        String dummy = st.nextToken();
        int sx = Integer.parseInt(st.nextToken());
        int sy = Integer.parseInt(st.nextToken());
        int clickCount = 1;
        boolean popupTrigger = false;
        final MouseEvent me = new MouseEvent(this.editor.getObjectCanvas().getComponent(), 502, System.currentTimeMillis(), this.getModifiers("----"), sx, sy, clickCount, popupTrigger);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    LogPlaybackManager.this.editor.getObjectCanvas().mouseReleased(me);
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void checkTransformationChanged(Point anchor, double zoom) {
        FigTrafo2D trafo = this.editor.getObjectCanvas().getTrafo();
        if (!trafo.getAnchor().equals(anchor)) {
            trafo.setAnchor(anchor);
        }
        if (trafo.getZoom() != zoom) {
            trafo.set_zoom(zoom);
        }
    }

    public void handleShowPopup(String line) {
        StringTokenizer st = new StringTokenizer(line, ", \t");
        String dummy = st.nextToken();
        int sx = Integer.parseInt(st.nextToken());
        int sy = Integer.parseInt(st.nextToken());
        int wx = Integer.parseInt(st.nextToken());
        int wy = Integer.parseInt(st.nextToken());
        Point sp = new Point(sx, sy);
        Point wp = new Point(wx, wy);
        this.editor.getObjectCanvas().setPopupPosition(sp, wp);
    }

    public void handleSetPosition(String line) {
        StringTokenizer st = new StringTokenizer(line, ", \t");
        String dummy = st.nextToken();
        int sx = Integer.parseInt(st.nextToken());
        int sy = Integer.parseInt(st.nextToken());
        int wx = Integer.parseInt(st.nextToken());
        int wy = Integer.parseInt(st.nextToken());
        Point sp = new Point(sx, sy);
        Point wp = new Point(wx, wy);
        Command command = this.editor.getCommand();
        if (command != null) {
            command.setPosition(sp, wp);
        }
    }

    public int getModifiers(String s) {
        int modifiers = 0;
        if (s.indexOf("s") >= 0) {
            modifiers |= 1;
        }
        if (s.indexOf("a") >= 0) {
            modifiers |= 8;
        }
        if (s.indexOf("c") >= 0) {
            modifiers |= 2;
        }
        if (s.indexOf("m") >= 0) {
            modifiers |= 4;
        }
        return modifiers;
    }

    public void handleKeyPressed(String line) {
        StringTokenizer st = new StringTokenizer(line);
        String dummy = st.nextToken();
        int modifiers = this.getModifiers(st.nextToken());
        int code = Integer.parseInt(st.nextToken());
        String key = NameMangler.decodeUnicodeEscapes(st.nextToken());
        String text = st.nextToken();
        final KeyEvent ke = new KeyEvent(this.editor.getObjectCanvas().getComponent(), 401, System.currentTimeMillis(), modifiers, code, key.charAt(0));
        LogPlaybackManager.msg("\n\n keyPressed: ");
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    LogPlaybackManager.this.editor.keyPressed(ke);
                    LogPlaybackManager.this.editor.keyTyped(ke);
                    LogPlaybackManager.msg("keyPressed ok, command= " + LogPlaybackManager.this.editor.getCommand() + "\n\n");
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void handleCancel(String line) {
        if (line.indexOf("NEXT") >= 0) {
            this.editor.doCancelAndEnablePopupOnNextMouseRelease();
        } else {
            this.editor.doCancel();
        }
    }

    public void handleMethodCall(String line) {
        String arg;
        StringTokenizer st = new StringTokenizer(line, " \t");
        String dummy = st.nextToken();
        final String methodname = st.nextToken();
        String string = arg = st.hasMoreTokens() ? st.nextToken() : "";
        if ("doExit".equals(methodname)) {
            return;
        }
        if ("doOpenFile".equals(methodname) && "".equals(arg)) {
            return;
        }
        if ("doSaveFile".equals(methodname) && "".equals(arg)) {
            return;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    LogPlaybackManager.msg("-#- call: " + methodname + " " + arg);
                    LogPlaybackManager.this.editor.__call(methodname, arg);
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void handleCommand(String line) {
        StringTokenizer st = new StringTokenizer(line, " \t");
        String dummy = st.nextToken();
        String classname = st.nextToken();
        String arg = st.hasMoreTokens() ? st.nextToken() : "";
        Command tmp = null;
        if (classname.equals("hades.gui.ColibriCreateCommand")) {
            if ("".equals(arg)) {
                return;
            }
            tmp = this.handleColibriCreateCommand(arg);
        } else {
            tmp = this.editor.createCommandByName(classname);
            if (arg != null && !"".equals(arg)) {
                LogPlaybackManager.msg("-E- handleCommand: optional arguments NOT YET SUPPORTED: ");
                LogPlaybackManager.msg("-E- arg is '" + arg + "'");
            }
        }
        final Command cmd = tmp;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    LogPlaybackManager.this.editor.setCommand(cmd);
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public Command handleColibriCreateCommand(String arg) {
        Command command = null;
        try {
            Class<?> clazz = Class.forName("hades.gui.ColibriCreateCommand");
            Class[] formals = new Class[]{class$hades$gui$Editor == null ? (class$hades$gui$Editor = LogPlaybackManager.class$("hades.gui.Editor")) : class$hades$gui$Editor, class$hades$simulator$SimObject == null ? (class$hades$simulator$SimObject = LogPlaybackManager.class$("hades.simulator.SimObject")) : class$hades$simulator$SimObject};
            SimObject simobj = DesignManager.getDesignManager().getSimObject(arg);
            Object[] actuals = new Object[]{this.editor, simobj};
            Constructor<?> cstr = clazz.getConstructor(formals);
            command = (Command)cstr.newInstance(actuals);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return command;
    }

    public void playbackCommands(int n_steps, int millis) {
        String line = null;
        try {
            int i = 0;
            while (i < n_steps) {
                line = this.reader.readLine();
                if (line != null) {
                    this.parseLine(line);
                    this.lineNoLabel.setText("" + this.reader.getLineNumber());
                    this.logTF.setText(line);
                    Thread.sleep(millis);
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            LogPlaybackManager.msg("-E- Internal error: " + e);
            e.printStackTrace();
        }
    }

    public void parse(InputStream fis) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(fis));
        String line = null;
        while ((line = br.readLine()) != null) {
            this.parseLine(line);
            Thread.sleep(25L);
        }
    }

    public void parseLine(String line) {
        LogPlaybackManager.msg("parsing: " + line);
        if (line.length() >= 2 && !line.startsWith("#") && !line.startsWith(" ")) {
            if (line.startsWith("m:")) {
                this.handleMousePressed(line);
            } else if (line.startsWith("v:")) {
                this.handleMouseMoved(line);
            } else if (line.startsWith("r:")) {
                this.handleMouseReleased(line);
            } else if (line.startsWith("k:")) {
                this.handleKeyPressed(line);
            } else if (line.startsWith("p:")) {
                this.handleShowPopup(line);
            } else if (line.startsWith("s:")) {
                this.handleSetPosition(line);
            } else if (line.startsWith("C:")) {
                this.handleCommand(line);
            } else if (line.startsWith("F:")) {
                this.handleMethodCall(line);
            } else if (line.startsWith("*:")) {
                this.handleCancel(line);
            } else {
                LogPlaybackManager.msg("ERROR: unknown log entry: " + line);
            }
        }
    }

    public static void msg(String s) {
        System.out.println(s);
    }

    public static void main(String[] args) throws Exception {
        FileInputStream fis = new FileInputStream(args[0]);
        LogPlaybackManager lpm = new LogPlaybackManager();
        lpm.reader = new LineNumberReader(new InputStreamReader(fis));
        LogPlaybackManager.msg("-#- Log playback ok.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class PlaybackThread
    extends Thread {
        int n_steps = 1;
        int millis = 500;

        public PlaybackThread(int n_steps, int millis) {
            this.n_steps = n_steps;
            this.millis = millis;
        }

        public void run() {
            LogPlaybackManager.msg("-I- Executing: " + this.n_steps + " " + this.millis);
            LogPlaybackManager.this.playbackCommands(this.n_steps, this.millis);
            LogPlaybackManager.msg("... ok.");
        }
    }

    public class StepListener
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            int n_steps = 1;
            int millis = 250;
            try {
                n_steps = Integer.parseInt(LogPlaybackManager.this.stepsTF.getText().trim());
                millis = Integer.parseInt(LogPlaybackManager.this.delayTF.getText().trim());
            }
            catch (Exception e) {
                // empty catch block
            }
            new PlaybackThread(n_steps, millis).start();
        }
    }
}

