/*
 * Decompiled with CFR 0.152.
 */
package hades.utils;

import hades.utils.HexFormat;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class IntelHexFile {
    public void parsePic16Bit(InputStream IS, long[] data) throws Exception {
        BufferedReader BR = new BufferedReader(new InputStreamReader(IS));
        String line = null;
        while ((line = BR.readLine()) != null) {
            this.parseLine16Bit(line, data);
        }
    }

    public void parseLine16Bit(String line, long[] data) throws Exception {
        if (line.charAt(0) != ':') {
            throw new Exception("-E- expected a ':', got " + line);
        }
        if (line.equals(":00000001FF")) {
            return;
        }
        int checksum = 0;
        int i = 1;
        int n_bytes = this.parseByte(line, i);
        int n_words = n_bytes >> 1;
        checksum += n_bytes;
        int a1 = this.parseByte(line, i += 2);
        int a0 = this.parseByte(line, i += 2);
        int byte_addr = a1 * 256 + a0;
        int word_addr = byte_addr >> 1;
        checksum += a1;
        checksum += a0;
        int type = this.parseByte(line, i += 2);
        i += 2;
        if (type != 0) {
            if (type == 4) {
                System.err.println("-W- Ignoring unknown record type '" + type + "' in line: " + line);
                return;
            }
            throw new Exception("-E- Unsupported record type '" + type + "' in line: " + line);
        }
        checksum += type;
        int j = 0;
        while (j < n_words) {
            int w0 = this.parseByte(line, i);
            int w1 = this.parseByte(line, i += 2);
            i += 2;
            if (word_addr + j < data.length) {
                data[word_addr + j] = w1 * 256 + w0;
            } else {
                IntelHexFile.msg("-W- ignoring out of range address " + (word_addr + j));
            }
            checksum += w0;
            checksum += w1;
            ++j;
        }
        int file_checksum = this.parseByte(line, i);
        if ((checksum = ~checksum + 1 & 0xFF) != file_checksum) {
            throw new Exception("-E- Checksum mismatch, internal=" + checksum + " file=" + file_checksum + " on line: " + line);
        }
    }

    public int parseByte(String line, int index) throws Exception {
        String s = line.substring(index, index + 2);
        return Integer.parseInt(s, 16);
    }

    public void parseIntel8Bit(InputStream IS, long[] data) throws Exception {
        BufferedReader BR = new BufferedReader(new InputStreamReader(IS));
        String line = null;
        while ((line = BR.readLine()) != null) {
            this.parseLine8Bit(line, data);
        }
    }

    public void parseLine8Bit(String line, long[] data) throws Exception {
        if (line.charAt(0) != ':') {
            throw new Exception("-E- expected a ':', got " + line);
        }
        if (line.equals(":00000001FF")) {
            return;
        }
        int checksum = 0;
        int i = 1;
        int n_bytes = this.parseByte(line, i);
        checksum += n_bytes;
        int a1 = this.parseByte(line, i += 2);
        int a0 = this.parseByte(line, i += 2);
        int byte_addr = a1 * 256 + a0;
        checksum += a1;
        checksum += a0;
        int type = this.parseByte(line, i += 2);
        i += 2;
        if (type != 0) {
            // empty if block
        }
        checksum += type;
        int j = 0;
        while (j < n_bytes) {
            int w0 = this.parseByte(line, i);
            i += 2;
            if (byte_addr + j < data.length) {
                data[byte_addr + j] = w0;
            } else {
                IntelHexFile.msg("-W- ignoring out of range address " + (byte_addr + j));
            }
            checksum += w0;
            ++j;
        }
        int file_checksum = this.parseByte(line, i);
        if ((checksum = ~checksum + 1 & 0xFF) != file_checksum) {
            throw new Exception("-E- Checksum mismatch, internal=" + checksum + " file=" + file_checksum + " on line: " + line);
        }
    }

    public void writeHexFile(OutputStream OS, long[] data) throws Exception {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(OS));
        this.writeHexFileHeader(writer);
        this.writeHexFileData(writer, data);
        this.writeHexFileTrailer(writer);
        writer.flush();
        writer.close();
    }

    private void writeHexFileData(PrintWriter writer, long[] data) throws Exception {
        int max_address = data.length;
        int i = 0;
        while (i < max_address) {
            int checksum = 0;
            int chars_per_line = Math.min(max_address - i, 16);
            checksum += chars_per_line;
            writer.print(":");
            this.writeByte(writer, chars_per_line);
            this.writeInt16(writer, i);
            checksum += i & 0xFF;
            checksum += (i & 0xFF00) >> 8;
            writer.print("00");
            int j = 0;
            while (j < chars_per_line) {
                this.writeByte(writer, data[i + j]);
                checksum += (int)(data[i + j] & 0xFFL);
                ++j;
            }
            this.writeByte(writer, ~checksum + 1 & 0xFF);
            writer.println();
            i += 16;
        }
    }

    private void writeInt16(PrintWriter writer, long i) throws Exception {
        writer.print(HexFormat.getHexString(i, 4));
    }

    private void writeByte(PrintWriter writer, long i) throws Exception {
        writer.print(HexFormat.getHexString(i, 2));
    }

    private void writeHexFileHeader(PrintWriter writer) throws Exception {
    }

    private void writeHexFileTrailer(PrintWriter writer) throws Exception {
        writer.print(":00000001FF");
        writer.write(13);
        writer.write(10);
    }

    public void writeHexFile16Bit(OutputStream OS, long[] data) throws Exception {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(OS));
        this.writeHexFile16Bit(writer, data);
    }

    public void writeHexFile16Bit(PrintWriter writer, long[] data) throws Exception {
        this.writeHexFileHeader(writer);
        this.writeHexFileData16(writer, data);
        this.writeHexFileTrailer(writer);
        writer.flush();
        writer.close();
    }

    private void writeHexFileData16(PrintWriter writer, long[] data) throws Exception {
        int max_address = data.length;
        int i = 0;
        while (i < max_address) {
            int checksum = 0;
            int chars_per_line = Math.min(max_address - i, 8);
            checksum += 2 * chars_per_line;
            writer.print(":");
            this.writeByte(writer, 2 * chars_per_line);
            int addr = 2 * i;
            this.writeInt16(writer, addr);
            checksum += addr & 0xFF;
            checksum += (addr & 0xFF00) >> 8;
            writer.print("00");
            int j = 0;
            while (j < chars_per_line) {
                int lower = (int)(data[i + j] & 0xFFL);
                int upper = (int)((data[i + j] & 0xFF00L) >> 8);
                this.writeByte(writer, lower);
                checksum += lower;
                this.writeByte(writer, upper);
                checksum += upper;
                ++j;
            }
            this.writeByte(writer, ~checksum + 1 & 0xFF);
            writer.write(13);
            writer.write(10);
            i += 8;
        }
    }

    public static void msg(String s) {
        System.out.println(s);
    }

    public static void main(String[] argv) {
        if (argv.length != 1) {
            IntelHexFile.msg("Usage: java hades.utils.IntelHexFile <file.hex>");
            return;
        }
        IntelHexFile.msg("IntelHexFile selftest...");
        try {
            IntelHexFile parser = new IntelHexFile();
            FileInputStream fs = new FileInputStream(argv[0]);
            long[] PMEM = new long[256];
            IntelHexFile.msg("phase 1: parsing (8 bit) format...");
            parser.parseIntel8Bit(fs, PMEM);
            IntelHexFile.msg("phase 2: writing (8 bit) format to /tmp/mcs.hex");
            FileOutputStream os = new FileOutputStream("/tmp/mcs.hex");
            parser.writeHexFile(os, PMEM);
            IntelHexFile.msg("phase 3: parsing (16 bit PIC) format...");
            new IntelHexFile().parsePic16Bit(fs, PMEM);
            int i = 0;
            while (i < 256) {
                IntelHexFile.msg("" + i + " " + Long.toString(PMEM[i], 16));
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

