/*
 * Decompiled with CFR 0.152.
 */
package hades.utils;

import hades.models.Design;
import hades.models.io.Ipin;
import hades.models.io.Opin;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimObject;
import java.util.Enumeration;

public class Flatten {
    Design design;

    public void setDesign(Design _design) {
        this.design = _design;
    }

    public void flattenDesign() {
        Enumeration e = this.design.getComponents();
        while (e.hasMoreElements()) {
            Object tmp = e.nextElement();
            if (!(tmp instanceof Design)) continue;
            Design subdesign = (Design)tmp;
            Flatten.msg("-#- found subdesign: " + subdesign);
            Port[] ports = subdesign.getPorts();
            int i = 0;
            while (i < ports.length) {
                Flatten.msg("     ports: " + ports[i]);
                Flatten.msg("     parent: " + ports[i].getParent());
                Flatten.msg("     handler: " + ports[i].getHandler());
                Flatten.msg("");
                SimObject handler = ports[i].getHandler();
                if (handler instanceof Ipin) {
                    this.handleIpin(subdesign, ports[i]);
                }
                if (handler instanceof Opin) {
                    this.handleOpin(subdesign, ports[i]);
                }
                ++i;
            }
            Flatten ff = new Flatten();
            ff.setDesign(subdesign);
            ff.flattenDesign();
        }
    }

    public void handleIpin(Design subdesign, Port port) {
        Ipin ipin = (Ipin)port.getHandler();
        Signal toplevel = ipin.getPorts()[1].getSignal();
        Signal local = ipin.getPorts()[0].getSignal();
        Flatten.msg("     handleIpin: " + ipin);
        Flatten.msg("       toplevel signal: " + toplevel);
        Flatten.msg("       local signal: " + local);
        subdesign.deleteComponent(ipin);
        this.merge(toplevel, local);
    }

    public void handleOpin(Design subdesign, Port port) {
        Opin opin = (Opin)port.getHandler();
        Signal toplevel = opin.getPorts()[1].getSignal();
        Signal local = opin.getPorts()[0].getSignal();
        Flatten.msg("     handleIpin: " + opin);
        Flatten.msg("       toplevel signal: " + toplevel);
        Flatten.msg("       local signal: " + local);
        subdesign.deleteComponent(opin);
        this.merge(toplevel, local);
    }

    public void merge(Signal master, Signal victim) {
        Flatten.msg("merging signal " + master + " with victim " + victim);
        if (master == null || victim == null) {
            return;
        }
        Port[] vreceivers = victim.getReceivers();
        Port[] vsenders = victim.getSenders();
        int i = 0;
        while (i < vreceivers.length) {
            vreceivers[i].setSignal(null);
            master.connect(vreceivers[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < vsenders.length) {
            vsenders[i2].setSignal(null);
            master.connect(vsenders[i2]);
            ++i2;
        }
    }

    public static void msg(String s) {
        System.err.println(s);
    }
}

