/*
 * Decompiled with CFR 0.152.
 */
package hades.utils;

import hades.gui.Console;
import hades.symbols.BboxRectangle;
import hades.symbols.ColoredCircle;
import hades.symbols.ColoredPolyline;
import java.io.PrintWriter;
import java.util.Enumeration;
import jfig.objects.FigArc;
import jfig.objects.FigAttribs;
import jfig.objects.FigBbox;
import jfig.objects.FigBezier;
import jfig.objects.FigCompound;
import jfig.objects.FigEllipse;
import jfig.objects.FigImage;
import jfig.objects.FigObject;
import jfig.objects.FigPolyline;
import jfig.objects.FigPrintWriter;
import jfig.objects.FigRectangle;
import jfig.objects.FigSpline;
import jfig.objects.FigText;
import jfig.objects.FigTrigger;
import jfig.utils.ExceptionTracer;

public class FigWriter
extends jfig.objects.FigWriter {
    protected int colorOption = 2;
    public static final int FULL_COLORS = 2;
    public static final int IO_COLORS = 3;
    public static final int BLACK_WHITE = 4;

    public void setColorOption(int c) {
        if (c < 2 || c > 4) {
            this.message("-W- FigWriter.setColorOption: out of range: " + c);
            this.message("-W- using black and white instead!");
            this.colorOption = 4;
        } else {
            this.colorOption = c;
        }
    }

    public int getColorOption() {
        return this.colorOption;
    }

    public int getLineColorIndex(FigAttribs attribs) {
        if (this.colorOption == 4) {
            return 0;
        }
        if (this.colorOption == 3) {
            if (this.currentObject instanceof ColoredPolyline) {
                return super.getLineColorIndex(attribs);
            }
            return 0;
        }
        return super.getLineColorIndex(attribs);
    }

    public int getFillColorIndex(FigAttribs attribs) {
        if (this.colorOption == 4) {
            return 0;
        }
        if (this.colorOption == 3) {
            if (this.currentObject instanceof ColoredCircle) {
                return super.getFillColorIndex(attribs);
            }
            if (this.currentObject instanceof BboxRectangle) {
                return 0;
            }
            return 0;
        }
        return super.getFillColorIndex(attribs);
    }

    public int getAreaFill(FigAttribs attribs) {
        if (this.colorOption != 2 && this.currentObject instanceof BboxRectangle) {
            return 1;
        }
        return super.getAreaFill(attribs);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int write_fig31_file(PrintWriter pw, boolean top_level, Enumeration OE) {
        FigObject obj = null;
        FigPrintWriter f = new FigPrintWriter(pw);
        int n_errors = 0;
        try {
            if (top_level) {
                n_errors = 0;
                this.write_fig31_header(f, new FigAttribs());
                this.write_fig31_pseudocolors(f);
            }
            if (OE == null) {
                return 1;
            }
            while (true) {
                if (!OE.hasMoreElements()) {
                    return n_errors;
                }
                obj = (FigObject)OE.nextElement();
                if (!obj.isVisible()) continue;
                this.currentObject = obj;
                if (obj instanceof FigCompound) {
                    FigBbox bbox = obj.getBbox();
                    String s = null;
                    s = "6 " + this.fig_scale(bbox.getXr()) + " " + this.fig_scale(bbox.getYt()) + " " + this.fig_scale(bbox.getXl()) + " " + this.fig_scale(bbox.getYb());
                    f.print(s + '\n');
                    this.write_fig31_file((PrintWriter)f, false, ((FigCompound)obj).getMembers().elements());
                    f.print("-6\n");
                    continue;
                }
                if (obj instanceof FigText) {
                    this.write_fig31_text(f, (FigText)obj);
                    continue;
                }
                if (obj instanceof FigEllipse) {
                    this.write_fig31_ellipse(f, (FigEllipse)obj);
                    continue;
                }
                if (obj instanceof FigArc) {
                    this.write_fig31_arc(f, (FigArc)obj);
                    continue;
                }
                if (obj instanceof FigBezier) {
                    this.write_fig31_spline(f, (FigBezier)obj);
                    continue;
                }
                if (obj instanceof FigSpline) {
                    this.write_fig31_spline(f, (FigSpline)obj);
                    continue;
                }
                if (obj instanceof FigPolyline) {
                    this.write_fig31_polyline(f, (FigPolyline)obj);
                    continue;
                }
                if (obj instanceof FigTrigger) {
                    this.write_jfig_trigger(f, (FigTrigger)obj);
                    continue;
                }
                if (obj instanceof FigImage) {
                    this.write_fig31_rectangle(f, (FigImage)obj);
                    continue;
                }
                if (obj instanceof FigRectangle) {
                    this.write_fig31_rectangle(f, (FigRectangle)obj);
                    continue;
                }
                System.err.println("write_fig31_file: unknown object " + obj.toString());
                ++n_errors;
            }
        }
        catch (Exception e) {
            this.message("-E- FigWriter: couldn't write: " + e);
            ExceptionTracer.trace(e);
            return n_errors;
        }
    }

    public void message(String msg) {
        Console.getConsole().message(msg);
    }

    public String toString() {
        return "FigWriter[" + super.toString() + "]";
    }
}

