/*
 * Decompiled with CFR 0.152.
 */
package hades.utils;

import hades.manager.DesignManager;
import hades.models.Design;
import hades.signals.Signal;
import hades.simulator.SimObject;
import hades.utils.NameMangler;
import hades.utils.StringTokenizer;
import java.util.Hashtable;

public class DesignHierarchyNavigator {
    private Design design;
    private Design root;
    private Hashtable signalNameTable;
    private Hashtable simobjectNameTable;

    public DesignHierarchyNavigator(Design design) {
        this.design = design;
        this.signalNameTable = new Hashtable();
        this.simobjectNameTable = new Hashtable();
        this.root = DesignHierarchyNavigator.findRootDesign(design);
    }

    public static Design findRootDesign(Design design) {
        if (design == null) {
            return null;
        }
        Design tmp = design;
        while (tmp.getParent() != null) {
            tmp = (Design)tmp.getParent();
            DesignHierarchyNavigator.msg("-#- DHM.findRootDesign: " + tmp);
        }
        return tmp;
    }

    public Design findLeafDesign(String[] tokens) {
        DesignHierarchyNavigator.msg("-#- DHM.findLeafDesign: " + tokens);
        try {
            Design tmp = this.root;
            int i = 1;
            while (i < tokens.length - 1) {
                tmp = (Design)tmp.getComponent(tokens[i]);
                DesignHierarchyNavigator.msg("-#- DHM.findLeafDesign: " + tmp);
                ++i;
            }
            return tmp;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Signal findSignal(String name) {
        if (name == null) {
            return null;
        }
        Signal signal = (Signal)this.signalNameTable.get(name);
        if (signal != null) {
            return signal;
        }
        if (this.isQualifiedName(name)) {
            String[] tokens = this.tokenizeName(name);
            Design tmp = this.findLeafDesign(tokens);
            return tmp.getSignal(tokens[tokens.length - 1]);
        }
        return this.design.getSignal(name);
    }

    public SimObject findSimObject(String name) {
        if (name == null) {
            return null;
        }
        SimObject simobj = (SimObject)this.simobjectNameTable.get(name);
        if (simobj != null) {
            return simobj;
        }
        if (this.isQualifiedName(name)) {
            String[] tokens = this.tokenizeName(name);
            Design tmp = this.findLeafDesign(tokens);
            return tmp.getComponent(tokens[tokens.length - 1]);
        }
        return this.design.getComponent(name);
    }

    public String[] tokenizeName(String name) {
        StringTokenizer st = new StringTokenizer(name, "/");
        int n_tokens = st.countTokens();
        String[] tokens = new String[n_tokens];
        int i = 0;
        while (i < n_tokens) {
            tokens[i] = NameMangler.decodeUnicodeEscapes(st.nextToken());
            ++i;
        }
        return tokens;
    }

    public boolean isQualifiedName(String name) {
        if (name == null) {
            return false;
        }
        if (name.length() < 1) {
            return false;
        }
        return name.charAt(0) == '/';
    }

    private static void msg(Object s) {
        System.out.println(s);
    }

    public static void main(String[] argv) throws Exception {
        DesignHierarchyNavigator.msg("DesignHierarchyNavigator selftest started...");
        String dname = "/hades/examples/cla/adder8.hds";
        Design tmp = DesignManager.getDesignManager().getDesign(null, dname, true);
        DesignHierarchyNavigator dhn = new DesignHierarchyNavigator(tmp);
        DesignHierarchyNavigator.msg(dhn.findSimObject("CLA5"));
        DesignHierarchyNavigator.msg(dhn.findSignal("n39"));
        DesignHierarchyNavigator.msg(dhn.findSimObject("/Adder8CLA/i1"));
        DesignHierarchyNavigator.msg(dhn.findSignal("/Adder8CLA/n67"));
        DesignHierarchyNavigator.msg(dhn.findSimObject("/Adder8CLA/CLA5/i5"));
        DesignHierarchyNavigator.msg(dhn.findSignal("/Adder8CLA/CLA5/n7"));
    }
}

