/*
 * Decompiled with CFR 0.152.
 */
package hades.symbols;

import hades.signals.Signal;
import hades.symbols.ColorSource;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.StringTokenizer;
import jfig.canvas.FigTrafo2D;
import jfig.gui.ColorCache;
import jfig.objects.FigAttribs;
import jfig.objects.FigPolyline;

public class WireSegment
extends FigPolyline
implements Serializable {
    private Signal signal;
    private ColorSource colorSource;

    public WireSegment() {
        this.build_attribs();
        this.signal = null;
    }

    public WireSegment(Signal signal) {
        this();
        this.signal = signal;
    }

    public Signal getSignal() {
        return this.signal;
    }

    public void setSignal(Signal s) {
        this.signal = s;
        this.setColorSource(this.signal);
    }

    public void setColorSource(ColorSource _colorSource) {
        this.colorSource = _colorSource;
    }

    public boolean initialize(String s) {
        int n = 0;
        int x = 0;
        int y = 0;
        try {
            StringTokenizer st = new StringTokenizer(s);
            n = Integer.parseInt(st.nextToken());
            Point[] pp = new Point[n];
            int i = 0;
            while (i < n) {
                x = Integer.parseInt(st.nextToken());
                y = Integer.parseInt(st.nextToken());
                pp[i] = new Point(x, y);
                ++i;
            }
            super.setPoints(pp);
        }
        catch (Exception e) {
            System.err.println("" + e);
        }
        return true;
    }

    protected void build_attribs() {
        FigAttribs attribs = new FigAttribs();
        attribs.lineColor = attribs.fillColor = ColorCache.getColorCache().get(1);
        attribs.fig_fill_color = 1;
        attribs.fig_line_color = 1;
        attribs.fillStyle = 1;
        attribs.currentLayer = 8;
        attribs.lineWidth = 30.0;
        attribs.arrowMode = 0;
        attribs.lineStyle = 0;
        attribs.fig_join_style = 2;
        attribs.fig_cap_style = 1;
        attribs.cornerRadius = 0;
        super.setAttributes(attribs);
    }

    public double getEuclideanDistance(Point wp) {
        Point[] points = this.getPoints();
        int dx = points[1].x - points[0].x;
        int dy = points[1].y - points[0].y;
        int dx1 = wp.x - points[1].x;
        int dy1 = wp.y - points[1].y;
        int dx0 = wp.x - points[0].x;
        int dy0 = wp.y - points[0].y;
        double frac = Math.sqrt(dx0 * dx0 + dy0 * dy0) + Math.sqrt(dx1 * dx1 + dy1 * dy1);
        return frac /= Math.sqrt(dx * dx + dy * dy);
    }

    public void writeAsResource(PrintWriter ps) {
        Point[] pp = this.getPoints();
        String s = this.getClass().getName() + " " + pp.length;
        int i = 0;
        while (i < pp.length) {
            s = s + " " + pp[i].x + " " + pp[i].y;
            ++i;
        }
        ps.println(s);
    }

    public void paint(Graphics g) {
        Color c;
        if (this.colorSource != null && this.attribs.lineColor != (c = this.colorSource.getColor())) {
            this.attribs.setLineColor(c);
            this.rebuild();
        }
        super.paint(g);
    }

    public void paint(Graphics g, FigTrafo2D trafo) {
        Color c;
        if (this.colorSource != null && this.attribs.lineColor != (c = this.colorSource.getColor())) {
            this.attribs.setLineColor(c);
            this.rebuild();
        }
        super.paint(g, trafo);
    }

    public String toString() {
        return "WireSegment[" + super.toString() + "]";
    }
}

