/*
 * Decompiled with CFR 0.152.
 */
package hades.symbols;

import hades.gui.Console;
import hades.gui.LayerTable;
import hades.manager.DesignManager;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.symbols.InstanceLabel;
import hades.symbols.PortSymbol;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import jfig.objects.FigAttribs;
import jfig.objects.FigBaseobject;
import jfig.objects.FigCompound;
import jfig.objects.FigObject;
import jfig.objects.FigObjectList;
import jfig.objects.ListNode;
import jfig.utils.ExceptionTracer;

public class Symbol
extends FigCompound
implements Serializable {
    private SimObject parent = null;
    private Point pos = new Point(0, 0);
    private double rotationAngle;
    private boolean isMirroredX;
    private boolean isMirroredY;
    private static boolean debug = false;
    private static int SYMBOL_LAYER = 50;

    public Symbol() {
        this.setLayer(SYMBOL_LAYER);
        this.isMirroredX = false;
        this.isMirroredY = false;
        this.rotationAngle = 0.0;
    }

    public void setParent(SimObject parent) {
        this.parent = parent;
    }

    public void setLayer(int layer) {
        if (debug) {
            System.err.println("Symbol.setLayer():" + layer);
        }
        FigAttribs attr = this.getAttributes();
        attr.currentLayer = layer;
        this.setAttributes(attr);
    }

    public Point getPos() {
        return new Point(this.pos);
    }

    public void move(int dx, int dy) {
        this.pos.x += dx;
        this.pos.y += dy;
        super.move(dx, dy);
    }

    public SimObject getParent() {
        return this.parent;
    }

    public void setInstanceLabel(String name) {
        FigObjectList list = this.getMembers();
        ListNode tmp = list.get_first();
        while (tmp != null) {
            if (tmp.get_obj() instanceof InstanceLabel) {
                ((InstanceLabel)tmp.get_obj()).setText(name);
            }
            tmp = list.get_next(tmp);
        }
    }

    public PortSymbol getPortSymbol(String name) {
        FigObjectList list = this.getMembers();
        ListNode tmp = list.get_first();
        while (tmp != null) {
            PortSymbol sym;
            if (tmp.get_obj() instanceof PortSymbol && (sym = (PortSymbol)tmp.get_obj()).getName().equals(name)) {
                return sym;
            }
            tmp = list.get_next(tmp);
        }
        System.err.println("-E- Symbol.getPortSymbol: no port named '" + name + "' exists on this symbol");
        return null;
    }

    public Point getPortPosition(String name) {
        PortSymbol tmp = this.getPortSymbol(name);
        if (tmp == null) {
            return null;
        }
        return tmp.getPosition();
    }

    public Point getPortPosition(Port port) {
        PortSymbol tmp = this.getPortSymbol(port.getName());
        if (tmp == null) {
            return null;
        }
        return tmp.getPosition();
    }

    public String[] getPortNames() {
        FigObjectList list = this.getMembers();
        int count = 0;
        ListNode tmp = list.get_first();
        while (tmp != null) {
            if (tmp.get_obj() instanceof PortSymbol) {
                ++count;
            }
            tmp = list.get_next(tmp);
        }
        String[] names = new String[count];
        int i = 0;
        tmp = list.get_first();
        while (tmp != null) {
            if (tmp.get_obj() instanceof PortSymbol) {
                names[i++] = ((PortSymbol)tmp.get_obj()).getName();
            }
            tmp = list.get_next(tmp);
        }
        return names;
    }

    public Enumeration elements() {
        return this.getMembers().elements();
    }

    public void setVisibility(LayerTable lt) {
        this.setVisible(true);
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            FigObject tmp = (FigObject)e.nextElement();
            boolean b = lt.isVisible(tmp);
            tmp.setVisible(b);
        }
    }

    public String getOrientationString() {
        String s = "@";
        if (!this.isMirroredX && !this.isMirroredY && this.rotationAngle == 0.0) {
            s = s + "N";
        }
        if (this.isMirroredX) {
            s = s + "X";
        }
        if (this.isMirroredY) {
            s = s + "Y";
        }
        if (this.rotationAngle != 0.0) {
            s = s + "R" + this.rotationAngle;
        }
        return s;
    }

    public void setOrientation(String s) {
        if (s == null) {
            return;
        }
        if (s.indexOf(88) > 0) {
            this.mirrorX(this.x, this.y);
        }
        if (s.indexOf(89) > 0) {
            this.mirrorY(this.x, this.y);
        }
        if (s.indexOf(82) > 0) {
            double angle;
            try {
                angle = Double.valueOf(s.substring(s.indexOf(82), s.length()));
            }
            catch (Exception e) {
                angle = 0.0;
            }
            this.message("-E- Symbol rotation (" + angle + ") not yet supported!");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void initializeFromResource(SimObject parent) {
        if (parent == null) {
            System.err.println("-E- Symbol.initializeFromResource(): parent is null!");
            return;
        }
        Class<?> memberClass = null;
        FigObject tmp = null;
        InputStream is = null;
        BufferedReader br = null;
        try {
            String line;
            if (debug) {
                System.out.println("Symbol.initializeFromResource(): trying to read from " + parent.getSymbolResourceName());
            }
            if ((is = DesignManager.getDesignManager().getInputStream(parent, parent.getSymbolResourceName())) == null) {
                this.message("-E- Symbol resource file not found: " + parent.getSymbolResourceName());
                return;
            }
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                void var6_6;
                if (var6_6.length() < 1 || var6_6.startsWith("#")) continue;
                int idx = var6_6.indexOf(32);
                String className = var6_6.substring(0, idx);
                String restOfLine = var6_6.substring(idx + 1);
                if (debug) {
                    System.out.println("initializeFromResource: line='" + (String)var6_6 + "' className='" + className + "' restOfLine='" + restOfLine + "'");
                }
                memberClass = Class.forName(className);
                tmp = (FigObject)memberClass.newInstance();
                tmp.initialize(restOfLine);
                this.fastAddMember(tmp);
            }
            this.update_bbox();
            this.build_sc_bbox();
            this.parent = parent;
            this.setLayer(SYMBOL_LAYER);
            br.close();
            is.close();
        }
        catch (Exception e) {
            this.message("-E- Symbol.initializeFromResource():" + e);
            ExceptionTracer.trace(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void initializeFromFile(String filename) {
        Class<?> memberClass = null;
        FigObject tmp = null;
        FileInputStream is = null;
        try {
            String line;
            if (debug) {
                System.out.println("initializeFromFile: trying to read from " + filename);
            }
            if ((is = new FileInputStream(filename)) == null) {
                throw new Exception("file not found: " + filename);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                void var6_7;
                int idx = var6_7.indexOf(32);
                String className = var6_7.substring(0, idx);
                String restOfLine = var6_7.substring(idx + 1);
                if (debug) {
                    System.out.println("initializeFromFile: line='" + (String)var6_7 + "' className='" + className + "' restOfLine='" + restOfLine + "'");
                }
                memberClass = Class.forName(className);
                tmp = (FigObject)memberClass.newInstance();
                tmp.initialize(restOfLine);
                this.fastAddMember(tmp);
            }
            this.update_bbox();
            this.build_sc_bbox();
            this.parent = null;
            this.setLayer(SYMBOL_LAYER);
            br.close();
            ((InputStream)is).close();
            System.err.println("-#- Symbol.initializeFromFile: streams closed.");
        }
        catch (Exception e) {
            this.message("-E- Symbol.initializeFromFile(): caught: " + e);
            ExceptionTracer.trace(e);
        }
    }

    public void writeAsResource(PrintWriter ps) {
        FigObjectList list = this.getMembers();
        ListNode tmp = list.get_first();
        while (tmp != null) {
            tmp.get_obj().writeAsResource(ps);
            tmp = list.get_next(tmp);
        }
    }

    public FigObject copy() {
        Symbol carbon = new Symbol();
        Enumeration e = this.getMembers().elements();
        while (e.hasMoreElements()) {
            FigObject tmp = (FigObject)e.nextElement();
            carbon.fastAddMember(tmp.copy());
        }
        carbon.update_bbox();
        carbon.build_sc_bbox();
        carbon.setAttributes(this.getAttributes().getClone());
        carbon.pos = new Point(0, 0);
        return carbon;
    }

    public void addMember(FigObject obj) {
        if (this.isMirroredX) {
            obj.mirrorX(this.x, this.y);
        }
        if (this.isMirroredY) {
            obj.mirrorY(this.x, this.y);
        }
        obj.setTrafo(this.getTrafo());
        super.addMember(obj);
    }

    public void fastAddMember(FigObject obj) {
        if (this.isMirroredX) {
            obj.mirrorX(this.x, this.y);
        }
        if (this.isMirroredY) {
            obj.mirrorY(this.x, this.y);
        }
        super.fastAddMember(obj);
    }

    public void mirrorX(int x, int y) {
        this.isMirroredX = !this.isMirroredX;
        super.mirrorX(x, y);
        this.pos.x = this.x;
    }

    public void mirrorY(int x, int y) {
        this.isMirroredY = !this.isMirroredY;
        super.mirrorY(x, y);
        this.pos.y = this.y;
    }

    public void printDebugInfo() {
        System.out.println(this.toString());
        Enumeration e = this.getMembers().elements();
        while (e.hasMoreElements()) {
            FigBaseobject o = (FigBaseobject)e.nextElement();
            if (o == null) continue;
            System.out.println(">>" + o.toString());
        }
    }

    public void message(String msg) {
        Console.getConsole().message(msg);
    }

    public void setDebug(boolean _debug) {
        debug = _debug;
    }

    public String toString() {
        return "hades.symbols.Symbol[" + super.toString() + "]";
    }
}

