/*
 * Decompiled with CFR 0.152.
 */
package hades.symbols;

import hades.symbols.ColorSource;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.StringTokenizer;
import jfig.canvas.FigTrafo2D;
import jfig.gui.ColorCache;
import jfig.objects.FigAttribs;
import jfig.objects.FigObject;
import jfig.objects.FigRectangle;

public class Rectangle
extends FigRectangle
implements Serializable {
    private ColorSource colorSource;

    public Rectangle() {
        this.build_attribs();
    }

    public boolean initialize(String s) {
        int x = 0;
        int y = 0;
        try {
            StringTokenizer st = new StringTokenizer(s);
            Point[] pp = new Point[2];
            x = Integer.parseInt(st.nextToken());
            y = Integer.parseInt(st.nextToken());
            pp[0] = new Point(x, y);
            x = Integer.parseInt(st.nextToken());
            y = Integer.parseInt(st.nextToken());
            pp[1] = new Point(x, y);
            super.setPoints(pp);
        }
        catch (Exception e) {
            System.err.println("" + e);
        }
        return true;
    }

    protected void build_attribs() {
        FigAttribs attribs = new FigAttribs();
        attribs.lineColor = attribs.fillColor = ColorCache.getColorCache().get(12);
        attribs.fig_fill_color = 12;
        attribs.fig_line_color = 12;
        attribs.fillStyle = 1;
        attribs.currentLayer = 25;
        attribs.lineWidth = 30.0;
        attribs.arrowMode = 0;
        attribs.lineStyle = 0;
        attribs.cornerRadius = 0;
        super.setAttributes(attribs);
    }

    public void writeAsResource(PrintWriter ps) {
        Point[] pp = this.getPoints();
        String s = this.getClass().getName() + " ";
        int i = 0;
        while (i < pp.length) {
            s = s + " " + pp[i].x + " " + pp[i].y;
            ++i;
        }
        ps.println(s);
    }

    public FigObject copy() {
        Rectangle carbon = new Rectangle();
        carbon.setPoints(this.getPoints());
        carbon.setAttributes(this.getAttributes().getClone());
        return carbon;
    }

    public void setColorSource(ColorSource cs) {
        this.colorSource = cs;
    }

    public void paint(Graphics g) {
        if (this.colorSource != null) {
            this.checkColorSource();
        }
        super.paint(g);
    }

    public void paint(Graphics g, FigTrafo2D trafo) {
        if (this.colorSource != null) {
            this.checkColorSource();
        }
        super.paint(g, trafo);
    }

    public void checkColorSource() {
        Color c = this.colorSource.getColor();
        boolean needsUpdate = false;
        if (this.attribs.lineColor != c) {
            this.attribs.setLineColor(c);
            needsUpdate = true;
        }
        if (this.attribs.fillColor != c) {
            this.attribs.setFillColor(c);
            needsUpdate = true;
        }
        if (needsUpdate) {
            this.rebuild();
        }
    }

    public String toString() {
        return "Rectangle[" + super.toString() + "]";
    }
}

