/*
 * Decompiled with CFR 0.152.
 */
package hades.symbols;

import java.awt.Point;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.StringTokenizer;
import jfig.gui.ColorCache;
import jfig.objects.FigAttribs;
import jfig.objects.FigObject;
import jfig.objects.FigPolyline;
import jfig.utils.ExceptionTracer;

public class Polyline
extends FigPolyline
implements Serializable {
    public Polyline() {
        this.build_attribs();
    }

    public boolean initialize(String s) {
        int n = 0;
        int x = 0;
        int y = 0;
        try {
            StringTokenizer st = new StringTokenizer(s);
            n = Integer.parseInt(st.nextToken());
            Point[] pp = new Point[n];
            int i = 0;
            while (i < n) {
                x = Integer.parseInt(st.nextToken());
                y = Integer.parseInt(st.nextToken());
                pp[i] = new Point(x, y);
                ++i;
            }
            super.setPoints(pp);
        }
        catch (Exception e) {
            ExceptionTracer.message("Error initializing Polyline:");
            ExceptionTracer.trace(e);
        }
        return true;
    }

    protected void build_attribs() {
        FigAttribs attribs = new FigAttribs();
        attribs.lineColor = attribs.fillColor = ColorCache.getColorCache().get(12);
        attribs.fig_fill_color = 12;
        attribs.fig_line_color = 12;
        attribs.fillStyle = 1;
        attribs.fig_fill_color = 12;
        attribs.fig_line_color = 12;
        attribs.currentLayer = 15;
        attribs.lineWidth = 30.0;
        attribs.arrowMode = 0;
        attribs.lineStyle = 0;
        attribs.fig_join_style = 2;
        attribs.fig_cap_style = 2;
        attribs.cornerRadius = 0;
        super.setAttributes(attribs);
    }

    public void writeAsResource(PrintWriter ps) {
        Point[] pp = this.getPoints();
        String s = this.getClass().getName() + " " + pp.length;
        int i = 0;
        while (i < pp.length) {
            s = s + " " + pp[i].x + " " + pp[i].y;
            ++i;
        }
        ps.println(s);
    }

    public FigObject copy() {
        Polyline carbon = new Polyline();
        carbon.setPoints(this.getPoints());
        carbon.setAttributes(this.getAttributes().getClone());
        return carbon;
    }

    public String toString() {
        return "Polyline[" + super.toString() + "]";
    }
}

