/*
 * Decompiled with CFR 0.152.
 */
package hades.symbols;

import hades.gui.Console;
import java.awt.Point;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.StringTokenizer;
import jfig.gui.ColorCache;
import jfig.gui.ConsoleMessage;
import jfig.objects.FigAttribs;
import jfig.objects.FigImage;
import jfig.objects.FigObject;

public class ImageObject
extends FigImage
implements Serializable,
ConsoleMessage {
    public boolean debug = false;
    private Point position;
    private String resourcename;

    public ImageObject() {
        FigAttribs attr = this.getAttributes();
        attr.lineColor = attr.fillColor = ColorCache.getColorCache().get(7);
        this.setAttributes(attr);
    }

    public boolean initialize(String s) {
        String resourcename = null;
        try {
            StringTokenizer st = new StringTokenizer(s);
            int x1 = Integer.parseInt(st.nextToken());
            int y1 = Integer.parseInt(st.nextToken());
            int x2 = Integer.parseInt(st.nextToken());
            int y2 = Integer.parseInt(st.nextToken());
            this.position = new Point(x1, y1);
            Point[] wcp = new Point[]{new Point(x1, y1), new Point(x2, y2)};
            this.setPoints(wcp);
            resourcename = st.nextToken();
            this.getImage(resourcename);
        }
        catch (Exception e) {
            System.err.println("" + e);
        }
        return true;
    }

    public void getImage(String resourcename) {
        super.getImageFromResource(resourcename);
    }

    public void writeAsResource(PrintWriter ps) {
        String s = this.getClass().getName() + " " + this.position.x + " " + this.position.y + " " + this.resourcename;
        ps.println(s);
    }

    public FigObject copy() {
        ImageObject carbon = new ImageObject();
        carbon.setPoints(this.getPoints());
        carbon.position = this.position;
        carbon.setAttributes(this.getAttributes().getClone());
        carbon.setTrafo(this.getTrafo());
        carbon.getImageFromResource(this.getImageName());
        carbon.rebuild();
        return carbon;
    }

    public void consoleMessage(String msg) {
        if (this.debug) {
            Console.getConsole().println("ImageObject: " + msg);
        }
    }

    public String toString() {
        return "ImageObject[" + super.toString() + "]";
    }
}

