/*
 * Decompiled with CFR 0.152.
 */
package hades.symbols;

import hades.gui.Console;
import java.awt.Point;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import jfig.canvas.FigTrafo2D;
import jfig.gui.ColorCache;
import jfig.objects.FigAttribs;
import jfig.objects.FigCompound;
import jfig.objects.FigObject;
import jfig.objects.FigRectangle;

public class HorizontalBarGraph
extends FigCompound
implements Serializable {
    protected int n_segments;
    protected int value;
    protected int n_color;
    protected int xl = 0;
    protected int xr = 2400;
    protected int yt = 0;
    protected int yb = 600;
    protected FigRectangle[] rectangles;

    public HorizontalBarGraph() {
        this(10);
    }

    public HorizontalBarGraph(int n_segments) {
        this.n_segments = n_segments;
    }

    public void build_attribs() {
        FigAttribs attr = this.getAttributes();
        attr.lineColor = ColorCache.getColorCache().get(this.n_color);
        attr.fillColor = ColorCache.getColorCache().get(this.n_color);
        attr.fig_line_color = this.n_color;
        attr.fig_fill_color = this.n_color;
        attr.currentLayer = 20;
        this.setAttributes(attr);
    }

    public void build_segments() {
        this.deleteAllMembers();
        double dx_segment = 1.0 * (double)(this.xr - this.xl) / (double)this.n_segments;
        FigTrafo2D trafo = this.getTrafo();
        FigAttribs attribsf = this.getAttributes();
        attribsf.fillStyle = 2;
        this.rectangles = new FigRectangle[this.n_segments];
        int i = 0;
        while (i < this.n_segments) {
            int x1 = this.xl + (int)((double)i * dx_segment);
            int x2 = x1 + (int)(0.8 * dx_segment);
            this.rectangles[i] = new FigRectangle(x1, this.yt, x2, this.yb, false, attribsf, trafo);
            this.fastAddMember(this.rectangles[i]);
            ++i;
        }
        this.update_bbox();
        this.build_sc_bbox();
    }

    public void setValue(int value) {
        if (value < 0) {
            value = 0;
        }
        if (value > this.n_segments) {
            value = this.n_segments;
        }
        double dx_segment = 1.0 * (double)(this.xr - this.xl) / (double)this.n_segments;
        Point[] points = new Point[]{new Point(0, 0), new Point(0, 0)};
        int i = 0;
        while (i < this.n_segments) {
            int x1 = this.xl + (int)((double)i * dx_segment);
            int x2 = x1 + (int)(0.8 * dx_segment);
            points[0].x = x1;
            points[1].x = x2;
            points[0].y = i <= value ? this.yt : this.yb;
            points[1].y = this.yb;
            this.rectangles[i].setPoints(points);
            ++i;
        }
    }

    public boolean initialize(String s) {
        try {
            StringTokenizer st = new StringTokenizer(s);
            this.xl = Integer.parseInt(st.nextToken());
            this.yt = Integer.parseInt(st.nextToken());
            this.xr = Integer.parseInt(st.nextToken());
            this.yb = Integer.parseInt(st.nextToken());
            this.n_segments = Integer.parseInt(st.nextToken());
            this.value = Integer.parseInt(st.nextToken());
            this.n_color = Integer.parseInt(st.nextToken());
            this.build_attribs();
            this.build_segments();
            this.setValue(this.value);
        }
        catch (Exception e) {
            System.err.println("-E- HBG.initialize: " + e);
            e.printStackTrace();
        }
        return true;
    }

    public FigObject copy() {
        HorizontalBarGraph carbon = new HorizontalBarGraph();
        Enumeration e = this.getMembers().elements();
        while (e.hasMoreElements()) {
            FigObject tmp = (FigObject)e.nextElement();
            carbon.fastAddMember(tmp.copy());
        }
        carbon.setAttributes(this.getAttributes().getClone());
        carbon.update_bbox();
        carbon.build_sc_bbox();
        return carbon;
    }

    public void message(String msg) {
        Console.getConsole().message(msg);
    }

    public String toString() {
        return "hades.symbols.HorizontalBarGraph[" + super.toString() + "]";
    }
}

