/*
 * Decompiled with CFR 0.152.
 */
package hades.symbols;

import java.awt.Color;
import java.awt.Point;
import java.io.Serializable;
import jfig.objects.FigAttribs;
import jfig.objects.FigBbox;
import jfig.objects.FigObject;
import jfig.objects.FigPolyline;
import jfig.utils.SetupManager;

public class ErrorMarker
extends FigPolyline
implements Serializable {
    int x;
    int y;
    int w;
    int h;

    public ErrorMarker() {
        this(0, 0, 600, 600);
    }

    public ErrorMarker(int x, int y, int w, int h) {
        this.setPointsFromCenterWidthHeight(x, y, w, h);
    }

    public void setPointsFromCenterWidthHeight(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        Point[] points = new Point[]{new Point(x - w, y - h), new Point(x + w, y - h), new Point(x + w, y + h), new Point(x - w, y + h), new Point(x + w, y - h), new Point(x + w, y + h), new Point(x - w, y - h), new Point(x - w, y + h)};
        this.setPoints(points);
        this.build_attribs();
    }

    public void setPointsFromBoundingBox(FigBbox bbox) {
        int x = (bbox.getXl() + bbox.getXr()) / 2;
        int y = (bbox.getYt() + bbox.getYb()) / 2;
        int w = (bbox.getXr() - bbox.getXl()) / 2;
        int h = (bbox.getYb() - bbox.getYt()) / 2;
        this.setPointsFromCenterWidthHeight(x, y, w, h);
    }

    protected void build_attribs() {
        FigAttribs attribs = new FigAttribs();
        Color color = SetupManager.getColor("Hades.Editor.HighlightColor", Color.cyan);
        attribs.setLineColor(color);
        attribs.setFillColor(color);
        attribs.fillStyle = 1;
        attribs.fig_fill_color = 12;
        attribs.fig_line_color = 12;
        attribs.currentLayer = 1;
        attribs.lineWidth = 60.0;
        attribs.arrowMode = 0;
        attribs.lineStyle = 0;
        attribs.fig_join_style = 2;
        attribs.fig_cap_style = 2;
        attribs.cornerRadius = 0;
        super.setAttributes(attribs);
    }

    public FigObject copy() {
        ErrorMarker carbon = new ErrorMarker();
        carbon.setPoints(this.getPoints());
        carbon.setAttributes(this.getAttributes().getClone());
        return carbon;
    }

    public String toString() {
        return "ErrorMarker[" + this.x + "," + this.y + "," + this.w + "," + this.h + "]";
    }
}

