/*
 * Decompiled with CFR 0.152.
 */
package hades.symbols;

import java.awt.Color;
import java.awt.Point;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.StringTokenizer;
import jfig.objects.FigAttribs;
import jfig.objects.FigObject;
import jfig.objects.FigRectangle;

public class BboxRectangle
extends FigRectangle
implements Serializable {
    protected Point position;
    protected String label;

    public BboxRectangle() {
        this.build_attribs();
    }

    public boolean initialize(String s) {
        int x = 0;
        int y = 0;
        try {
            StringTokenizer st = new StringTokenizer(s);
            Point[] pp = new Point[2];
            x = Integer.parseInt(st.nextToken());
            y = Integer.parseInt(st.nextToken());
            pp[0] = new Point(x, y);
            x = Integer.parseInt(st.nextToken());
            y = Integer.parseInt(st.nextToken());
            pp[1] = new Point(x, y);
            super.setPoints(pp);
        }
        catch (Exception e) {
            System.err.println("" + e);
        }
        return true;
    }

    protected void build_attribs() {
        FigAttribs attribs = new FigAttribs();
        attribs.lineColor = new Color(240, 240, 240);
        attribs.fillColor = Color.white;
        attribs.fillStyle = 2;
        attribs.currentLayer = 500;
        attribs.lineWidth = 30.0;
        attribs.arrowMode = 0;
        attribs.lineStyle = 0;
        attribs.cornerRadius = 0;
        attribs.fig_line_color = 11;
        attribs.fig_fill_color = 7;
        super.setAttributes(attribs);
    }

    public void writeAsResource(PrintWriter ps) {
        Point[] pp = this.getPoints();
        String s = this.getClass().getName() + " ";
        int i = 0;
        while (i < pp.length) {
            s = s + " " + pp[i].x + " " + pp[i].y;
            ++i;
        }
        ps.println(s);
    }

    public FigObject copy() {
        BboxRectangle carbon = new BboxRectangle();
        carbon.setAttributes(this.getAttributes().getClone());
        carbon.setPoints(this.getPoints());
        return carbon;
    }

    public String toString() {
        return "BboxRectangle[" + super.toString() + "]";
    }
}

