/*
 * Decompiled with CFR 0.152.
 */
package hades.styx;

import hades.styx.Transformation;
import hades.styx.WaveCanvas;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Waveform
implements Serializable {
    public static int NOT_FOUND = -1;
    protected int SIZE = 10;
    protected double[] times = new double[this.SIZE];
    protected Object[] events = new Object[this.SIZE];
    protected int fill = 0;
    protected int pos;
    protected Transformation trafo;
    protected String name;
    protected String fullName;
    transient WaveCanvas WC;
    transient Object searchfrom;
    transient Object searchto;
    transient double search_time0;
    transient boolean search_direction;
    int in;
    public static boolean debug = false;

    public Waveform() {
        this.times[0] = 0.0;
        this.events[0] = "";
        this.fullName = "no full name set";
    }

    public void setTrafo(Transformation transformation) {
        this.trafo = transformation;
    }

    public Transformation getTrafo() {
        return this.trafo;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setFullName(String string) {
        this.fullName = string;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setPos(int n) {
        this.pos = n;
    }

    public int getPos() {
        return this.pos;
    }

    public void setWaveCanvas(WaveCanvas waveCanvas) {
        this.WC = waveCanvas;
    }

    public void clearData() {
        this.fill = 0;
        this.times[0] = 0.0;
    }

    /*
     * Unable to fully structure code
     */
    public int gototime(double var1_1) {
        if (this.fill == 0) {
            return 0;
        }
        var3_2 = 0;
        var4_3 = this.fill;
        var5_4 = this.fill / 2;
        var6_5 = 0;
        if (var1_1 < this.times[var3_2]) {
            return var3_2;
        }
        if (!(var1_1 >= this.times[var4_3])) ** GOTO lbl17
        return var4_3;
lbl-1000:
        // 1 sources

        {
            var5_4 = var4_3 + var3_2 >> 1;
            if (var1_1 > this.times[var5_4]) {
                var3_2 = var5_4;
            } else {
                var4_3 = var5_4;
            }
            if (++var6_5 > 50) break;
lbl17:
            // 2 sources

            ** while (var4_3 - var3_2 > 1)
        }
lbl18:
        // 2 sources

        return var3_2;
    }

    public void addValue(Object object, double d) {
        if (object == null) {
            return;
        }
        if (this.fill + 1 >= this.SIZE) {
            this.reallocate();
        }
        this.times[this.fill + 1] = d;
        this.events[this.fill + 1] = object;
        ++this.fill;
        if (debug) {
            System.out.println("-#- Waveform.addValue: " + object + " " + d);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void reallocate() {
        block4: {
            try {
                var1_1 = 2 * this.SIZE;
                var2_3 = new double[var1_1];
                var3_5 = new Object[var1_1];
                var4_7 = 0;
                while (var4_7 < this.SIZE) {
                    var2_3[var4_7] = this.times[var4_7];
                    var3_5[var4_7] = this.events[var4_7];
                    ++var4_7;
                }
                this.times = var2_3;
                this.events = var3_5;
                this.SIZE = var1_1;
                break block4;
            }
            catch (OutOfMemoryError var1_2) {
                System.out.println("-E- out of memory in Waveform.reallocate..." + this.getName());
                System.out.println("... overwriting oldest event data ...");
                var2_4 = this.fill / 2;
                var3_6 = 1;
                ** while (var3_6 < var2_4)
            }
lbl-1000:
            // 1 sources

            {
                this.times[var3_6] = this.times[var3_6 + var2_4];
                this.events[var3_6] = this.events[var3_6 + var2_4];
                ++var3_6;
                continue;
            }
lbl25:
            // 1 sources

            this.fill = var2_4 - 1;
        }
    }

    public Object getValueAtTime(double d) {
        int n = this.gototime(d);
        Object object = this.events[n];
        return object;
    }

    public Object getValueAtIndex(int n) {
        return this.events[n];
    }

    public double getTimeAtIndex(int n) {
        return this.times[n];
    }

    public String getValueAsString(double d) {
        return this.getValueAtTime(d).toString();
    }

    public int countEvents() {
        return this.fill;
    }

    public String getLabel(int n) {
        return this.events[n].toString();
    }

    public int indexOfNextEventAfter(double d) {
        int n = this.gototime(d);
        while (n < this.fill && this.times[n] <= d) {
            ++n;
        }
        if (n > this.fill) {
            return NOT_FOUND;
        }
        if (this.times[n] <= d) {
            return NOT_FOUND;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public int indexOfPreviousEventBefore(double var1_1) {
        var3_2 = 0;
        var4_3 = this.fill;
        var5_4 = (var4_3 + var3_2) / 2;
        var6_5 = this.times[var3_2];
        var8_6 = this.times[var4_3];
        var10_7 = 0;
        if (this.times[0] >= var1_1) {
            return Waveform.NOT_FOUND;
        }
        if (!(this.times[1] >= var1_1)) ** GOTO lbl19
        return 0;
lbl-1000:
        // 1 sources

        {
            var5_4 = (var4_3 + var3_2) / 2;
            if (this.times[var5_4] >= var1_1) {
                var4_3 = var5_4;
            } else {
                var3_2 = var5_4;
            }
            if (++var10_7 <= 50) continue;
            Thread.dumpStack();
            return Waveform.NOT_FOUND;
lbl19:
            // 2 sources

            ** while (var4_3 - var3_2 > 1)
        }
lbl20:
        // 1 sources

        return var3_2;
    }

    public boolean compareEventToSearchObject(int n, Object object) {
        try {
            return this.events[n].equals(object);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public double findEvent(double d, boolean bl) {
        int n = this.gototime(d);
        if (bl) {
            n = n < this.fill ? ++n : this.fill;
        } else if (this.times[n] == d) {
            --n;
        }
        if (n < 0) {
            n = 0;
        }
        System.err.println("-I- findEvent: t= " + d + (bl ? " next " : " previous ") + " found: index " + n + " at t= " + this.times[n]);
        return this.times[n];
    }

    public void findSpecialEvent(Object object, Object object2, double d, boolean bl) {
        int n = this.gototime(d);
        --n;
        int n2 = 0;
        while (n <= this.fill && n > 0 && n2 == 0) {
            if (object2 == null) {
                if (this.events[n].equals(object)) {
                    n2 = n;
                }
            } else if (this.events[n].equals(object)) {
                if (bl) {
                    if (this.events[n + 1].equals(object2)) {
                        n2 = n + 1;
                    }
                } else if (this.events[n - 1].equals(object2)) {
                    n2 = n;
                }
            }
            if (bl) {
                ++n;
                continue;
            }
            --n;
        }
        double d2 = (this.trafo.tRight - this.trafo.tLeft) / 2.0;
        if (n2 != 0) {
            if (this.times[n2] - d2 > 0.0 && this.times[n2] + d2 < this.times[this.fill]) {
                this.trafo.setTLeft(this.times[n2] - d2);
                this.trafo.setTRight(this.times[n2] + d2);
            } else {
                if (this.times[n2] - d2 < 0.0) {
                    this.trafo.setTLeft(0.0);
                    this.trafo.setTRight(this.times[n2] * 2.0);
                }
                if (this.times[n2] + d2 > this.times[this.fill]) {
                    this.trafo.setTLeft(2.0 * this.times[n2] - this.times[this.fill]);
                    this.trafo.setTRight(this.times[this.fill]);
                }
            }
            this.WC.findx = this.times[n2];
            this.WC.showFind(true);
        }
    }

    public double getMaxTime() {
        return this.times[this.fill];
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.name);
        objectOutputStream.writeInt(this.fill);
        objectOutputStream.writeObject(this.fullName);
        objectOutputStream.writeObject(this.times);
        objectOutputStream.writeObject(this.events);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.name = (String)objectInputStream.readObject();
        this.fill = objectInputStream.readInt();
        Object object = objectInputStream.readObject();
        if (object instanceof String) {
            this.fullName = (String)object;
            this.times = (double[])objectInputStream.readObject();
            this.events = (Object[])objectInputStream.readObject();
        } else {
            this.times = (double[])object;
            this.events = (Object[])objectInputStream.readObject();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paint(Graphics graphics) {
        int n = 24;
        int n2 = this.fill;
        double[] dArray = this.times;
        Object[] objectArray = this.events;
        int n3 = this.trafo.transformRow(this.pos) + 4;
        int n4 = this.trafo.transformRow(this.pos + 1) - 4;
        int n5 = n4 + n3 >> 1;
        if (n3 <= 1) return;
        if (n4 <= 0) return;
        if (n4 >= this.trafo.getMaxScreenY()) {
            return;
        }
        double d = this.trafo.getTLeft();
        double d2 = this.trafo.getTRight();
        int n6 = this.gototime(d);
        int n7 = 0;
        try {
            graphics.setColor(Color.black);
            while (n6 <= n2) {
                String string;
                if (!(dArray[n6] <= d2)) {
                    return;
                }
                double d3 = n6 + 1 <= n2 ? dArray[n6 + 1] : this.trafo.tEnd;
                int n8 = this.trafo.transformT(d3);
                int n9 = n7 + n8 >> 1;
                if (dArray[n6] <= d) {
                    if (d3 >= d2) {
                        graphics.drawLine(0, n3, (int)this.trafo.xMax, n3);
                        graphics.drawLine(0, n4, (int)this.trafo.xMax, n4);
                    } else if (n8 > 5) {
                        graphics.drawLine(0, n3, n8 - 5, n3);
                        graphics.drawLine(0, n4, n8 - 5, n4);
                        graphics.drawLine(n8 - 5, n3, n8, n5);
                        graphics.drawLine(n8 - 5, n4, n8, n5);
                    } else {
                        graphics.drawLine(n7, n3, n8, n5);
                        graphics.drawLine(n7, n4, n8, n5);
                    }
                    if (n8 > n) {
                        string = this.getLabel(n6);
                        this.drawLabel(graphics, string, 6, n5 + 5, n8 - 10);
                    }
                } else if (n6 < n2 && dArray[n6 + 1] <= d2) {
                    if (n8 - n7 > n) {
                        graphics.drawLine(n7, n5, n7 + 5, n3);
                        graphics.drawLine(n7, n5, n7 + 5, n4);
                        graphics.drawLine(n7 + 5, n3, n8 - 5, n3);
                        graphics.drawLine(n7 + 5, n4, n8 - 5, n4);
                        graphics.drawLine(n8 - 5, n3, n8, n5);
                        graphics.drawLine(n8 - 5, n4, n8, n5);
                        string = this.getLabel(n6);
                        this.drawLabel(graphics, string, n7 + 10, n5 + 5, n8 - n7 - 10);
                    } else {
                        graphics.drawLine(n7, n5, n9, n3);
                        graphics.drawLine(n7, n5, n9, n4);
                        graphics.drawLine(n9, n3, n8, n5);
                        graphics.drawLine(n9, n4, n8, n5);
                    }
                } else {
                    graphics.drawLine(n7, n5, n7 + 5, n3);
                    graphics.drawLine(n7, n5, n7 + 5, n4);
                    graphics.drawLine(n7 + 5, n3, (int)this.trafo.xMax, n3);
                    graphics.drawLine(n7 + 5, n4, (int)this.trafo.xMax, n4);
                    if (this.trafo.xMax - (double)n7 > (double)n) {
                        string = this.getLabel(n6);
                        this.drawLabel(graphics, string, n7 + 10, n5 + 5, (int)(this.trafo.xMax - (double)n7 - 10.0));
                    }
                }
                n7 = n8;
                ++n6;
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Waveform.msg("-E- internal: " + arrayIndexOutOfBoundsException.toString());
            Waveform.msg(" index= " + n6 + " fill= " + n2 + " times.length= " + dArray.length + " events.length= " + objectArray.length);
            return;
        }
        catch (Throwable throwable) {
            Waveform.msg("-E- unexpected: " + throwable.toString());
            throwable.printStackTrace();
            return;
        }
    }

    public void drawLabel(Graphics graphics, String string, int n, int n2, int n3) {
        if (n3 < 10) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (fontMetrics.stringWidth(string) <= n3) {
            graphics.drawString(string, n, n2);
        } else {
            int n4 = fontMetrics.stringWidth("M");
            int n5 = fontMetrics.stringWidth(".");
            int n6 = (n3 - 3 * n5) / n4;
            String string2 = string.substring(0, n6) + "...";
            graphics.drawString(string2, n, n2);
        }
    }

    public static void msg(String string) {
        System.err.println(string);
    }
}

