/*
 * Decompiled with CFR 0.152.
 */
package hades.simulator;

import hades.simulator.SimEvent;
import hades.simulator.SimulatorCommand;
import hades.simulator.VhdlSimKernel;

public class VhdlBatchSimKernel
extends VhdlSimKernel
implements Runnable {
    static String versionString = "HADES VHDL batch-mode simulation kernel (v0.01)";

    void simulation() {
        while (!this.shouldStop) {
            ++this.n_iterations;
            this.checkInteractiveEvents();
            this.checkResync();
            this.collectEvents();
            this.executeAllPendingEvents();
            this.recycleEvents();
        }
    }

    void checkInteractiveEvents() {
        while (!this.commandQueue.isEmpty()) {
            Object o = this.commandQueue.fetch();
            if (o instanceof SimulatorCommand) {
                if (this.debug) {
                    this.message("-I- executing interactive command: " + o);
                }
                ((SimulatorCommand)o).execute();
                continue;
            }
            this.message("-E- don't know what to do with interactive command: " + o);
        }
    }

    void checkResync() {
        if (this.n_iterations > this.n_resync_iterations || this.realTime - this.lastSyncTime > 0.5) {
            this.resync();
        }
    }

    void collectEvents() {
        if (this.eventList.isEmpty()) {
            this.sleep();
            return;
        }
        this.eventList.first();
        double t_current = this.eventTime = this.eventList.getSimTime();
        double t_next = 0.0;
        this.simTime = this.eventTime;
        do {
            SimEvent event = this.eventList.getData();
            event.evaluate();
            this.addRecycleableEvent(event);
            this.eventList.deleteFirst();
            ++this.n_processed;
            if (this.eventList.isEmpty()) break;
            this.eventList.first();
        } while ((t_next = this.eventList.getSimTime()) == t_current);
    }

    public String toString() {
        String s = "VhdlBatchSimKernel'" + this.name + "'";
        return s;
    }
}

