/*
 * Decompiled with CFR 0.152.
 */
package hades.simulator;

public final class CommandQueue {
    private Node root = new Node();
    private Node cursor;
    private int n_appended;
    private int n_fetched;

    public CommandQueue() {
        this.root.setNext(this.root);
        this.root.setPrev(this.root);
        this.cursor = this.root;
    }

    public synchronized void first() {
        this.cursor = this.root.getNext();
    }

    public final synchronized void last() {
        this.cursor = this.root.getPrev();
    }

    public final synchronized void next() {
        if (this.cursor.getNext() != this.root) {
            this.cursor = this.cursor.getNext();
        }
    }

    public final synchronized void prev() {
        if (this.cursor.getPrev() != this.root) {
            this.cursor = this.cursor.getPrev();
        }
    }

    public final synchronized Object getData() {
        return this.cursor.getData();
    }

    public final synchronized void setData(Object o) {
        this.cursor.setData(o);
    }

    public synchronized void append(Object o) {
        Node tmp = this.root.getPrev();
        Node tail = new Node();
        tail.setData(o);
        tail.setNext(this.root);
        tail.setPrev(tmp);
        tmp.setNext(tail);
        this.root.setPrev(tail);
        ++this.n_appended;
    }

    public synchronized Object fetch() {
        if (this.root.getNext() == this.root) {
            return null;
        }
        ++this.n_fetched;
        Object data = this.root.getNext().getData();
        Node second = this.root.getNext().getNext();
        second.setPrev(this.root);
        this.root.setNext(second);
        return data;
    }

    public boolean isEmpty() {
        return this.n_appended == this.n_fetched;
    }

    public int countAppends() {
        return this.n_appended;
    }

    public int countFetches() {
        return this.n_fetched;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Queue:\n");
        Node cursor = this.root.getNext();
        while (cursor != this.root) {
            sb.append("" + cursor + " " + cursor.getData() + "\n");
            cursor = cursor.getNext();
        }
        return sb.toString();
    }

    public static void usage() {
        System.err.println("Usage: java hades.simulator.CommandQueue <n-nodes>");
        System.err.println("Example: java hades.simulator.CommandQueue 10");
    }

    public static void main(String[] argv) {
        CommandQueue queue;
        int N = 0;
        if (argv.length < 1) {
            CommandQueue.usage();
            return;
        }
        N = Integer.parseInt(argv[0]);
        System.out.println("CommandQueue self test started...");
        System.out.println("n_nodes = " + N + " (but not used yet)");
        CommandQueue commandQueue = queue = new CommandQueue();
        commandQueue.getClass();
        SelftestFeeder feeder1 = commandQueue.new SelftestFeeder(queue, 50, "1_");
        CommandQueue commandQueue2 = queue;
        commandQueue2.getClass();
        SelftestFeeder feeder2 = commandQueue2.new SelftestFeeder(queue, 40, "2_");
        CommandQueue commandQueue3 = queue;
        commandQueue3.getClass();
        SelftestFetcher fetcher = commandQueue3.new SelftestFetcher(queue);
        fetcher.start();
        feeder1.start();
        feeder2.start();
    }

    class SelftestFetcher
    extends Thread {
        CommandQueue queue;
        int n = 0;

        SelftestFetcher(CommandQueue _queue) {
            this.queue = _queue;
        }

        public void run() {
            while (true) {
                try {
                    if (!this.queue.isEmpty()) {
                        Object o = this.queue.fetch();
                        System.out.println("fetched: " + o);
                        ++this.n;
                        if (this.n % 100 == 99) {
                            System.out.println();
                            System.out.println("Fetcher: " + this.queue.countFetches());
                            System.out.println(this.queue.toString());
                        }
                    }
                    Thread.sleep(20L);
                }
                catch (Exception e) {
                }
            }
        }
    }

    class SelftestFeeder
    extends Thread {
        CommandQueue queue;
        int delta_t = 25;
        int i = 0;
        String name;

        SelftestFeeder(CommandQueue _queue, int _delta_t, String _name) {
            this.queue = _queue;
            this.delta_t = _delta_t;
            this.name = _name;
        }

        public void run() {
            while (true) {
                try {
                    this.queue.append(this.name + this.i);
                    ++this.i;
                    Thread.sleep(this.delta_t);
                }
                catch (Exception e) {
                }
            }
        }
    }

    private final class Node {
        private Object data;
        private Node prev;
        private Node next;

        private Node() {
        }

        public final Node getNext() {
            return this.next;
        }

        public final Node getPrev() {
            return this.prev;
        }

        public final Object getData() {
            return this.data;
        }

        public final void setNext(Node next) {
            this.next = next;
        }

        public final void setPrev(Node prev) {
            this.prev = prev;
        }

        public final void setData(Object data) {
            this.data = data;
        }
    }
}

