/*
 * Decompiled with CFR 0.152.
 */
package hades.signals;

import hades.models.Design;
import hades.models.StdLogicVector;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.symbols.Color_DIN_IEC_62;
import hades.symbols.WireSegment;
import java.awt.Color;
import java.awt.Point;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import jfig.canvas.ObjectPainter;
import jfig.utils.ExceptionTracer;

public class SignalStdLogicVector
extends Signal {
    private int width = 0;
    static /* synthetic */ Class class$hades$signals$Signal;

    public SignalStdLogicVector() {
        this("n0");
    }

    public SignalStdLogicVector(String name) {
        super(name);
        this.value = null;
    }

    public SignalStdLogicVector(String name, Port[] senders, Port[] receivers) {
        this(name);
        this.senders = senders;
        this.receivers = receivers;
        this.driverValues = new Object[senders.length];
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n_bits) {
        this.width = n_bits;
    }

    public boolean canConnect(Port port) {
        if (port == null) {
            return false;
        }
        if (port.getSignal() != null) {
            this.message("-W- Cannot connect: port already in use!");
            return false;
        }
        if (port.getSignalClass() == this.getClass()) {
            Integer tmp = (Integer)port.getOptArg();
            if (this.getWidth() == 0) {
                return true;
            }
            return this.getWidth() == tmp.intValue();
        }
        if (port.getSignalClass() == (class$hades$signals$Signal == null ? (class$hades$signals$Signal = SignalStdLogicVector.class$("hades.signals.Signal")) : class$hades$signals$Signal)) {
            return true;
        }
        this.message("-W- Cannot connect: type mismatch: " + this.getClass() + " vs. " + port.getSignalClass());
        return false;
    }

    public boolean canConnect_ORIG_PRIOR_TO_20051206(Port port) {
        if (port == null) {
            return false;
        }
        if (port.getSignal() != null) {
            this.message("-W- Cannot connect: port already in use!");
            return false;
        }
        if (this.getClass() != port.getSignalClass()) {
            Thread.dumpStack();
            this.message("-W- Cannot connect: type mismatch: " + this.getClass() + " vs. " + port.getSignalClass());
            return false;
        }
        Integer tmp = (Integer)port.getOptArg();
        if (tmp == null) {
            this.message("-E- Internal error: port optArg is null for StdLogicVector, optarg= " + tmp);
            return false;
        }
        if (this.getWidth() == 0) {
            return true;
        }
        return this.getWidth() == tmp.intValue();
    }

    public boolean canMerge(Signal signal) {
        if (this.getClass() != signal.getClass()) {
            return false;
        }
        SignalStdLogicVector ssv = (SignalStdLogicVector)signal;
        return this.getWidth() == ssv.getWidth();
    }

    public void connect(Port p) {
        if (!this.canConnect(p)) {
            return;
        }
        if (this.getWidth() == 0) {
            Integer tmp = (Integer)p.getOptArg();
            this.setWidth(tmp);
        }
        super.connect(p);
    }

    public boolean addSender(Port p) {
        super.addSender(p);
        int i = 0;
        while (i < this.senders.length) {
            if (this.senders[i] == p) {
                this.driverValues[i] = new StdLogicVector(this.getWidth());
            }
            ++i;
        }
        return true;
    }

    public void addSegment(WireSegment ws) {
        super.addSegment(ws);
        ws.getAttributes().lineWidth = 150.0;
        ws.update(ws.getAttributes());
    }

    public void setValue(Object o) {
        if (Signal.debug) {
            this.dbg("-#- " + this.toString() + ".setValue: " + o);
        }
        this.value = o;
    }

    public void setValue(String s) {
        if (Signal.debug) {
            this.dbg("-I- " + this.toString() + ".setValue(String): " + s);
        }
        try {
            StdLogicVector tmp;
            if (s.indexOf(85) >= 0) {
                tmp = new StdLogicVector(this.getWidth());
            } else if (s.equals("random")) {
                tmp = new StdLogicVector(this.getWidth());
                long l = (long)((double)tmp.getBitMask() * Math.random());
                tmp.setValue(l & tmp.getBitMask());
            } else {
                tmp = new StdLogicVector(this.getWidth());
                tmp.setValue(Long.parseLong(s) & tmp.getBitMask());
            }
            this.value = tmp;
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + ".setValue(String) failed for: " + s);
            ExceptionTracer.trace(e);
        }
    }

    public Color getColor() {
        if (!this.glowMode) {
            return Color.blue;
        }
        long ix = -2L;
        if (this.value != null) {
            ix = ((StdLogicVector)this.value).getValue();
        }
        return Color_DIN_IEC_62.getColor(ix);
    }

    public void elaborate(Object arg) {
        super.elaborate(arg);
        this.lastValue = null;
        this.value = new StdLogicVector(this.getWidth());
        this.lastChangeTime = 0.0;
        int i = 0;
        while (i < this.driverValues.length) {
            this.driverValues[i] = new StdLogicVector(this.getWidth());
            ++i;
        }
        if (this.hasProbe()) {
            this.probe.addValue(this.value, this.lastChangeTime);
        }
        if (this.visible) {
            this.animate();
        }
    }

    public void evaluate(Object arg) {
        if (Signal.debug) {
            System.err.println("SignalStdLogicVector<" + this.getName() + ">.evaluate()");
            System.err.println("    argument: " + arg);
        }
        if (arg == null) {
            return;
        }
        SimEvent event = null;
        try {
            event = (SimEvent)arg;
            if (this.senders.length <= 1) {
                this.lastValue = this.value;
                this.value = (StdLogicVector)event.getArg();
            } else {
                if (Signal.debug) {
                    System.err.println("SVector.eval: resolving...");
                }
                this.extractDriverValue(arg);
                this.lastValue = this.value;
                this.value = this.resolve();
            }
            if (Signal.debug) {
                System.err.println("SSLV.eval: " + this.value + " " + this.lastValue + " " + this.value.equals(this.lastValue));
            }
            if (!this.value.equals(this.lastValue)) {
                this.lastChangeTime = event.getTime();
                int i = 0;
                while (i < this.receivers.length) {
                    event.setTargetPort(this.receivers[i]);
                    this.simulator.addPendingEvent(event, this.receivers[i]);
                    ++i;
                }
                if (this.hasProbe()) {
                    this.probe.addValue(this.value, this.lastChangeTime);
                }
                if (this.visible && this.glowMode) {
                    this.animate();
                }
            }
        }
        catch (Exception e) {
            ExceptionTracer.message("SignalStdLogicVector.evaluate: Exception " + e);
            ExceptionTracer.trace(e);
            return;
        }
    }

    public void handleGlowMode() {
        if (!this.visible) {
            return;
        }
        if (this.segments.length < 1) {
            return;
        }
        ObjectPainter painter = this.segments[0].getObjectPainter();
        int i = 0;
        while (i < this.segments.length) {
            painter.paint(this.segments[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.solderDots.length) {
            painter.paint(this.solderDots[i2]);
            ++i2;
        }
    }

    public void animate() {
        if (!this.glowMode) {
            return;
        }
        if (this.segments.length < 1) {
            return;
        }
        ObjectPainter painter = this.segments[0].getObjectPainter();
        int i = 0;
        while (i < this.segments.length) {
            painter.paint(this.segments[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.solderDots.length) {
            painter.paint(this.solderDots[i2]);
            ++i2;
        }
    }

    public void animateOLD() {
        if (!this.glowMode) {
            return;
        }
        if (this.segments.length < 1) {
            return;
        }
        long ix = -2L;
        if (this.value != null) {
            ix = ((StdLogicVector)this.value).getValue();
        }
        Color color = Color_DIN_IEC_62.getColor(ix);
        ObjectPainter painter = this.segments[0].getObjectPainter();
        if (painter == null) {
            return;
        }
        int i = 0;
        while (i < this.segments.length) {
            this.segments[i].getAttributes().lineColor = color;
            painter.paint(this.segments[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.solderDots.length) {
            this.solderDots[i2].getAttributes().lineColor = color;
            this.solderDots[i2].getAttributes().fillColor = color;
            painter.paint(this.solderDots[i2]);
            ++i2;
        }
    }

    public boolean hasRisingEdge() {
        return false;
    }

    public boolean hasFallingEdge() {
        return false;
    }

    public void extractDriverValue(Object arg) {
        try {
            SimEvent event = (SimEvent)arg;
            Port sender = (Port)event.getSource();
            Object value = event.getArg();
            int i = 0;
            while (i < this.senders.length) {
                if (this.senders[i] == sender) {
                    this.driverValues[i] = value;
                }
                ++i;
            }
        }
        catch (Exception e) {
            ExceptionTracer.message("SSVector.extractDriverValue: " + e);
            ExceptionTracer.message("SSVector.extractDriverValue: arg=" + arg);
            ExceptionTracer.trace(e);
        }
    }

    public Object resolve() {
        if (Signal.debug) {
            System.out.println("-W- SignalStdLogicVector: resolve()... !");
        }
        StdLogicVector[] values = new StdLogicVector[this.driverValues.length];
        int i = 0;
        while (i < this.driverValues.length) {
            values[i] = (StdLogicVector)this.driverValues[i];
            ++i;
        }
        try {
            return StdLogicVector.resolve(values);
        }
        catch (Exception e) {
            ExceptionTracer.message("SSLV: " + e);
            return new StdLogicVector(this.getWidth());
        }
    }

    public void writeAsResource(PrintWriter ps) {
        try {
            ps.print(this.getClass().getName());
            ps.print(" " + this.getName());
            ps.print(" " + this.getWidth());
            this.writePorts(ps);
            this.writeSegments(ps);
            this.writeSolderDots(ps);
            ps.println();
        }
        catch (Exception e) {
            ExceptionTracer.message("-E- exception in Signal.writeAsResource:");
            ExceptionTracer.message("    " + this.toStringVerbose());
            ExceptionTracer.trace(e);
            ps.println();
        }
    }

    public void readFromString(String line, Design design) {
        this.st = new StringTokenizer(line);
        this.setDesign(design);
        this.parseName();
        this.parseWidth();
        this.parsePorts();
        this.parseSegments();
        this.parseSolderDots();
    }

    protected void parseWidth() {
        String s = null;
        try {
            s = this.st.nextToken();
            this.setWidth(Integer.parseInt(s));
        }
        catch (Exception e) {
            this.message("-E- SignalStdLogicVector.readFromString: Error parsing signal width,\n '" + s + "' " + e);
            ExceptionTracer.trace(e);
            return;
        }
    }

    public String getToolTip(Point position, long millis) {
        String s = this.getName() + "\n" + "SignalStdLogicVector<" + (this.width - 1) + ":0>";
        StdLogicVector tmp = (StdLogicVector)this.value;
        s = this.value == null ? s + "\nvalue= null" : s + "\nvalue= " + tmp.toBinString() + "\n" + tmp.toHexString() + " / " + tmp.toDecString();
        return s;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

