/*
 * Decompiled with CFR 0.152.
 */
package hades.signals;

import hades.models.Const1164;
import hades.models.StdLogic1164;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import java.awt.Color;
import java.awt.Point;
import jfig.canvas.ObjectPainter;
import jfig.utils.ExceptionTracer;

public class SignalStdLogic1164
extends Signal {
    protected StdLogic1164 current_1164 = new StdLogic1164();
    protected StdLogic1164 last_1164 = new StdLogic1164();
    protected int _cur;
    protected int _last;
    protected StdLogic1164[] myDriverValues;

    public SignalStdLogic1164() {
        this("n0");
    }

    public SignalStdLogic1164(String name) {
        super(name);
        this.value = this.current_1164;
        this.lastValue = this.last_1164;
        this._cur = this.current_1164.intValue();
        this._last = this.last_1164.intValue();
        this.updateDriverArray();
    }

    public SignalStdLogic1164(String name, Port[] senders, Port[] receivers) {
        this(name);
        this.senders = senders;
        this.receivers = receivers;
        this.updateDriverArray();
    }

    public void updateDriverArray() {
        this.myDriverValues = new StdLogic1164[this.senders.length];
        try {
            int i = 0;
            while (i < this.myDriverValues.length) {
                StdLogic1164 tmp = (StdLogic1164)this.senders[i].getValue();
                this.myDriverValues[i] = tmp == null ? Const1164.__U : tmp;
                ++i;
            }
        }
        catch (Exception e) {
            ExceptionTracer.message("-E- internal error: " + e);
            ExceptionTracer.trace(e);
        }
    }

    public Object getValue() {
        return this.current_1164;
    }

    public Object getPreviousValue() {
        return this.last_1164;
    }

    public boolean addSender(Port p) {
        super.addSender(p);
        this.updateDriverArray();
        return true;
    }

    public boolean deleteSender(Port p) {
        boolean status = super.deleteSender(p);
        this.updateDriverArray();
        return status;
    }

    public Color getColor() {
        if (this.glowMode) {
            return ((StdLogic1164)this.getValue()).getColor();
        }
        return Color.blue;
    }

    public void elaborate(Object arg) {
        super.elaborate(arg);
        this._last = 0;
        this._cur = 0;
        this.current_1164.setIntValue(this._cur);
        this.last_1164.setIntValue(this._last);
        this.value = this.current_1164;
        this.lastValue = this.last_1164;
        this.lastChangeTime = 0.0;
        int i = 0;
        while (i < this.myDriverValues.length) {
            this.myDriverValues[i] = new StdLogic1164();
            ++i;
        }
        if (this.hasProbe()) {
            this.probe.addValue(this.value, this.lastChangeTime);
        }
        if (this.visible) {
            this.animate();
        }
    }

    public void evaluate(Object arg) {
        if (Signal.debug) {
            System.err.println("SignalStdLogic1164<" + this.getName() + ">.evaluate()");
            System.err.println("    argument: " + arg);
        }
        if (arg == null) {
            return;
        }
        SimEvent event = null;
        try {
            event = (SimEvent)arg;
            if (this.senders.length <= 1) {
                int _new = ((StdLogic1164)event.getArg()).intValue();
                if (this._last != this._cur) {
                    this._last = this._cur;
                    this.last_1164.setIntValue(this._last);
                }
                if (_new != this._cur) {
                    this._cur = _new;
                    this.current_1164.setIntValue(this._cur);
                }
            } else {
                this.extractDriverValue(arg);
                if (this._last != this._cur) {
                    this._last = this._cur;
                    this.last_1164.setIntValue(this._last);
                }
                this.current_1164.setToResolve(this.myDriverValues);
                this._cur = this.current_1164.intValue();
            }
            if (this._cur != this._last) {
                this.lastChangeTime = event.getTime();
                int i = 0;
                while (i < this.receivers.length) {
                    this.simulator.addPendingEvent(event, this.receivers[i]);
                    ++i;
                }
                if (this.hasProbe()) {
                    this.probe.addValue(this.value, this.lastChangeTime);
                }
                if (this.visible && this.glowMode) {
                    this.animate();
                }
            }
        }
        catch (Exception e) {
            ExceptionTracer.message("SignalStdLogic1164.evaluate: Exception " + e);
            ExceptionTracer.message("Event is: " + event);
            ExceptionTracer.trace(e);
            return;
        }
    }

    public void propagateConnectivityChanges() {
        Signal.debug = true;
        if (this.getSimulator() == null) {
            return;
        }
        double time = this.getSimulator().getSimTime();
        if (Signal.debug) {
            this.dbg("-I- " + this.toString() + ":propagateConnectivityChanges...");
        }
        if (Signal.debug) {
            this.dbg("... currentValue: " + this.current_1164);
        }
        int i = 0;
        while (i < this.myDriverValues.length) {
            if (Signal.debug) {
                this.dbg("...senders[" + i + "]= " + this.myDriverValues[i]);
            }
            ++i;
        }
        Signal.debug = false;
        if (time <= 0.0) {
            return;
        }
        Object source = null;
        SimEvent event = SimEvent.createNewSimEvent(this, time, this.current_1164, source);
        this.last_1164.setIntValue(this.current_1164.intValue());
        this.current_1164.setIntValue(((StdLogic1164)this.resolve()).intValue());
        this.lastChangeTime = event.getTime();
        int i2 = 0;
        while (i2 < this.receivers.length) {
            event.setTargetPort(this.receivers[i2]);
            this.receivers[i2].getHandler().evaluate(event);
            ++i2;
        }
        if (this.hasProbe()) {
            this.probe.addValue(this.value, this.lastChangeTime);
        }
        if (this.visible && this.glowMode) {
            this.animate();
        }
    }

    public void handleGlowMode() {
        if (!this.visible) {
            return;
        }
        if (this.segments.length < 1) {
            return;
        }
        ObjectPainter painter = this.segments[0].getObjectPainter();
        int i = 0;
        while (i < this.segments.length) {
            painter.paint(this.segments[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.solderDots.length) {
            painter.paint(this.solderDots[i2]);
            ++i2;
        }
    }

    public void animate() {
        if (!this.glowMode) {
            return;
        }
        if (this.segments.length < 1) {
            return;
        }
        ObjectPainter painter = this.segments[0].getObjectPainter();
        int i = 0;
        while (i < this.segments.length) {
            painter.paint(this.segments[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.solderDots.length) {
            painter.paint(this.solderDots[i2]);
            ++i2;
        }
    }

    public boolean hasRisingEdge() {
        StdLogic1164 now = (StdLogic1164)this.getValue();
        StdLogic1164 old = (StdLogic1164)this.getPreviousValue();
        return this.hasEvent() && now.is_1() && old.is_0();
    }

    public boolean hasFallingEdge() {
        StdLogic1164 now = (StdLogic1164)this.getValue();
        StdLogic1164 old = (StdLogic1164)this.getPreviousValue();
        return this.hasEvent() && now.is_0() && old.is_1();
    }

    public void extractDriverValue(Object arg) {
        try {
            SimEvent event = (SimEvent)arg;
            Port sender = (Port)event.getSource();
            Object value = event.getArg();
            StdLogic1164 value_1164 = (StdLogic1164)this.getValue();
            if (value_1164 == null) {
                value_1164 = Const1164.__U;
            }
            int i = 0;
            while (i < this.senders.length) {
                if (this.senders[i] == sender) {
                    this.myDriverValues[i] = (StdLogic1164)value;
                }
                ++i;
            }
        }
        catch (Exception e) {
            ExceptionTracer.message("SS1164.extractDriverValue: " + e);
            ExceptionTracer.message("SS1164.extractDriverValue: arg=" + arg);
            ExceptionTracer.trace(e);
        }
    }

    public StdLogic1164 getDriverValueAsStdLogic1164(int i) {
        return this.myDriverValues[i];
    }

    public Object resolve() {
        return StdLogic1164.resolve(this.myDriverValues);
    }

    public String getToolTip(Point position, long millis) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append("\n");
        sb.append("SignalStdLogic1164\n");
        if (this.value == null) {
            sb.append("\nvalue= null");
        } else {
            sb.append("\nvalue= " + ((StdLogic1164)this.value).getChar());
        }
        return sb.toString();
    }

    public String toString() {
        return "SignalStdLogic1164 '" + this.getFullName() + "' value= " + this.getValue();
    }
}

