/*
 * Decompiled with CFR 0.152.
 */
package hades.signals;

import hades.gui.Console;
import hades.models.Design;
import hades.models.io.Ipin;
import hades.simulator.Port;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.styx.Waveform;
import hades.symbols.ColorSource;
import hades.symbols.Label;
import hades.symbols.ProbeSymbol;
import hades.symbols.SolderDot;
import hades.symbols.WireSegment;
import hades.utils.ContextToolTip;
import hades.utils.NameMangler;
import java.awt.Color;
import java.awt.Point;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import jfig.canvas.FigTrafo2D;
import jfig.objects.FigObject;
import jfig.utils.ExceptionTracer;

public class Signal
implements Simulatable,
ColorSource,
ContextToolTip,
Serializable {
    protected SimKernel simulator;
    protected Port[] receivers;
    protected Port[] senders;
    protected Object[] driverValues;
    protected Design design;
    protected String name;
    protected Object value = null;
    protected Object lastValue = null;
    protected double lastChangeTime = 0.0;
    protected boolean visible = false;
    protected WireSegment[] segments;
    protected SolderDot[] solderDots;
    protected boolean glowMode = false;
    protected Label label;
    protected ProbeSymbol probeSymbol;
    protected Waveform probe;
    protected StringTokenizer st;
    protected static boolean debug = false;
    protected Hashtable vertexTable;
    protected Hashtable portPositionTable;
    protected Hashtable VI;
    protected Point[] VA;
    protected Vector[] EA;
    protected boolean[] visited;
    protected boolean[] isRoot;
    protected int[] DFS;

    public Signal() {
        this("n0");
    }

    public Signal(String name) {
        this.name = name;
        this.simulator = null;
        this.senders = new Port[0];
        this.receivers = new Port[0];
        this.driverValues = new Object[0];
        this.visible = false;
        this.buildSegments();
        this.probe = null;
        this.probeSymbol = null;
    }

    public Signal(String name, Port[] senders, Port[] receivers) {
        this(name);
        this.senders = senders;
        this.receivers = receivers;
        this.driverValues = new Object[senders.length];
    }

    public Design getDesign() {
        return this.design;
    }

    public void setDesign(Design d) {
        this.design = d;
    }

    public static boolean getDebug() {
        return debug;
    }

    public static void setDebug(boolean d) {
        debug = d;
    }

    public SimKernel getSimulator() {
        return this.simulator;
    }

    public void setSimulator(SimKernel simulator) {
        this.simulator = simulator;
    }

    public Port[] getReceivers() {
        return this.receivers;
    }

    public Port[] getSenders() {
        return this.senders;
    }

    public Object[] getDriverValues() {
        return this.driverValues;
    }

    public int countSendersAndReceivers() {
        return this.receivers.length + this.senders.length;
    }

    public int numberOfDrivers() {
        return this.senders.length;
    }

    public boolean hasProbe() {
        return this.probe != null;
    }

    public Waveform getProbe() {
        return this.probe;
    }

    public void setProbe(Waveform w) {
        this.probe = w;
        w.addValue(this.value, this.lastChangeTime);
    }

    public void removeProbe() {
        this.probe = null;
        this.probeSymbol = null;
    }

    public void setProbeSymbol(ProbeSymbol ps) {
        this.probeSymbol = ps;
    }

    public ProbeSymbol getProbeSymbol() {
        return this.probeSymbol;
    }

    public Color getColor() {
        return Color.blue;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean v) {
        this.visible = v;
    }

    private void buildSegments() {
        this.segments = new WireSegment[0];
        this.solderDots = new SolderDot[0];
    }

    public Label getLabel() {
        return this.label;
    }

    protected void createLabel() {
        this.label = new Label();
        this.label.setText(this.name);
        Point pos = this.segments.length != 0 ? this.getSegments()[0].getPosition() : new Point(0, 0);
        this.label.move(pos.x, pos.y);
    }

    protected void moveLabelTo(Point p) {
        this.label = new Label();
        this.label.setText(this.name);
        this.label.move(p.x, p.y);
    }

    public FigObject[] getSegments() {
        return this.segments;
    }

    public int countSegments() {
        return this.segments.length;
    }

    public FigObject[] getSolderDots() {
        return this.solderDots;
    }

    public void addSegment(WireSegment ws) {
        if (this.segments == null) {
            this.segments = new WireSegment[1];
            this.segments[0] = ws;
            this.createLabel();
        } else {
            WireSegment[] tmp = new WireSegment[this.segments.length + 1];
            int i = 0;
            while (i < this.segments.length) {
                tmp[i] = this.segments[i];
                ++i;
            }
            tmp[this.segments.length] = ws;
            this.segments = tmp;
        }
        ws.setSignal(this);
        if (debug) {
            this.printSegments();
        }
    }

    public void printSegments() {
        System.out.println(this.toString() + " .printSegments:");
        int i = 0;
        while (i < this.segments.length) {
            System.out.println(" " + i + " " + this.segments[i]);
            ++i;
        }
    }

    public void deleteSegment(WireSegment ws) {
        boolean found = false;
        int i = 0;
        while (i < this.segments.length) {
            if (this.segments[i] == ws) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            this.message("-E- Signal.deleteSegment: segment not found: " + ws);
            return;
        }
        WireSegment[] tmp = new WireSegment[this.segments.length - 1];
        int i2 = 0;
        int j = 0;
        while (i2 < this.segments.length) {
            if (this.segments[i2] != ws) {
                tmp[j++] = this.segments[i2];
            }
            ++i2;
        }
        this.segments = tmp;
    }

    public void addSolderDot(SolderDot sd) {
        if (this.solderDots == null) {
            this.solderDots = new SolderDot[1];
            this.solderDots[0] = new SolderDot();
        } else {
            SolderDot[] tmp = new SolderDot[this.solderDots.length + 1];
            int i = 0;
            while (i < this.solderDots.length) {
                tmp[i] = this.solderDots[i];
                ++i;
            }
            tmp[this.solderDots.length] = sd;
            this.solderDots = tmp;
        }
    }

    public void setTrafo(FigTrafo2D trafo) {
        int i;
        if (this.segments != null) {
            i = 0;
            while (i < this.segments.length) {
                this.segments[i].setTrafo(trafo);
                ++i;
            }
        }
        if (this.solderDots != null) {
            i = 0;
            while (i < this.solderDots.length) {
                this.solderDots[i].setTrafo(trafo);
                ++i;
            }
        }
        if (this.label != null) {
            this.label.setTrafo(trafo);
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object o) {
        this.message("-E- Signal.setValue(Object), ignored: " + o);
    }

    public void setValue(String s) {
        this.message("-E- Signal.setValue(String), ignored: " + s);
    }

    public Object getPreviousValue() {
        return this.lastValue;
    }

    public double getLastChangeTime() {
        return this.lastChangeTime;
    }

    public boolean isStable(double dt) {
        return this.simulator.getSimTime() - this.lastChangeTime > dt;
    }

    public boolean hasEvent() {
        return this.simulator.getSimTime() - this.lastChangeTime < 1.0E-9;
    }

    public void setName(String _name) {
        this.name = NameMangler.getValidName(_name);
        this.name = this.name.intern();
        if (this.label != null) {
            this.label.setText(this.name);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        if (this.design == null) {
            return this.name;
        }
        return this.design.getFullName() + "/" + this.name;
    }

    public String renameAfterDriver() {
        if (this.numberOfDrivers() <= 0) {
            return this.getName();
        }
        String tmp = this.getName();
        try {
            Port port = this.senders[0];
            SimObject parent = port.getParent();
            tmp = parent instanceof Ipin ? parent.getName() : parent.getName() + "." + port.getName();
        }
        catch (Exception e) {
            this.message("-E- internal error: " + e);
            e.printStackTrace();
        }
        this.setName(tmp);
        return tmp;
    }

    public void setGlowMode(boolean b) {
        this.glowMode = b;
        this.handleGlowMode();
    }

    public boolean getGlowMode() {
        return this.glowMode;
    }

    public void handleGlowMode() {
    }

    public boolean canConnect(Port port) {
        if (port == null) {
            return false;
        }
        if (port.getSignal() != null) {
            return false;
        }
        if (this.getClass() == port.getSignalClass()) {
            return true;
        }
        if (port.getSignalClass().isInstance(this)) {
            return true;
        }
        Console.getConsole().message("-W- Port signal type mismatch:" + this.getClass() + " vs. " + port.getSignalClass());
        return false;
    }

    public boolean canMerge(Signal signal) {
        return this.getClass() == signal.getClass();
    }

    public boolean isConnected(Port port) {
        Port[] _senders = this.getSenders();
        int i = 0;
        while (i < _senders.length) {
            if (_senders[i] == port) {
                return true;
            }
            ++i;
        }
        Port[] _receivers = this.getReceivers();
        int i2 = 0;
        while (i2 < _receivers.length) {
            if (_receivers[i2] == port) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public void connect(Port p) {
        p.setSignal(this);
        switch (p.getType()) {
            case 0: {
                this.addReceiver(p);
                break;
            }
            case 3: {
                this.addReceiver(p);
                break;
            }
            case 6: {
                this.addReceiver(p);
                break;
            }
            case 1: {
                this.addSender(p);
                break;
            }
            case 2: {
                this.addReceiver(p);
                this.addSender(p);
                break;
            }
            default: {
                this.message("-E- Internal error in Signal.connect(): illegal Port direction=" + p.getType());
            }
        }
    }

    public void disconnect(Port p) {
        if (debug) {
            this.message("-I- Signal.disconnect(): " + p);
        }
        if (p == null) {
            this.message("-W- Signal.disconnect: p is null");
            return;
        }
        switch (p.getType()) {
            case 1: {
                this.deleteSender(p);
                break;
            }
            case 2: {
                this.deleteSender(p);
                this.deleteReceiver(p);
                break;
            }
            case 0: 
            case 3: 
            case 6: {
                this.deleteReceiver(p);
                break;
            }
            default: {
                this.message("-E- Unknown port type in Signal.disconnect: " + p);
            }
        }
        p.setSignal(null);
    }

    public void disconnectAll() {
        Port[] _senders = this.getSenders();
        int i = 0;
        while (i < _senders.length) {
            this.disconnect(_senders[i]);
            ++i;
        }
        Port[] _receivers = this.getReceivers();
        int i2 = 0;
        while (i2 < _receivers.length) {
            this.disconnect(_receivers[i2]);
            ++i2;
        }
    }

    public void propagateConnectivityChanges() {
        this.message("-E- Signal: propagateConnectivityChanges empty!");
    }

    public boolean addSender(Port p) {
        if (this.senders == null || this.senders.length == 0) {
            this.senders = new Port[1];
            this.senders[0] = p;
            this.driverValues = new Object[1];
            this.driverValues[0] = null;
            return true;
        }
        Port[] tmp = new Port[this.senders.length + 1];
        Object[] val = new Object[this.senders.length + 1];
        int i = 0;
        while (i < this.senders.length) {
            tmp[i] = this.senders[i];
            val[i] = this.driverValues[i];
            ++i;
        }
        tmp[this.senders.length] = p;
        val[this.senders.length] = null;
        this.senders = tmp;
        this.driverValues = val;
        return true;
    }

    public boolean deleteSender(Port p) {
        if (p == null) {
            this.message("-E- Signal.deleteSender: no such sender: " + p);
            return false;
        }
        boolean found = false;
        int i = 0;
        while (i < this.senders.length) {
            if (this.senders[i] == p) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            this.message("-E- Signal.deleteSender: not a sender: " + p);
            return false;
        }
        Port[] tmp = new Port[this.senders.length - 1];
        Object[] val = new Object[this.senders.length - 1];
        int i2 = 0;
        int j = 0;
        while (i2 < this.senders.length) {
            if (this.senders[i2] != p) {
                tmp[j] = this.senders[i2];
                val[j] = this.senders[i2];
                ++j;
            }
            ++i2;
        }
        this.senders = tmp;
        this.driverValues = val;
        if (debug) {
            this.message("-I-" + this.toStringVerbose());
        }
        return true;
    }

    public boolean addReceiver(Port p) {
        if (this.receivers == null) {
            this.receivers = new Port[1];
            this.receivers[0] = p;
            return true;
        }
        Port[] tmp = new Port[this.receivers.length + 1];
        int i = 0;
        while (i < this.receivers.length) {
            tmp[i] = this.receivers[i];
            ++i;
        }
        tmp[this.receivers.length] = p;
        this.receivers = tmp;
        return true;
    }

    public boolean deleteReceiver(Port p) {
        if (debug) {
            this.message("-I- before deleteReceiver: " + this.toStringVerbose());
        }
        if (p == null) {
            this.message("-E- Signal.deleteReceiver: no such receiver: " + p);
            return false;
        }
        boolean found = false;
        int i = 0;
        while (i < this.receivers.length) {
            if (this.receivers[i] == p) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            this.message("-E- Signal.deleteReceiver: not a receiver: " + p);
            return false;
        }
        Port[] tmp = new Port[this.receivers.length - 1];
        int i2 = 0;
        int j = 0;
        while (i2 < this.receivers.length) {
            if (this.receivers[i2] != p) {
                tmp[j] = this.receivers[i2];
                ++j;
            }
            ++i2;
        }
        this.receivers = tmp;
        if (debug) {
            this.message("-I-" + this.toStringVerbose());
        }
        return true;
    }

    public void elaborate(Object arg) {
        this.lastChangeTime = 0.0;
        this.value = null;
        this.lastValue = null;
    }

    public void evaluate(Object arg) {
        this.message("-E- Signal.evaluate(): IGNORED by (abstract) class Signal");
    }

    public void message(String msg) {
        Console.getConsole().message(msg);
    }

    public void write(PrintWriter ps) {
        this.writeAsResource(ps);
    }

    public String toString() {
        return "Signal '" + this.getFullName() + "' value= " + this.getValue();
    }

    public String toStringVerboseOld() {
        String s = "Signal '" + this.getFullName() + "' [" + this.getClass().getName() + "] \n    value: " + this.getValue() + "\n    senders: ";
        int i = 0;
        while (i < this.senders.length) {
            s = s + "  " + this.senders[i].getParent().getFullName() + "." + this.senders[i].getName();
            ++i;
        }
        s = s + "\n    receivers: ";
        int i2 = 0;
        while (i2 < this.receivers.length) {
            s = s + "  " + this.receivers[i2].getParent().getFullName() + "." + this.receivers[i2].getName();
            ++i2;
        }
        return s;
    }

    public String toStringVerbose() {
        StringBuffer sb = new StringBuffer("");
        try {
            sb.append("Signal '" + this.getFullName() + "' [" + this.getClass().getName() + "] \n    value: " + this.getValue() + "\n    senders: ");
            int i = 0;
            while (i < this.senders.length) {
                if (this.senders[i] != null && this.senders[i].getParent() != null) {
                    sb.append("  " + this.senders[i].getParent().getFullName() + "." + this.senders[i].getName());
                }
                ++i;
            }
            sb.append(" receivers: ");
            int i2 = 0;
            while (i2 < this.receivers.length) {
                if (this.receivers[i2] != null && this.receivers[i2].getParent() != null) {
                    sb.append("  " + this.receivers[i2].getParent().getFullName() + "." + this.receivers[i2].getName());
                }
                ++i2;
            }
        }
        catch (Exception e) {
            ExceptionTracer.trace(e);
        }
        return sb.toString();
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "value=" + this.getValue();
    }

    public void tearDown() {
        if (debug) {
            System.err.println("-#- Signal.tearDown: " + this.name);
        }
        this.design = null;
        this.simulator = null;
        this.receivers = null;
        this.senders = null;
        this.segments = null;
        this.solderDots = null;
        this.label = null;
        this.probeSymbol = null;
        this.probe = null;
        this.driverValues = null;
        this.value = null;
        this.lastValue = null;
        this.name = null;
    }

    public void writeAsResource(PrintWriter ps) {
        try {
            ps.print(this.getClass().getName());
            ps.print(" " + this.getName());
            this.writePorts(ps);
            this.writeSegments(ps);
            this.writeSolderDots(ps);
            ps.println();
        }
        catch (Exception e) {
            ExceptionTracer.message("-E- exception in Signal.writeAsResource:");
            ExceptionTracer.message("    " + this.toStringVerbose());
            ExceptionTracer.trace(e);
            ps.println();
        }
    }

    protected void writePorts(PrintWriter ps) throws Exception {
        Port P;
        int i;
        int n_ports = 0;
        if (this.senders != null) {
            n_ports += this.senders.length;
        }
        if (this.receivers != null) {
            i = 0;
            while (i < this.receivers.length) {
                if (this.receivers[i].getType() != 2) {
                    ++n_ports;
                }
                ++i;
            }
        }
        ps.print(" " + n_ports);
        if (this.senders != null) {
            i = 0;
            while (i < this.senders.length) {
                P = this.senders[i];
                ps.print(" " + P.getParent().getName() + " " + P.getName());
                ++i;
            }
        }
        if (this.receivers != null) {
            i = 0;
            while (i < this.receivers.length) {
                P = this.receivers[i];
                if (P.getType() != 2) {
                    ps.print(" " + P.getParent().getName() + " " + P.getName());
                }
                ++i;
            }
        }
    }

    protected void writeSegments(PrintWriter ps) throws Exception {
        if (this.segments != null) {
            ps.print(" " + this.segments.length);
            int i = 0;
            while (i < this.segments.length) {
                Point[] points = this.segments[i].getPoints();
                ps.print(" " + points.length);
                int j = 0;
                while (j < points.length) {
                    ps.print(" " + points[j].x + " " + points[j].y);
                    ++j;
                }
                ++i;
            }
        } else {
            ps.print(" ");
        }
    }

    public void writeSolderDots(PrintWriter ps) throws Exception {
        if (this.solderDots != null) {
            ps.print(" " + this.solderDots.length + " ");
            int i = 0;
            while (i < this.solderDots.length) {
                Point pp = this.solderDots[i].getCenterPoint();
                ps.print(pp.x + " " + pp.y + " ");
                ++i;
            }
        } else {
            ps.print(" 0 ");
        }
    }

    public void readFromString(String line, Design design) {
        this.setDesign(design);
        this.st = new StringTokenizer(line);
        this.parseName();
        this.parsePorts();
        if (this.visible) {
            this.parseSegments();
        }
        if (this.visible) {
            this.parseSolderDots();
        }
    }

    public void parseName() {
        String s = null;
        try {
            s = this.st.nextToken();
            this.name = s.intern();
        }
        catch (Exception e) {
            this.message("-E- Signal.readFromString: Error parsing signal name: " + e + "\n nextToken= " + s);
            ExceptionTracer.trace(e);
            return;
        }
    }

    protected void parsePorts() {
        int n_ports = 0;
        String instancename = null;
        String portname = null;
        try {
            n_ports = Integer.parseInt(this.st.nextToken());
            if (n_ports == 0) {
                this.message("-E- Signal " + this.getName() + " unconnected (0 ports)!");
            }
            int i = 0;
            while (i < n_ports) {
                instancename = this.st.nextToken();
                portname = this.st.nextToken();
                SimObject comp = null;
                try {
                    comp = this.design.getComponent(instancename);
                }
                catch (Throwable tttt) {
                    tttt.printStackTrace();
                }
                if (comp == null) {
                    this.message("-E- Signal.parsePorts: component not found: '" + instancename + "', cannot connect signal '" + this.getName() + "' to port '" + portname + "'");
                } else {
                    Port tmp = comp.getPort(portname);
                    if (tmp == null) {
                        this.message("-E- Signal.parsePorts: port '" + portname + "' not found on component '" + instancename + "', cannot connect to signal '" + this.getName() + "'");
                    } else if (this.isConnected(tmp)) {
                        this.message("-W- Signal.parsePorts: multiple connection to port '" + portname + ", ignored and fixed for signal '" + this.getName() + "'");
                    } else {
                        this.connect(tmp);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.message("-E- Signal.readFromString: Error parsing ports,\n" + e + " n,iname,pname: " + n_ports + " " + instancename + " " + portname);
            ExceptionTracer.trace(e);
            return;
        }
    }

    protected void parseSegments() {
        if (!this.visible) {
            return;
        }
        int n_segments = 0;
        int n_points = 0;
        int x = 0;
        int y = 0;
        try {
            n_segments = Integer.parseInt(this.st.nextToken());
            if (n_segments == 0) {
                this.message("-E- Signal " + this.getName() + " has 0 segments?!");
            }
            int i = 0;
            while (i < n_segments) {
                n_points = Integer.parseInt(this.st.nextToken());
                Point[] wp = new Point[n_points];
                int j = 0;
                while (j < n_points) {
                    x = Integer.parseInt(this.st.nextToken());
                    y = Integer.parseInt(this.st.nextToken());
                    wp[j] = new Point(x, y);
                    ++j;
                }
                int j2 = 0;
                while (j2 < n_points - 1) {
                    Point[] wp2 = new Point[]{wp[j2], wp[j2 + 1]};
                    WireSegment ws = new WireSegment(this);
                    ws.setPoints(wp2);
                    this.addSegment(ws);
                    ++j2;
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.message("-E- Signal.readFromString: Error parsing segments,\n" + e);
            ExceptionTracer.trace(e);
            return;
        }
    }

    protected void parseSolderDots() {
        if (!this.visible) {
            return;
        }
        int n_solderDots = 0;
        int x = 0;
        int y = 0;
        try {
            n_solderDots = Integer.parseInt(this.st.nextToken());
            this.solderDots = new SolderDot[n_solderDots];
            int i = 0;
            while (i < n_solderDots) {
                x = Integer.parseInt(this.st.nextToken());
                y = Integer.parseInt(this.st.nextToken());
                this.solderDots[i] = new SolderDot(this, new Point(x, y));
                ++i;
            }
        }
        catch (Exception e) {
            this.message("-E- Signal.readFromString: Error in phase 2,\n" + e);
            ExceptionTracer.trace(e);
            return;
        }
    }

    public Hashtable getVertexTable() {
        return this.vertexTable;
    }

    public void createVertexTable() {
        this.deleteSingularSegments();
        this.vertexTable = new Hashtable(13);
        int i = 0;
        while (i < this.segments.length) {
            Point[] points = this.segments[i].getPoints();
            this.addPointToVertexTable(points[0]);
            this.addPointToVertexTable(points[1]);
            ++i;
        }
    }

    public void deleteSingularSegments() {
        WireSegment[] tmp = new WireSegment[this.segments.length];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = this.segments[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < tmp.length) {
            try {
                Point[] points = tmp[i2].getPoints();
                if (points[0].equals(points[1])) {
                    if (debug) {
                        this.dbg("-I- deleting singular wire segment: " + tmp[i2]);
                    }
                    this.deleteSegment(tmp[i2]);
                }
            }
            catch (Exception e) {
                ExceptionTracer.trace(e);
                this.deleteSegment(tmp[i2]);
            }
            ++i2;
        }
    }

    private void addPointToVertexTable(Point p) {
        if (this.vertexTable.containsKey(p)) {
            Integer I = (Integer)this.vertexTable.get(p);
            this.vertexTable.put(p, new Integer(I + 1));
        } else {
            this.vertexTable.put(p, new Integer(1));
        }
    }

    public void printVertexTable() {
        if (this.vertexTable == null) {
            this.createVertexTable();
        }
        this.message("VertexTable of Signal: " + this.getName() + "(");
        Enumeration E = this.vertexTable.keys();
        while (E.hasMoreElements()) {
            Point p = (Point)E.nextElement();
            int n = (Integer)this.vertexTable.get(p);
            this.message("   vertex=" + p + " multiplicity=" + n);
        }
        this.message(")");
    }

    public boolean isVertex(Point p) {
        if (this.vertexTable == null) {
            this.createVertexTable();
        }
        return this.vertexTable.containsKey(p);
    }

    public void createPortPositionTable() {
        this.portPositionTable = new Hashtable(23);
        int i = 0;
        while (i < this.senders.length) {
            this.addPortPosition(this.portPositionTable, this.senders[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.receivers.length) {
            this.addPortPosition(this.portPositionTable, this.receivers[i2]);
            ++i2;
        }
    }

    private void addPortPosition(Hashtable portPositionTable, Port port) {
        try {
            Point pos = port.getParent().getSymbol().getPortPosition(port);
            portPositionTable.put(pos, new Boolean(true));
        }
        catch (Exception e) {
            System.err.println("-#- Signal.addPortPosition: " + port);
            System.err.println("-#- " + e);
            e.printStackTrace();
        }
    }

    public boolean isPortPosition(Point p) {
        if (this.portPositionTable == null) {
            this.createPortPositionTable();
        }
        return this.portPositionTable.get(p) != null;
    }

    public void printPortPositionTable() {
        if (this.portPositionTable == null) {
            this.createPortPositionTable();
        }
        this.message("-I- PortPositionTable: ");
        Enumeration E = this.portPositionTable.keys();
        while (E.hasMoreElements()) {
            this.message("...port at: " + E.nextElement());
        }
    }

    public void buildVertexArrays() {
        if (this.vertexTable == null) {
            this.createVertexTable();
        }
        int n_vertices = this.vertexTable.size();
        this.VI = new Hashtable(13);
        this.VA = new Point[n_vertices];
        this.EA = new Vector[n_vertices];
        this.visited = new boolean[n_vertices];
        this.isRoot = new boolean[n_vertices];
        int i = 0;
        Enumeration E = this.vertexTable.keys();
        while (E.hasMoreElements()) {
            Point p = (Point)E.nextElement();
            this.VI.put(p, new Integer(i));
            this.VA[i] = p;
            this.EA[i] = new Vector();
            this.visited[i] = false;
            this.isRoot[i] = false;
            ++i;
        }
    }

    public void buildEdgeVectors() {
        int i = 0;
        while (i < this.segments.length) {
            Point[] pp = this.segments[i].getPoints();
            int index0 = (Integer)this.VI.get(pp[0]);
            int index1 = (Integer)this.VI.get(pp[1]);
            this.EA[index0].addElement(new Integer(index1));
            this.EA[index1].addElement(new Integer(index0));
            ++i;
        }
    }

    public void DFS() {
        if (this.VA == null) {
            this.buildVertexArrays();
            this.buildEdgeVectors();
        }
        this.DFS = new int[this.VA.length];
        int i = 0;
        while (i < this.visited.length) {
            this.visited[i] = false;
            this.isRoot[i] = false;
            ++i;
        }
        int ri = 0;
        int i2 = 0;
        while (i2 < this.VA.length) {
            if (!this.visited[i2]) {
                this.isRoot[ri] = true;
                ri = this.DFS_step(i2, ri);
            }
            ++i2;
        }
    }

    private int DFS_step(int vi, int ri) {
        if (debug) {
            this.dbg("DFS_step: " + vi + " " + ri);
        }
        if (ri == this.VA.length) {
            return ri;
        }
        if (this.visited[vi]) {
            return ri;
        }
        this.visited[vi] = true;
        this.DFS[ri] = vi;
        ++ri;
        int i = 0;
        while (i < this.EA[vi].size()) {
            int next_vi = (Integer)this.EA[vi].elementAt(i);
            if (!this.visited[next_vi]) {
                ri = this.DFS_step(next_vi, ri);
            }
            ++i;
        }
        return ri;
    }

    public void printDFS() {
        if (this.VA == null) {
            this.buildVertexArrays();
            this.buildEdgeVectors();
            this.printGraph();
        }
        this.DFS();
        this.message("DFS numbering: ");
        int i = 0;
        while (i < this.VA.length) {
            this.message("DFS[i] " + this.DFS[i] + " is root " + this.isRoot[i]);
            ++i;
        }
    }

    public void printGraph() {
        if (this.VA == null) {
            this.buildVertexArrays();
            this.buildEdgeVectors();
        }
        this.message("Signal " + this.getFullName() + " with " + this.VA.length + " vertices: ");
        int i = 0;
        while (i < this.VA.length) {
            String str = "Vertex[" + i + "] at " + this.VA[i] + " edges to: ";
            int j = 0;
            while (j < this.EA[i].size()) {
                str = str + " " + (Integer)this.EA[i].elementAt(j);
                ++j;
            }
            this.message(str);
            ++i;
        }
    }

    public int countSubgraphs() {
        if (this.VA == null) {
            this.buildVertexArrays();
            this.buildEdgeVectors();
            this.DFS();
        }
        int n_splitters = 0;
        int i = 0;
        while (i < this.isRoot.length) {
            if (this.isRoot[i]) {
                ++n_splitters;
            }
            ++i;
        }
        if (debug) {
            this.dbg("countSubgraphs: found " + n_splitters + " subgraphs...");
        }
        return n_splitters;
    }

    public Signal[] splitIntoSubgraphs() {
        boolean found;
        int j;
        if (debug) {
            this.dbg("Signal.splitIntoSubgraphs: " + this.toStringVerbose());
        }
        int n_splitters = this.countSubgraphs();
        Signal[] splitters = new Signal[n_splitters];
        Hashtable[] s_vertices = new Hashtable[n_splitters];
        Hashtable[] s_segments = new Hashtable[n_splitters];
        int i = 0;
        while (i < n_splitters) {
            try {
                splitters[i] = (Signal)this.getClass().newInstance();
                splitters[i].setName(this.getName() + "_" + i);
                splitters[i].setVisible(true);
            }
            catch (Exception ie) {
                this.message("-E- Internal error in Signal.splitIS: " + ie);
            }
            s_vertices[i] = new Hashtable(13);
            s_segments[i] = new Hashtable(13);
            ++i;
        }
        int n = -1;
        int i2 = 0;
        while (i2 < this.isRoot.length) {
            if (this.isRoot[i2]) {
                ++n;
            }
            s_vertices[n].put(this.VA[this.DFS[i2]], new Integer(n));
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.segments.length) {
            Point[] pp = this.segments[i3].getPoints();
            j = 0;
            while (j < n_splitters) {
                if (s_vertices[j].containsKey(pp[0]) || s_vertices[j].containsKey(pp[1])) {
                    s_segments[j].put(this.segments[i3], new Integer(j));
                    break;
                }
                ++j;
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.segments.length) {
            j = 0;
            while (j < n_splitters) {
                if (s_segments[j].containsKey(this.segments[i4])) {
                    splitters[j].addSegment(this.segments[i4]);
                    this.segments[i4].setSignal(splitters[j]);
                }
                ++j;
            }
            ++i4;
        }
        int i5 = 0;
        while (i5 < this.receivers.length) {
            found = this.findSplitterForPort(splitters, s_vertices, this.receivers[i5]);
            if (!found && debug) {
                this.dbg("-E- internal error in Signal.splitIS: receiver " + this.receivers[i5] + " not reconnected!");
            }
            ++i5;
        }
        int i6 = 0;
        while (i6 < this.senders.length) {
            found = this.findSplitterForPort(splitters, s_vertices, this.senders[i6]);
            if (!found && debug) {
                this.dbg("-E- internal error in Signal.splitIS: sender" + this.senders[i6] + " not reconnected!");
            }
            ++i6;
        }
        int i7 = 0;
        while (i7 < splitters.length) {
            splitters[i7].rebuildSolderDots();
            ++i7;
        }
        return splitters;
    }

    private boolean findSplitterForPort(Signal[] splitters, Hashtable[] s_vertices, Port p) {
        try {
            if (debug) {
                this.dbg("checking port " + p.getParent().getName() + " " + p.getName());
            }
            Point portPos = p.getParent().getSymbol().getPortPosition(p.getName());
            int j = 0;
            while (j < splitters.length) {
                if (s_vertices[j].containsKey(portPos)) {
                    if (debug) {
                        this.dbg("splitIS: port " + p + " belongs to splitter " + j);
                    }
                    p.setSignal(null);
                    splitters[j].connect(p);
                    return true;
                }
                ++j;
            }
        }
        catch (Exception e) {
            this.message("-E- Exception in findSplitterForPort: " + p);
            e.printStackTrace();
        }
        return false;
    }

    public void dbg(String s) {
        ExceptionTracer.message(s);
    }

    public void rebuildSolderDots() {
        if (this.vertexTable == null) {
            this.createVertexTable();
        }
        this.createPortPositionTable();
        int n_solders = 0;
        Enumeration E = this.vertexTable.keys();
        while (E.hasMoreElements()) {
            Point p = (Point)E.nextElement();
            int n = (Integer)this.vertexTable.get(p);
            if (n > 2) {
                ++n_solders;
                continue;
            }
            if (n != 2 || !this.isPortPosition(p)) continue;
            ++n_solders;
        }
        this.solderDots = new SolderDot[n_solders];
        int index = 0;
        Enumeration E2 = this.vertexTable.keys();
        while (E2.hasMoreElements()) {
            SolderDot dot;
            Point p = (Point)E2.nextElement();
            int n = (Integer)this.vertexTable.get(p);
            if (n <= 2 && (n != 2 || !this.isPortPosition(p))) continue;
            this.solderDots[index] = dot = new SolderDot(this, p);
            ++index;
        }
    }

    public void merge(Signal victim) {
        if (victim == null) {
            return;
        }
        if (victim == this) {
            this.message("-E- No use to merge a Signal with itself!");
            return;
        }
        if (debug) {
            this.dbg("-I- merging: " + this.toStringVerbose() + "\nwith   : " + victim.toStringVerbose());
        }
        Port[] vreceivers = victim.getReceivers();
        Port[] vsenders = victim.getSenders();
        int i = 0;
        while (i < vreceivers.length) {
            vreceivers[i].setSignal(null);
            this.connect(vreceivers[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < vsenders.length) {
            vsenders[i2].setSignal(null);
            this.connect(vsenders[i2]);
            ++i2;
        }
        WireSegment[] vsegments = (WireSegment[])victim.getSegments();
        int i3 = 0;
        while (i3 < vsegments.length) {
            this.addSegment(vsegments[i3]);
            ++i3;
        }
        victim = null;
        this.createVertexTable();
        this.rebuildSolderDots();
    }

    public void showInternalWireSegments(boolean visible) {
        this.createPortPositionTable();
        int i = 0;
        while (i < this.segments.length) {
            Point[] pp = this.segments[i].getPoints();
            if (!this.isPortPosition(pp[0]) && !this.isPortPosition(pp[1])) {
                this.segments[i].setVisible(visible);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.solderDots.length) {
            this.solderDots[i2].setVisible(visible);
            ++i2;
        }
    }
}

