/*
 * Decompiled with CFR 0.152.
 */
package hades.models.switched;

import hades.gui.PropertySheet;
import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.gates.GenericGate;
import hades.signals.Signal;
import hades.signals.SignalStdLogic1164;
import hades.signals.SignalStdLogicSwitched;
import hades.simulator.GenericSwitch;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.simulator.Wakeable;
import hades.symbols.ClockArm;
import hades.symbols.Symbol;
import java.awt.Point;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jfig.objects.FigObject;

public class Switch
extends GenericGate
implements GenericSwitch,
Wakeable,
Serializable {
    private static final long serialVersionUID = 1689704797675619732L;
    public static final int STATE_OPEN = 0;
    public static final int STATE_CLOSED = 1;
    public static final int STATE_UNDEFINED = 2;
    protected int state;
    protected PortStdLogic1164 port_A = new PortStdLogic1164(this, "A", 2, null);
    protected PortStdLogic1164 port_B = new PortStdLogic1164(this, "B", 2, null);
    protected PortStdLogic1164 port_C = new PortStdLogic1164(this, "C", 0, null);
    protected StdLogic1164 startValue;
    protected double delay = 6.0E-9;
    protected ClockArm the_arm;
    static final int _U = 0;
    static final int _X = 1;
    static final int _0 = 2;
    static final int _1 = 3;
    static final int _Z = 4;
    static final int _W = 5;
    static final int _L = 6;
    static final int _H = 7;
    static final int _D = 8;
    static final int[][] TGATE_TABLE = new int[][]{{4, 4, 4, 4, 4, 4, 4, 4, 4}, {4, 4, 4, 4, 4, 4, 4, 4, 4}, {1, 1, 4, 3, 4, 4, 4, 4, 4}, {1, 1, 2, 4, 4, 4, 4, 4, 4}, {1, 1, 2, 3, 4, 5, 6, 7, 4}, {1, 1, 2, 3, 4, 4, 6, 7, 4}, {1, 1, 2, 3, 4, 5, 4, 7, 4}, {1, 1, 3, 3, 4, 5, 6, 4, 4}, {1, 1, 2, 3, 4, 5, 6, 7, 4}};
    static /* synthetic */ Class class$hades$signals$SignalStdLogicSwitched;

    public Switch() {
        this.ports = new Port[3];
        this.ports[0] = this.port_A;
        this.ports[1] = this.port_B;
        this.ports[2] = this.port_C;
        this.state = 2;
    }

    public Port[] getAllSwitchedPorts() {
        return new Port[]{this.port_A, this.port_B};
    }

    public boolean isSwitchedPort(Port p) {
        return p == this.port_A || p == this.port_B;
    }

    public Port[] getConnectedPorts(Port p) {
        if (this.state == 1) {
            if (p == this.port_A) {
                return new Port[]{this.port_B};
            }
            if (p == this.port_B) {
                return new Port[]{this.port_A};
            }
            return new Port[0];
        }
        if (this.state == 0) {
            return new Port[0];
        }
        return new Port[0];
    }

    public int getState() {
        return this.state;
    }

    public void setState(int i) {
        if (i == 0) {
            this.state = i;
        } else if (i == 1) {
            this.state = i;
        } else if (i == 2) {
            this.state = i;
        } else {
            throw new IllegalArgumentException("hades.models.io.Switch.setState: Unknown state: " + i);
        }
        this.showState();
    }

    public double getDelay() {
        return this.delay;
    }

    public void setDelay(String s) {
        try {
            this.delay = Double.valueOf(s);
        }
        catch (Exception e) {
            this.message("-E- Illegal delay value '" + s + "', using 0.0 sec...");
            this.delay = 0.0;
        }
    }

    public PortStdLogic1164 getPortA() {
        return this.port_A;
    }

    public PortStdLogic1164 getPortB() {
        return this.port_B;
    }

    public boolean initialize(String s) {
        Thread.dumpStack();
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId);
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
        this.initDisplay();
    }

    protected void initDisplay() {
        try {
            FigObject tmp = null;
            if (this.symbol == null) {
                return;
            }
            Enumeration e = this.symbol.elements();
            while (e.hasMoreElements()) {
                tmp = (FigObject)e.nextElement();
                if (!(tmp instanceof ClockArm)) continue;
                this.the_arm = (ClockArm)tmp;
            }
            this.showState();
        }
        catch (Exception e) {
            this.message("-E- Switch.initDisplay(): " + e);
            e.printStackTrace();
        }
    }

    public void showState() {
        if (!this.visible) {
            return;
        }
        try {
            if (this.state == 1) {
                this.the_arm.setRotationAngle(0.0);
            } else {
                this.the_arm.setRotationAngle(0.39269908169872414);
            }
            if (this.symbol.painter != null) {
                this.symbol.painter.paint(this.symbol);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        this.assertIsSignalStdLogicSwitched(this.port_A.getSignal());
        this.assertIsSignalStdLogicSwitched(this.port_B.getSignal());
        this.showState();
    }

    public void evaluate(Object arg) {
        this.assertIsSignalStdLogicSwitched(this.port_A.getSignal());
        this.assertIsSignalStdLogicSwitched(this.port_B.getSignal());
        try {
            StdLogic1164 value_C = this.port_C.getValueOrU();
            this.state = value_C.isHigh_1H() ? 1 : (value_C.isLow_0L() ? 0 : 2);
            this.showState();
            if (this.state == 2) {
                this.scheduleOutputValueAfter(this.port_A, Const1164.__X, this.delay);
                this.scheduleOutputValueAfter(this.port_B, Const1164.__X, this.delay);
            } else if (this.state == 0) {
                this.scheduleOutputValueAfter(this.port_A, Const1164.__Z, this.delay);
                this.scheduleOutputValueAfter(this.port_B, Const1164.__Z, this.delay);
            } else if (this.state == 1) {
                this.scheduleOutputValueAfter(this.port_A, Const1164.__Z, this.delay);
                this.scheduleOutputValueAfter(this.port_B, Const1164.__Z, this.delay);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void evaluateBROKEN(Object arg) {
        block4: {
            try {
                StdLogic1164 value_C = this.port_C.getValueOrU();
                this.state = value_C.isHigh_1H() ? 1 : (value_C.isLow_0L() ? 0 : 2);
                this.showState();
                if (this.state == 2) {
                    this.scheduleOutputValueAfter(this.port_A, Const1164.__X, this.delay);
                    this.scheduleOutputValueAfter(this.port_B, Const1164.__X, this.delay);
                    break block4;
                }
                if (this.state == 0) {
                    this.scheduleOutputValueAfter(this.port_A, Const1164.__Z, this.delay);
                    this.scheduleOutputValueAfter(this.port_B, Const1164.__Z, this.delay);
                    break block4;
                }
                Hashtable segmentsA = new Hashtable();
                Hashtable portsA = new Hashtable();
                Vector driversA = new Vector();
                this.findDriverValues(this.port_A.getSignal(), segmentsA, portsA, driversA);
                StdLogic1164[] driverArrayA = driversA.toArray(new StdLogic1164[0]);
                StdLogic1164 resolvedA = StdLogic1164.resolve(driverArrayA);
                int ia = resolvedA.intValue();
                Hashtable segmentsB = new Hashtable();
                Hashtable portsB = new Hashtable();
                Vector driversB = new Vector();
                this.findDriverValues(this.port_B.getSignal(), segmentsB, portsB, driversB);
                StdLogic1164[] driverArrayB = driversB.toArray(new StdLogic1164[0]);
                StdLogic1164 resolvedB = StdLogic1164.resolve(driverArrayB);
                int ib = resolvedB.intValue();
                StdLogic1164 valueB = new StdLogic1164(TGATE_TABLE[ib][ia]);
                StdLogic1164 valueA = new StdLogic1164(TGATE_TABLE[ia][ib]);
                this.scheduleOutputValueAfter(this.port_A, valueA, this.delay);
                this.scheduleOutputValueAfter(this.port_B, valueB, this.delay);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void assertIsSignalStdLogicSwitched(Signal victim) {
        if (victim == null) {
            return;
        }
        if (victim.getClass() == (class$hades$signals$SignalStdLogicSwitched == null ? (class$hades$signals$SignalStdLogicSwitched = Switch.class$("hades.signals.SignalStdLogicSwitched")) : class$hades$signals$SignalStdLogicSwitched)) {
            return;
        }
        SignalStdLogicSwitched.assertIsSignalStdLogicSwitched(victim);
    }

    private void findDriverValues(Signal target, Hashtable segments, Hashtable ports, Vector drivers) {
        if (target == null) {
            return;
        }
        if (segments.get(target) != null) {
            return;
        }
        segments.put(target, "visited");
        if (!(target instanceof SignalStdLogic1164)) {
            System.err.println("-E- Switch.findDriverValues: not a SignalStdLogic1164: " + target);
            return;
        }
        SignalStdLogic1164 target1164 = (SignalStdLogic1164)target;
        Port[] senders = target1164.getSenders();
        int i = 0;
        while (i < senders.length) {
            SimObject parent = senders[i].getParent();
            if (parent instanceof Switch) {
                Switch tmp = (Switch)parent;
                if (tmp.getState() == 1) {
                    Signal A = tmp.getPortA().getSignal();
                    Signal B = tmp.getPortB().getSignal();
                    this.findDriverValues(A, segments, ports, drivers);
                    this.findDriverValues(B, segments, ports, drivers);
                }
            } else {
                StdLogic1164 value = target1164.getDriverValueAsStdLogic1164(i);
                drivers.addElement(value);
            }
            ++i;
        }
    }

    public void wakeup(Object arg) {
        try {
            Thread.dumpStack();
            this.state = 2;
            this.showState();
        }
        catch (Exception e) {
            System.err.println("-E- " + this.toString() + ".wakeup: " + e);
        }
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, start value, and delay:");
        this.propertySheet.setVisible(true);
    }

    public String getToolTip(Point position, long millis) {
        String s = this.getBindkey();
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "delay= " + this.delay + " [sec]\n" + "bindkey= " + (s == null ? "None" : s);
    }

    public void dbg(String s) {
        System.out.println(s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

