/*
 * Decompiled with CFR 0.152.
 */
package hades.models.switched;

import hades.gui.PropertySheet;
import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.gates.GenericGate;
import hades.simulator.Port;
import hades.simulator.SimObject;
import hades.simulator.Wakeable;
import hades.symbols.ColoredCircle;
import hades.symbols.Polyline;
import hades.symbols.Symbol;
import hades.utils.StringTokenizer;
import java.awt.Color;
import java.awt.Point;
import java.io.PrintWriter;

public class Bulb
extends GenericGate
implements Wakeable {
    private static final long serialVersionUID = 6390597869938123365L;
    public static final int STATE_UNDEFINED = 0;
    public static final int STATE_ON = 1;
    public static final int STATE_OFF = 2;
    protected int state;
    protected PortStdLogic1164 port_A = new PortStdLogic1164(this, "A", 0, null);
    protected PortStdLogic1164 port_B = new PortStdLogic1164(this, "B", 0, null);
    protected ColoredCircle animatedCircle;

    public Bulb() {
        this.ports = new Port[2];
        this.ports[0] = this.port_A;
        this.ports[1] = this.port_B;
        this.state = 0;
    }

    public boolean initialize(String s) {
        try {
            StringTokenizer st = new StringTokenizer(s);
            this.versionId = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            this.message("-E- Bulb.initialize(): " + e + " " + s);
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId);
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
        this.initDisplay();
    }

    protected void initDisplay() {
        try {
            Object tmp = null;
            if (this.symbol == null) {
                return;
            }
            Polyline p1 = new Polyline();
            p1.initialize("2 300 300 900 900");
            Polyline p2 = new Polyline();
            p2.initialize("2 300 900 900 300");
            this.animatedCircle = new ColoredCircle();
            this.animatedCircle.initialize("600 600 420 420");
            this.animatedCircle.getAttributes().parse("fillstyle=pure layer=20");
            this.symbol.fastAddMember(p1);
            this.symbol.fastAddMember(p2);
            this.symbol.fastAddMember(this.animatedCircle);
            this.symbol.update_bbox();
            this.showState();
        }
        catch (Exception e) {
            this.message("-E- Bulb.initDisplay(): " + e);
            e.printStackTrace();
        }
    }

    public void showState() {
        if (!this.visible) {
            return;
        }
        try {
            Color c = Color.cyan;
            c = this.state == 1 ? Const1164.__1.getColor() : (this.state == 2 ? Const1164.__0.getColor() : Const1164.__U.getColor());
            this.animatedCircle.setFillColor(c);
            if (this.symbol.painter != null) {
                this.symbol.painter.paint(this.symbol);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        this.showState();
    }

    public void evaluate(Object arg) {
        try {
            StdLogic1164 value_A = this.port_A.getValueOrU();
            StdLogic1164 value_B = this.port_B.getValueOrU();
            this.state = value_A.is_1() && value_B.is_0() ? 1 : (value_A.is_0() && value_B.is_1() ? 1 : 2);
            this.showState();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void wakeup(Object arg) {
        try {
            Thread.dumpStack();
            this.state = 0;
            this.showState();
        }
        catch (Exception e) {
            System.err.println("-E- " + this.toString() + ".wakeup: " + e);
        }
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, and delay:");
        this.propertySheet.setVisible(true);
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName() + "\n";
    }
}

