/*
 * Decompiled with CFR 0.152.
 */
package hades.models.switched;

import hades.models.switched.TGATE;
import hades.simulator.GenericSwitch;
import hades.simulator.Wakeable;
import hades.symbols.ColoredRectangle;
import hades.symbols.Symbol;
import java.awt.Color;
import java.io.Serializable;
import java.util.Enumeration;
import jfig.gui.ColorCache;
import jfig.objects.FigObject;

public class AnimatedTgate
extends TGATE
implements GenericSwitch,
Wakeable,
Serializable {
    private static final long serialVersionUID = -2498905372701092586L;
    protected ColoredRectangle animatedGate;

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
        this.initDisplay();
    }

    protected void initDisplay() {
        try {
            FigObject tmp = null;
            if (this.symbol == null) {
                return;
            }
            Enumeration e = this.symbol.elements();
            while (e.hasMoreElements()) {
                tmp = (FigObject)e.nextElement();
                if (!(tmp instanceof ColoredRectangle)) continue;
                this.animatedGate = (ColoredRectangle)tmp;
            }
            this.showState();
        }
        catch (Exception e) {
            this.message("-E- AnimatedTgate.initDisplay(): " + e);
            e.printStackTrace();
        }
    }

    public void showState() {
        if (!this.visible) {
            return;
        }
        try {
            Color c = Color.cyan;
            Color d = ColorCache.getColorCache().get(12);
            c = this.state == 1 ? d : (this.state == 0 ? Color.white : Color.cyan);
            this.animatedGate.setLineColor(d);
            this.animatedGate.setFillColor(c);
            if (this.symbol.painter != null) {
                this.symbol.painter.paint(this.symbol);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

