/*
 * Decompiled with CFR 0.152.
 */
package hades.models.stimuli;

import hades.manager.DesignManager;
import hades.models.Const1164;
import hades.models.Design;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.stimuli.ParseException;
import hades.models.stimuli.SimpleCharStream;
import hades.models.stimuli.StimuliParserConstants;
import hades.models.stimuli.StimuliParserTokenManager;
import hades.models.stimuli.Token;
import hades.signals.Signal;
import hades.signals.SignalStdLogic1164;
import hades.signals.SignalStdLogicVector;
import hades.simulator.Assignable;
import hades.simulator.SimEvent;
import hades.simulator.SimEvent1164;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.simulator.Wakeable;
import hades.styx.WaveformViewer;
import hades.utils.DesignHierarchyNavigator;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Vector;

public class StimuliParser
implements StimuliParserConstants {
    SimKernel simulator;
    Design design;
    DesignHierarchyNavigator navigator;
    double processTime;
    String processName;
    int processID;
    boolean debug;
    public StimuliParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[0];
    private final int[] jj_la1_0 = new int[0];
    private final JJCalls[] jj_2_rtns = new JJCalls[20];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public void setSimulator(SimKernel _simulator) {
        this.simulator = _simulator;
        this.debug = false;
    }

    public void setDesign(Design _design) {
        this.design = _design;
        this.navigator = new DesignHierarchyNavigator(this.design);
    }

    public void setDebug(boolean b) {
        this.debug = b;
    }

    public static void main(String[] argv) throws ParseException, Exception {
        if (argv.length != 2) {
            System.err.println("Usage: java hades...StimuliParser <designname> <stimulifilename>");
            System.exit(1);
        }
        String designname = argv[0];
        String filename = argv[1];
        Design design = DesignManager.getDesignManager().getDesign(null, designname, true);
        FileInputStream FIS = new FileInputStream(filename);
        StimuliParser parser = new StimuliParser(FIS);
        parser.setDebug(true);
        parser.setDesign(design);
        parser.stimuli_file();
        FIS.close();
        System.exit(0);
    }

    public void handleAssignStatement(String targetName, String valueString) {
        if (this.debug) {
            StimuliParser.msg("-I- handleAssignStatement: " + targetName + "," + valueString);
        }
        if (this.simulator == null) {
            return;
        }
        try {
            SimObject target = this.navigator.findSimObject(targetName);
            if (target != null) {
                if (target instanceof Assignable) {
                    Assignable tmp = (Assignable)((Object)target);
                    tmp.assign(valueString, this.processTime);
                    return;
                }
                if (this.navigator.findSignal(targetName) == null) {
                    StimuliParser.msg("-E- StimuliParser: " + targetName + " is not Assignable");
                    return;
                }
            }
            Signal signal = this.navigator.findSignal(targetName);
            Object port = null;
            Object value = null;
            if (signal instanceof SignalStdLogic1164) {
                value = new StdLogic1164(valueString.charAt(0));
            } else if (signal instanceof SignalStdLogicVector) {
                int n_bits = ((SignalStdLogicVector)signal).getWidth();
                StdLogicVector tmp = new StdLogicVector(n_bits);
                tmp.parse(valueString);
                value = tmp;
            } else {
                value = valueString;
            }
            if (this.debug) {
                StimuliParser.msg("-#- assign: " + this.simulator + " " + this.processTime + " " + signal + " " + value);
            }
            this.simulator.scheduleEvent(new SimEvent(signal, this.processTime, value, port));
        }
        catch (Throwable e) {
            StimuliParser.msg("-E- StimuliParser.handleAssignStatement: " + e);
            StimuliParser.msg("    target='" + targetName + "' value='" + valueString + "'");
            e.printStackTrace();
        }
    }

    public void handleExecStatement(String command) {
        if (this.debug) {
            StimuliParser.msg("-I- handleExecStatement: '" + command + "'");
        }
        if (this.simulator == null) {
            return;
        }
        ExecHandler handler = new ExecHandler();
        handler.setCommand(command);
        this.simulator.scheduleEvent(new SimEvent(handler, this.processTime, null, null));
    }

    public void handlePauseStatement() {
        if (this.debug) {
            StimuliParser.msg("-I- StimuliParser.handlePauseStatement: " + this.processTime);
        }
        this.simulator.scheduleEvent(new SimEvent(new Pause(), this.processTime, null, null));
    }

    private void createSignalProbe(String name) {
        Signal signal = this.navigator.findSignal(name);
        if (signal == null) {
            return;
        }
        try {
            this.design.getEditor().addProbeToSignal(signal);
        }
        catch (Throwable e) {
            StimuliParser.msg("-E- " + this.toString() + " " + e);
            StimuliParser.msg("    internal error in createSignalProbe: '" + name + "'");
        }
    }

    public void createClockGenerator(String name, double period, double dutycycle, double offset) {
        if (this.simulator == null) {
            return;
        }
        if (this.debug) {
            StimuliParser.msg("-I- define_clock: " + name + "," + period);
        }
        ClockGen clock = new ClockGen(period, dutycycle, offset);
        clock.setSignal(this.navigator.findSignal(name));
        clock.elaborate(null);
    }

    public static double getTimeScale(String s) {
        double tmp = 1.0;
        if ("fs".equals(s)) {
            return 1.0E-15;
        }
        if ("ps".equals(s)) {
            return 1.0E-12;
        }
        if ("ns".equals(s)) {
            return 1.0E-9;
        }
        if ("us".equals(s)) {
            return 1.0E-6;
        }
        if ("ms".equals(s)) {
            return 0.001;
        }
        if ("sec".equals(s)) {
            return 1.0;
        }
        if ("min".equals(s)) {
            return 60.0;
        }
        if ("hr".equals(s)) {
            return 3600.0;
        }
        System.err.println("-E- internal in getTimeScale: " + s);
        return 1.0;
    }

    public static double parseDouble(String s) {
        return Double.valueOf(s.trim());
    }

    public static void msg(String s) {
        System.out.println(s);
    }

    public final void stimuli_file() throws ParseException {
        while (this.jj_2_1(2)) {
            this.statement();
        }
        this.jj_consume_token(0);
    }

    public final void statement() throws ParseException {
        if (this.jj_2_2(2)) {
            this.jj_consume_token(8);
        } else if (this.jj_2_3(2)) {
            this.process();
        } else if (this.jj_2_4(2)) {
            this.define_clock();
        } else if (this.jj_2_5(2)) {
            this.trace_signal();
        } else if (this.jj_2_6(2)) {
            this.enable_debug();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void process() throws ParseException {
        this.jj_consume_token(12);
        this.processTime = 0.0;
        this.processName = "process" + this.processID;
        if (this.jj_2_7(2)) {
            this.jj_consume_token(26);
            this.processName = this.token.image;
        }
        this.jj_consume_token(8);
        if (this.debug) {
            StimuliParser.msg("-I- process, name='" + this.processName);
        }
        while (this.jj_2_8(2)) {
            this.assign_or_wait();
        }
        this.jj_consume_token(13);
        ++this.processID;
        this.jj_consume_token(8);
    }

    public final void assign_or_wait() throws ParseException {
        if (this.jj_2_9(2)) {
            this.jj_consume_token(8);
        } else if (this.jj_2_10(2)) {
            this.assignment();
        } else if (this.jj_2_11(2)) {
            this.do_wait();
        } else if (this.jj_2_12(2)) {
            this.do_pause();
        } else if (this.jj_2_13(2)) {
            this.do_exec();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void assignment() throws ParseException {
        String name = this.signal_name();
        this.jj_consume_token(9);
        String value = this.constant_or_ID();
        this.jj_consume_token(8);
        this.handleAssignStatement(name, value);
    }

    public final void do_wait() throws ParseException {
        if (this.jj_2_14(2)) {
            this.jj_consume_token(10);
            this.jj_consume_token(21);
            double delay = StimuliParser.parseDouble(this.token.image);
            this.jj_consume_token(20);
            double scale = StimuliParser.getTimeScale(this.token.image);
            this.jj_consume_token(8);
            this.processTime += delay * scale;
            if (this.debug) {
                StimuliParser.msg("-I- wait: " + delay * scale);
            }
        } else if (this.jj_2_15(2)) {
            this.jj_consume_token(10);
            this.jj_consume_token(11);
            this.jj_consume_token(21);
            double delay = StimuliParser.parseDouble(this.token.image);
            this.jj_consume_token(20);
            double scale = StimuliParser.getTimeScale(this.token.image);
            this.jj_consume_token(8);
            this.processTime = delay * scale;
            if (this.debug) {
                StimuliParser.msg("-I- wait until: " + delay * scale);
            }
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void do_pause() throws ParseException {
        this.jj_consume_token(16);
        this.handlePauseStatement();
        this.jj_consume_token(8);
    }

    public final void do_exec() throws ParseException {
        this.jj_consume_token(17);
        String value = this.constant_or_ID();
        this.jj_consume_token(8);
        this.handleExecStatement(value);
    }

    public final void define_clock() throws ParseException {
        this.jj_consume_token(14);
        this.jj_consume_token(26);
        String name = this.token.image;
        this.jj_consume_token(21);
        double period = StimuliParser.parseDouble(this.token.image);
        this.jj_consume_token(21);
        double dutycycle = StimuliParser.parseDouble(this.token.image);
        this.jj_consume_token(21);
        double offset = StimuliParser.parseDouble(this.token.image);
        this.jj_consume_token(8);
        this.createClockGenerator(name, period, dutycycle, offset);
    }

    public final void trace_signal() throws ParseException {
        this.jj_consume_token(15);
        this.jj_consume_token(26);
        String name = this.token.image;
        this.createSignalProbe(name);
        this.jj_consume_token(8);
    }

    public final String constant_or_ID() throws ParseException {
        if (this.jj_2_16(2)) {
            this.jj_consume_token(21);
            return this.token.image;
        }
        if (this.jj_2_17(2)) {
            this.jj_consume_token(26);
            return this.token.image;
        }
        if (this.jj_2_18(2)) {
            this.jj_consume_token(29);
            return this.token.image;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String signal_name() throws ParseException {
        if (this.jj_2_19(2)) {
            this.jj_consume_token(28);
            return this.token.image;
        }
        if (this.jj_2_20(2)) {
            this.jj_consume_token(26);
            return this.token.image;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void enable_debug() throws ParseException {
        this.jj_consume_token(18);
        this.jj_consume_token(26);
        String name = this.token.image;
        this.setDebug("true".equals(name));
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_1();
        this.jj_save(0, xla);
        return retval;
    }

    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_2();
        this.jj_save(1, xla);
        return retval;
    }

    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_3();
        this.jj_save(2, xla);
        return retval;
    }

    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_4();
        this.jj_save(3, xla);
        return retval;
    }

    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_5();
        this.jj_save(4, xla);
        return retval;
    }

    private final boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_6();
        this.jj_save(5, xla);
        return retval;
    }

    private final boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_7();
        this.jj_save(6, xla);
        return retval;
    }

    private final boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_8();
        this.jj_save(7, xla);
        return retval;
    }

    private final boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_9();
        this.jj_save(8, xla);
        return retval;
    }

    private final boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_10();
        this.jj_save(9, xla);
        return retval;
    }

    private final boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_11();
        this.jj_save(10, xla);
        return retval;
    }

    private final boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_12();
        this.jj_save(11, xla);
        return retval;
    }

    private final boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_13();
        this.jj_save(12, xla);
        return retval;
    }

    private final boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_14();
        this.jj_save(13, xla);
        return retval;
    }

    private final boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_15();
        this.jj_save(14, xla);
        return retval;
    }

    private final boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_16();
        this.jj_save(15, xla);
        return retval;
    }

    private final boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_17();
        this.jj_save(16, xla);
        return retval;
    }

    private final boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_18();
        this.jj_save(17, xla);
        return retval;
    }

    private final boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_19();
        this.jj_save(18, xla);
        return retval;
    }

    private final boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_20();
        this.jj_save(19, xla);
        return retval;
    }

    private final boolean jj_3_11() {
        if (this.jj_3R_10()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_10() {
        if (this.jj_3R_9()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_8() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_9()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_10()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_11()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_12()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_13()) {
                            return true;
                        }
                        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_9() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_15() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(11)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_6() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_8() {
        if (this.jj_3R_8()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_10() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_14()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_15()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_14() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(21)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_7() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_4() {
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_7()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_5() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_6() {
        if (this.jj_3R_7()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_7() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_5() {
        if (this.jj_3R_6()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_4() {
        if (this.jj_3R_5()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_3() {
        if (this.jj_3R_4()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_3() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_2()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_3()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_4()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_5()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_6()) {
                            return true;
                        }
                        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_2() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_12() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_20() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_13() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_19()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_20()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_19() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_1() {
        if (this.jj_3R_3()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_9() {
        if (this.jj_3R_13()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_11() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_18() {
        if (this.jj_scan_token(29)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_17() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_14() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_16()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_17()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_18()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_13() {
        if (this.jj_3R_12()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_16() {
        if (this.jj_scan_token(21)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_12() {
        if (this.jj_3R_11()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    public StimuliParser(InputStream stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new StimuliParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 0) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 0) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public StimuliParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new StimuliParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 0) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 0) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public StimuliParser(StimuliParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 0) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public void ReInit(StimuliParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 0) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                int i = 0;
                while (i < this.jj_2_rtns.length) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                    ++i;
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        return this.jj_scanpos.kind != kind;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            int i = 0;
            while (i < this.jj_endpos) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
                ++i;
            }
            boolean exists = false;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] oldentry = (int[])enumeration.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                int i2 = 0;
                while (i2 < this.jj_expentry.length) {
                    if (oldentry[i2] != this.jj_expentry[i2]) {
                        exists = false;
                        break;
                    }
                    ++i2;
                }
                if (exists) break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public final ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[31];
        int i = 0;
        while (i < 31) {
            la1tokens[i] = false;
            ++i;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int i2 = 0;
        while (i2 < 0) {
            if (this.jj_la1[i2] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((this.jj_la1_0[i2] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < 31) {
            if (la1tokens[i3]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i3;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i3;
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i4 = 0;
        while (i4 < this.jj_expentries.size()) {
            exptokseq[i4] = (int[])this.jj_expentries.elementAt(i4);
            ++i4;
        }
        return new ParseException(this.token, (int[][])exptokseq, StimuliParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        int i = 0;
        while (i < 20) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                        break;
                    }
                    case 2: {
                        this.jj_3_3();
                        break;
                    }
                    case 3: {
                        this.jj_3_4();
                        break;
                    }
                    case 4: {
                        this.jj_3_5();
                        break;
                    }
                    case 5: {
                        this.jj_3_6();
                        break;
                    }
                    case 6: {
                        this.jj_3_7();
                        break;
                    }
                    case 7: {
                        this.jj_3_8();
                        break;
                    }
                    case 8: {
                        this.jj_3_9();
                        break;
                    }
                    case 9: {
                        this.jj_3_10();
                        break;
                    }
                    case 10: {
                        this.jj_3_11();
                        break;
                    }
                    case 11: {
                        this.jj_3_12();
                        break;
                    }
                    case 12: {
                        this.jj_3_13();
                        break;
                    }
                    case 13: {
                        this.jj_3_14();
                        break;
                    }
                    case 14: {
                        this.jj_3_15();
                        break;
                    }
                    case 15: {
                        this.jj_3_16();
                        break;
                    }
                    case 16: {
                        this.jj_3_17();
                        break;
                    }
                    case 17: {
                        this.jj_3_18();
                        break;
                    }
                    case 18: {
                        this.jj_3_19();
                        break;
                    }
                    case 19: {
                        this.jj_3_20();
                    }
                }
            } while ((p = p.next) != null);
            ++i;
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    class ClockGen
    implements Wakeable {
        private double period = 1.0;
        private double dutycycle = 0.5;
        private double offset = 0.0;
        private Signal signal = null;

        public ClockGen(double _period, double _dutycycle, double _offset) {
            this.period = _period;
            this.dutycycle = _dutycycle;
            this.offset = _offset;
        }

        public void setSignal(Signal _signal) {
            this.signal = _signal;
        }

        public void elaborate(Object arg) {
            double time = StimuliParser.this.simulator.getSimTime();
            StimuliParser.this.simulator.scheduleWakeup(this, time + this.offset, this);
            if (this.offset > 0.0) {
                this.schedule(Const1164.__U, time);
            }
            this.schedule(Const1164.__1, time + this.offset);
        }

        public void evaluate(Object arg) {
            System.err.println("-E- StimuliParser$ClockGen: don't call evaluate!");
        }

        public void wakeup(Object arg) {
            double time = StimuliParser.this.simulator.getSimTime();
            if (StimuliParser.this.debug) {
                StimuliParser.msg("-#- StimuliParser$ClockGen: wakeup at " + time);
            }
            this.schedule(Const1164.__0, time + this.dutycycle * this.period);
            this.schedule(Const1164.__1, time + this.period);
            StimuliParser.this.simulator.scheduleWakeup(this, time + this.period, this);
        }

        public void schedule(StdLogic1164 value, double time) {
            Object port = null;
            StimuliParser.this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)this.signal, time, value, port));
        }

        public void message(String msg) {
            System.err.println(msg);
        }
    }

    class Pause
    implements Simulatable {
        Pause() {
        }

        public void message(String s) {
            System.out.println(s);
        }

        public void elaborate(Object arg) {
        }

        public void evaluate(Object arg) {
            if (StimuliParser.this.simulator == null) {
                return;
            }
            StimuliParser.msg("-#- StimuliParser.Pause.eval: " + StimuliParser.this.simulator.getSimTime());
            StimuliParser.this.simulator.pauseSimulation();
        }
    }

    class ExecHandler
    implements Simulatable {
        private String command;

        ExecHandler() {
        }

        public void setCommand(String cmd) {
            this.command = cmd;
        }

        public void message(String s) {
            System.out.println(s);
        }

        public void elaborate(Object arg) {
        }

        public void evaluate(Object arg) {
            if (StimuliParser.this.simulator == null) {
                return;
            }
            StimuliParser.msg("-#- StimuliParser.ExecHandler.eval: " + StimuliParser.this.simulator.getSimTime());
            try {
                System.out.println("-I- exec: '" + this.command + "'");
                WaveformViewer o = StimuliParser.this.design.getEditor().getWaveformViewer();
                if (o != null) {
                    o.doUpdateWavesAndRedraw();
                }
            }
            catch (Throwable e) {
                StimuliParser.msg("-E- StimuliParser.handleExecStatement: " + e);
                StimuliParser.msg("    command='" + this.command + "'");
                e.printStackTrace();
            }
        }
    }
}

