/*
 * Decompiled with CFR 0.152.
 */
package hades.models.special;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import jfig.gui.ImageHelper;
import jfig.utils.AntiDeadlock;
import jfig.utils.SetupManager;

public class TextLCDCanvas
extends JComponent {
    private Image characterMatrix;
    private Image[] characterImage;
    private int[] cgRAM;
    private Color lcdBackground;
    private Image bufferImage;
    private Graphics bufferGraphics;
    private int n_rows;
    private int n_cols;
    private static final int MEM_SIZE = 80;
    private static final int NO_SUCH_DATA = 32;
    private int[] data;
    private int char_width = 12;
    private int char_height = 20;
    private int left_border = 5;
    private int top_border = 5;
    private int char_spacer = 2;
    private int base_address = 0;
    private int cursor_address = 0;
    private boolean display_enable = false;
    private boolean cursor_enable = false;
    private boolean cursor_blink = false;
    private boolean cursor_is_small = false;
    private boolean two_line_enable = true;
    private boolean auto_repaint_enable = false;
    private int t_repaint = 20;

    public TextLCDCanvas(int n_rows, int n_cols) {
        this.n_rows = Math.min(n_rows, 2);
        this.n_cols = Math.min(n_cols, 40);
        this.initializeData();
        this.loadDefaultColors();
        this.loadCharacterMatrix("/hades/gui/images/lcd-matrix.gif");
        this.createBufferImage();
        this.updateBufferImage(this.bufferGraphics);
        this.createBlinkTimer();
        this.setBackground(Color.green);
    }

    public int countRows() {
        return this.n_rows;
    }

    public int countColums() {
        return this.n_cols;
    }

    public void setSize(int rows, int columns) {
        if (rows >= 0 || rows <= 40) {
            this.n_rows = rows;
        } else {
            TextLCDCanvas.msg("-E- LCDCanvas: illegal row count: " + rows + " using default 2");
            this.n_rows = 2;
        }
        if (columns >= 0 || columns <= 40) {
            this.n_cols = columns;
        } else {
            TextLCDCanvas.msg("-E- LCDCanvas: illegal column count: " + columns + " using default 40 ");
            this.n_cols = 40;
        }
    }

    public void initializeData() {
        this.data = new int[80];
        int r = 0;
        while (r < this.n_rows) {
            int c = 0;
            while (c < this.n_cols) {
                this.data[r * this.n_cols + c] = 32;
                ++c;
            }
            ++r;
        }
    }

    public void initializeHamburgData() {
        this.data = new int[80];
        String[] hugo = new String[]{"Hello, world! This is HADES 0.67i                    ", "(c) 1999 University of Hamburg, FBI TECH             "};
        int r = 0;
        while (r < this.n_rows) {
            int c = 0;
            while (c < this.n_cols) {
                this.data[r * this.n_cols + c] = hugo[r].charAt(c);
                ++c;
            }
            ++r;
        }
    }

    public void clearDisplay() {
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = 32;
            ++i;
        }
        this.updateBufferImage(this.bufferGraphics);
        if (this.auto_repaint_enable && this.isShowing()) {
            this.repaint(this.t_repaint);
        }
    }

    public void enableDisplay(boolean b) {
        this.display_enable = b;
        this.updateBufferImage(this.bufferGraphics);
        if (this.auto_repaint_enable && this.isShowing()) {
            this.repaint(this.t_repaint);
        }
    }

    public void selectTwoLines(boolean b) {
        this.two_line_enable = b & this.n_rows > 1;
        this.updateBufferImage(this.bufferGraphics);
        if (this.auto_repaint_enable && this.isShowing()) {
            this.repaint(this.t_repaint);
        }
    }

    public void enableCursor(boolean b) {
        this.cursor_enable = b;
    }

    public void selectUnderlineCursor(boolean b) {
        this.cursor_is_small = b;
    }

    public void enableCursorBlinking(boolean b) {
        this.cursor_blink = b;
        if (this.cursor_blink) {
            throw new UnsupportedOperationException("TextLCDCanvas: enableCursorBlinking(true) not implemented");
        }
    }

    public void setCursorAddress(int address) {
        this.cursor_address = address;
    }

    public int getCursorAddress() {
        return this.cursor_address;
    }

    public void cursorHome() {
        this.setCursorAddress(0);
        this.setBaseAddress(0);
        if (this.auto_repaint_enable && this.isShowing()) {
            this.repaint(this.t_repaint);
        }
    }

    public void moveCursorLeft() {
        --this.cursor_address;
        if (this.cursor_address < 0) {
            this.cursor_address = this.data.length;
        }
    }

    public void moveCursorRight() {
        ++this.cursor_address;
        if (this.cursor_address >= this.data.length) {
            this.cursor_address = 0;
        }
    }

    public void setBaseAddress(int address) {
        this.base_address = address;
    }

    public void rotateLeft() {
        ++this.base_address;
        this.updateBufferImage(this.bufferGraphics);
        if (this.auto_repaint_enable && this.isShowing()) {
            this.repaint(this.t_repaint);
        }
    }

    public void rotateRight() {
        --this.base_address;
        this.updateBufferImage(this.bufferGraphics);
        if (this.auto_repaint_enable && this.isShowing()) {
            this.repaint(this.t_repaint);
        }
    }

    public void createBlinkTimer() {
        BlinkTimer blinkTimer = new BlinkTimer();
        blinkTimer.start();
    }

    public void loadDefaultColors() {
        this.lcdBackground = SetupManager.getColor("Hades.TextLCDCanvas.lcdBackground", new Color(191, 223, 0));
        this.setBackground(this.lcdBackground);
    }

    public void loadCharacterMatrix(String resourcename) {
        try {
            this.characterMatrix = ImageHelper.loadResourceImage(resourcename);
            this.characterImage = new Image[256];
            Graphics cg = null;
            int row = 0;
            while (row < 16) {
                int col = 0;
                while (col < 16) {
                    this.characterImage[col * 16 + row] = ImageHelper.createImage(this.char_width, this.char_height);
                    cg = this.characterImage[col * 16 + row].getGraphics();
                    cg.setColor(Color.blue);
                    cg.fillRect(0, 0, this.char_width, this.char_height);
                    cg.drawImage(this.characterMatrix, 0, 0, this.char_width, this.char_height, 2 + col * 16, 2 + row * 22, 2 + col * 16 + this.char_width, 2 + row * 22 + this.char_height, null);
                    cg.dispose();
                    ++col;
                }
                ++row;
            }
        }
        catch (Throwable t) {
            System.err.println("-E- internal error in loadCharacterMatrix: " + t);
            t.printStackTrace();
        }
    }

    public void createBufferImage() {
        int width = 2 * this.left_border + this.n_cols * this.char_width;
        int height = 2 * this.top_border + this.n_rows * this.char_height + (this.n_rows - 1) * this.char_spacer;
        this.bufferImage = ImageHelper.createImage(width, height);
        this.bufferGraphics = this.bufferImage.getGraphics();
        this.bufferGraphics.setColor(this.lcdBackground);
        this.bufferGraphics.fillRect(0, 0, width, height);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDataAt(int address, int value) {
        block7: {
            int a;
            block8: {
                a = address & 0x7F;
                if (!this.two_line_enable) break block8;
                if (a >= 0 && a <= 39) {
                    this._set(a, value);
                    break block7;
                } else if (a >= 64 && a <= 103) {
                    this._set(a - 24, value);
                    break block7;
                } else {
                    TextLCDCanvas.msg("-W- TextLCDCanvas.setDataAt: invalid address " + a + " ignored");
                    return;
                }
            }
            if (a >= 0 && a <= 79) {
                this._set(a, value);
            } else {
                TextLCDCanvas.msg("-W- TextLCDCanvas.setDataAt: invalid address " + a + " ignored");
                return;
            }
        }
        this.repaintAt(address);
        if (this.auto_repaint_enable && this.isShowing()) {
            this.repaint(this.t_repaint);
        }
    }

    private void _set(int addr, int value) {
        this.data[addr] = value;
    }

    public int getDataAt(int addr) {
        if (this.two_line_enable) {
            if (addr >= 0 && addr <= 39) {
                return this.data[addr];
            }
            if (addr >= 64 && addr <= 103) {
                return this.data[addr - 24];
            }
            return 32;
        }
        if (addr >= 0 && addr <= 79) {
            return this.data[addr];
        }
        return 32;
    }

    public int getDataAt(int row, int column) {
        int addr = row * this.n_cols + column;
        if (addr < 0) {
            addr = 0;
        }
        if (addr > this.data.length) {
            addr = 0;
        }
        return this.data[addr];
    }

    public int getRow(int address) {
        int row = 0;
        if (this.two_line_enable && address >= 64) {
            row = 1;
        }
        return row;
    }

    public int getColumn(int address) {
        int col = 0;
        if (this.two_line_enable) {
            if (address >= 64) {
                address -= 64;
            }
            col = address - this.base_address;
        } else {
            col = address - this.base_address;
        }
        return col;
    }

    public int getPixelX(int address) {
        int c = this.getColumn(address);
        return this.left_border + c * this.char_width;
    }

    public int getPixelY(int address) {
        int r = this.getRow(address);
        return this.top_border + r * (this.char_height + this.char_spacer);
    }

    public boolean isVisibleAddress(int address) {
        int col = this.getColumn(address);
        return col >= 0 && col < this.n_cols;
    }

    public void update(Graphics g) {
        if (this.display_enable) {
            if (this.bufferGraphics != null) {
                g.drawImage(this.bufferImage, 0, 0, this);
            } else {
                TextLCDCanvas.msg("-E- " + this.toString() + " internal: bufferImage is null!");
                this.createBufferImage();
            }
        } else {
            g.clearRect(0, 0, this.getSize().width, this.getSize().height);
        }
    }

    public boolean isOpaque() {
        return true;
    }

    public boolean isDoubleBuffered() {
        return true;
    }

    public void paintComponent(Graphics g) {
        if (this.display_enable) {
            if (this.bufferGraphics != null) {
                this.updateBufferImage(this.bufferGraphics);
                g.drawImage(this.bufferImage, 0, 0, this);
            } else {
                TextLCDCanvas.msg("-E- " + this.toString() + " internal: bufferImage is null!");
                this.createBufferImage();
                this.repaint(200L);
            }
        } else {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        }
    }

    public void updateBufferImage(Graphics g) {
        if (g == null) {
            return;
        }
        g.setColor(this.lcdBackground);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        if (!this.display_enable) {
            return;
        }
        int address = 0;
        if (this.two_line_enable) {
            int c = 0;
            while (c < this.n_cols) {
                address = this.base_address + c;
                g.drawImage(this.characterImage[this.getDataAt(address)], this.getPixelX(address), this.getPixelY(address), null);
                ++c;
            }
            int c2 = 0;
            while (c2 < this.n_cols) {
                address = this.base_address + 64 + c2;
                g.drawImage(this.characterImage[this.getDataAt(address)], this.getPixelX(address), this.getPixelY(address), null);
                ++c2;
            }
        } else {
            int c = 0;
            while (c < this.n_cols) {
                address = this.base_address + c;
                g.drawImage(this.characterImage[this.getDataAt(address)], this.getPixelX(address), this.getPixelY(address), null);
                ++c;
            }
        }
    }

    public void repaintAt(int address) {
        if (!this.display_enable) {
            return;
        }
        if (!this.isVisibleAddress(address)) {
            return;
        }
        Graphics g = this.bufferGraphics;
        if (g == null) {
            return;
        }
        int x = this.getPixelX(address);
        int y = this.getPixelY(address);
        g.drawImage(this.characterImage[this.getDataAt(address)], x, y, null);
    }

    public void hideCursor(int address) {
        if (!this.display_enable) {
            return;
        }
        if (!this.isVisibleAddress(address)) {
            return;
        }
        Graphics g = this.bufferGraphics;
        if (g == null) {
            return;
        }
        int x = this.getPixelX(address);
        int y = this.getPixelY(address);
        g.drawImage(this.characterImage[this.getDataAt(address)], x, y, null);
        this.repaint(this.t_repaint);
    }

    public void showCursor(int address) {
        if (!this.display_enable) {
            return;
        }
        if (!this.isVisibleAddress(address)) {
            return;
        }
        Graphics g = this.bufferGraphics;
        if (g == null) {
            return;
        }
        int x = this.getPixelX(address);
        int y = this.getPixelY(address);
        g.drawImage(this.characterImage[this.getDataAt(address)], x, y, null);
        if (this.cursor_enable) {
            if (this.cursor_is_small) {
                g.setColor(Color.black);
                g.drawLine(x + 2, y + 16, x + 2 + 9, y + 16);
                g.drawLine(x + 2, y + 17, x + 2 + 9, y + 17);
            } else {
                g.drawImage(this.characterImage[255], x, y, null);
            }
        }
        this.repaint(this.t_repaint);
    }

    public Dimension getMinimumSize() {
        return new Dimension(2 * this.left_border + this.n_cols * this.char_width, 2 * this.top_border + this.n_rows * this.char_height + (this.n_rows - 1) * this.char_spacer);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public boolean getAutoRepaintEnable() {
        return this.auto_repaint_enable;
    }

    public void setAutoRepaintEnable(boolean b) {
        this.auto_repaint_enable = b;
    }

    public void setAutoRepaintDelay(int millis) {
        this.t_repaint = millis;
    }

    private void createCGRam() {
        this.cgRAM = new int[64];
        int i = 0;
        while (i < this.cgRAM.length) {
            this.cgRAM[i] = 0;
            ++i;
        }
    }

    public void writeCGRam(int address, int value) {
        if (this.cgRAM == null) {
            this.createCGRam();
        }
        this.cgRAM[address & 0x3F] = value & 0xFF;
        int char_address = (address & 0x38) >> 3;
        int row_address = address & 7;
        int pixels = value & 0x1F;
        Image target = this.characterImage[char_address];
        Graphics g = target.getGraphics();
        g.setColor(this.lcdBackground);
        g.fillRect(0, 2 * row_address, this.char_width, 2);
        g.setColor(Color.black);
        int mask = 16;
        int x = 2;
        int y = 2 * row_address;
        if (row_address == 7) {
            y += 2;
        }
        int i = 0;
        while (i < 5) {
            if ((pixels & mask) > 0) {
                g.fillRect(x, y, 2, 2);
            }
            mask >>>= 1;
            x += 2;
            ++i;
        }
    }

    public int readCGRam(int address) {
        if (this.cgRAM == null) {
            this.createCGRam();
        }
        return this.cgRAM[address & 0x3F];
    }

    public static void msg(String msg) {
        System.out.println(msg);
    }

    public static void main(String[] argv) {
        System.out.println("TextLCDCanvas selftest, please wait...");
        SetupManager.loadGlobalProperties("hades/.hadesrc");
        JFrame frame = new JFrame("TextLCDCanvas selftest");
        frame.getContentPane().add("South", new JButton("click me"));
        frame.pack();
        frame.setVisible(true);
        AntiDeadlock.sleep(1000L);
        ImageHelper.setVisibleParent(frame);
        System.out.println("-I- ImageHelper.setVisibleParent ok...");
        TextLCDCanvas lcd = new TextLCDCanvas(2, 40);
        lcd.setAutoRepaintEnable(false);
        lcd.enableDisplay(true);
        System.out.println("-1- now enabled...");
        frame.getContentPane().add("Center", lcd);
        System.out.println("-2- now enabled...");
        frame.pack();
        System.out.println("-3- now enabled...");
        lcd.enableDisplay(true);
        int i = 0;
        while (i < 128) {
            int value = (int)(32.0 * Math.random());
            lcd.writeCGRam(i, value);
            ++i;
        }
        int i2 = 0;
        while (i2 < 8) {
            lcd.setDataAt(3 * i2, i2);
            ++i2;
        }
        System.out.println("-4- now enabled...");
        lcd.repaint();
        int pos = 0;
        int chr = 13;
        while (true) {
            pos = (pos + 1) % 128;
            chr = (chr + 1) % 255;
            lcd.setDataAt(pos, chr);
            lcd.repaint(20L);
        }
    }

    protected class BlinkTimer
    extends Thread {
        int last_address = 0;
        int new_address = 0;

        public BlinkTimer() {
            this.setDaemon(true);
        }

        public void run() {
            try {
                while (true) {
                    Thread.sleep(500L);
                    this.new_address = TextLCDCanvas.this.getCursorAddress();
                    TextLCDCanvas.this.hideCursor(this.last_address);
                    TextLCDCanvas.this.showCursor(this.new_address);
                    this.last_address = this.new_address;
                    Thread.sleep(500L);
                    TextLCDCanvas.this.hideCursor(this.new_address);
                }
            }
            catch (InterruptedException e) {
                System.out.println("-E- BlinkTimer: " + e);
                return;
            }
        }
    }
}

