/*
 * Decompiled with CFR 0.152.
 */
package hades.models.special;

import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.StdLogic1164;
import hades.models.special.TextLCDCanvas;
import hades.signals.Signal;
import hades.signals.SignalStdLogic1164;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimEvent1164;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.simulator.Wakeable;
import hades.symbols.Label;
import hades.symbols.Symbol;
import hades.utils.StringTokenizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import jfig.utils.ExceptionTracer;

public class TextLCD
extends SimObject
implements Simulatable,
Wakeable {
    boolean debug = false;
    protected PortStdLogic1164 port_RS;
    protected PortStdLogic1164 port_RW;
    protected PortStdLogic1164 port_E = new PortStdLogic1164(this, "E", 0, null);
    protected PortStdLogic1164 port_D7;
    protected PortStdLogic1164 port_D6;
    protected PortStdLogic1164 port_D5;
    protected PortStdLogic1164 port_D4;
    protected PortStdLogic1164 port_D3;
    protected PortStdLogic1164 port_D2;
    protected PortStdLogic1164 port_D1;
    protected PortStdLogic1164 port_D0;
    protected PortStdLogic1164 port_VO;
    protected StdLogic1164 value_0;
    protected StdLogic1164 value_1;
    protected StdLogic1164 value_X;
    protected StdLogic1164 value_H;
    protected Label symbolTypeLabel;
    protected int n_rows = 2;
    protected int n_cols = 40;
    public static final int DATA_MEMORY = 13;
    public static final int CG_MEMORY = 14;
    public static final int BIT_RS = 512;
    public static final int BIT_RW = 256;
    public static final int BIT_D7 = 128;
    public static final int BIT_D6 = 64;
    public static final int BIT_D5 = 32;
    public static final int BIT_D4 = 16;
    public static final int BIT_D3 = 8;
    public static final int BIT_D2 = 4;
    public static final int BIT_D1 = 2;
    public static final int BIT_D0 = 1;
    public static final int CMD_IDLE = 0;
    public static final int CMD_CLEAR = 1;
    public static final int CMD_CURSOR_HOME = 2;
    public static final int CMD_ENTRY_MODE = 4;
    public static final int CMD_DISPLAY_ON = 8;
    public static final int CMD_SHIFT_MOVE = 16;
    public static final int CMD_FUNCTION = 32;
    public static final int CMD_CG_ADDR = 64;
    public static final int CMD_DATA_ADDR = 128;
    public static final int CMD_READ_BUSY = 256;
    public static final int CMD_WRITE_RAM = 512;
    public static final int CMD_READ_RAM = 768;
    public static final double T_INITIALIZE = 0.0015;
    public static final double T_CLEAR = 1.0E-5;
    public static final double T_CURSOR_HOME = 1.0E-5;
    public static final double T_ENTRY_MODE = 1.0E-5;
    public static final double T_DISPLAY_ON = 1.0E-5;
    public static final double T_SHIFT_MOVE = 1.0E-5;
    public static final double T_FUNCTION = 1.0E-5;
    public static final double T_CG_ADDR = 1.0E-5;
    public static final double T_DATA_ADDR = 1.0E-5;
    public static final double T_WRITE_RAM = 1.0E-5;
    public static final double T_READ_RAM = 1.0E-5;
    protected int command_word = 0;
    protected int command_old = 0;
    protected int cg_address = 0;
    protected int data_address = 0;
    protected int active_memory = 13;
    protected boolean busy = false;
    protected boolean incr_not_decr = true;
    protected boolean decrement_mode = false;
    protected boolean shift_not_move = false;
    protected boolean four_bit_mode = false;
    protected boolean four_bit_first = true;
    TextLCDCanvas lcdCanvas;
    JFrame topFrame;
    JPanel controlPanel;
    JCheckBox debugCheckbox;
    Image theIcon;

    public TextLCD() {
        this.port_RS = new PortStdLogic1164(this, "RS", 0, null);
        this.port_RW = new PortStdLogic1164(this, "RW", 0, null);
        this.port_D7 = new PortStdLogic1164(this, "D7", 2, null);
        this.port_D6 = new PortStdLogic1164(this, "D6", 2, null);
        this.port_D5 = new PortStdLogic1164(this, "D5", 2, null);
        this.port_D4 = new PortStdLogic1164(this, "D4", 2, null);
        this.port_D3 = new PortStdLogic1164(this, "D3", 2, null);
        this.port_D2 = new PortStdLogic1164(this, "D2", 2, null);
        this.port_D1 = new PortStdLogic1164(this, "D1", 2, null);
        this.port_D0 = new PortStdLogic1164(this, "D0", 2, null);
        this.ports = new Port[11];
        this.ports[0] = this.port_E;
        this.ports[1] = this.port_RS;
        this.ports[2] = this.port_RW;
        this.ports[3] = this.port_D7;
        this.ports[4] = this.port_D6;
        this.ports[5] = this.port_D5;
        this.ports[6] = this.port_D4;
        this.ports[7] = this.port_D3;
        this.ports[8] = this.port_D2;
        this.ports[9] = this.port_D1;
        this.ports[10] = this.port_D0;
        this.value_X = Const1164.__X;
        this.value_0 = Const1164.__0;
        this.value_1 = Const1164.__1;
        this.value_H = Const1164.__H;
        this.configure();
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.name);
    }

    public void setName(String name) {
        super.setName(name);
        this.topFrame.setTitle("TextLCD " + this.getName());
    }

    public void setLocalDebug(boolean b) {
        this.debug = b;
    }

    public boolean getLocalDebug() {
        return this.debug;
    }

    public void doInitialize() {
        if (this.debug) {
            this.msg("doInitialize...");
        }
        this.busy = false;
        this.data_address = 0;
        this.cg_address = 0;
        this.active_memory = 13;
        this.four_bit_mode = false;
        this.four_bit_first = true;
        this.incr_not_decr = true;
        this.shift_not_move = false;
        this.command_word = 0;
        this.command_old = 0;
        this.lcdCanvas.clearDisplay();
        this.lcdCanvas.cursorHome();
        this.lcdCanvas.enableDisplay(false);
    }

    public void doClearDisplay() {
        if (this.debug) {
            this.msg("doClearDisplay...");
        }
        this.lcdCanvas.clearDisplay();
        this.setBusyFor(1.0E-5);
    }

    public void doCursorHome() {
        if (this.debug) {
            this.msg("doCursorHome...");
        }
        this.lcdCanvas.cursorHome();
        this.setBusyFor(1.0E-5);
    }

    public void doSetEntryMode() {
        this.incr_not_decr = (this.command_word & 2) > 0;
        this.shift_not_move = (this.command_word & 1) > 0;
        this.setBusyFor(1.0E-5);
        if (this.debug) {
            this.msg("doSetEntryMode: incr= " + this.incr_not_decr + "shift= " + this.shift_not_move);
        }
    }

    public void doSetDisplayOn() {
        if ((this.command_word & 1) > 0) {
            this.lcdCanvas.selectUnderlineCursor(false);
        } else {
            this.lcdCanvas.selectUnderlineCursor(true);
        }
        if ((this.command_word & 2) > 0) {
            this.lcdCanvas.enableCursor(true);
        } else {
            this.lcdCanvas.enableCursor(false);
        }
        if ((this.command_word & 4) > 0) {
            this.lcdCanvas.enableDisplay(true);
        } else {
            this.lcdCanvas.enableDisplay(false);
        }
        this.setBusyFor(1.0E-5);
        if (this.debug) {
            this.msg("doSetDisplayOn: on/off= display on= " + ((this.command_word & 4) > 0) + "cursor on= " + ((this.command_word & 2) > 0) + "block cursor=" + ((this.command_word & 1) > 0));
        }
    }

    public void doShiftMove() {
        int cmd = this.command_word & 0xC;
        switch (cmd) {
            case 0: {
                this.lcdCanvas.moveCursorLeft();
                this.decrementDataAddress();
                break;
            }
            case 4: {
                this.lcdCanvas.moveCursorRight();
                this.incrementDataAddress();
                break;
            }
            case 8: {
                this.lcdCanvas.rotateLeft();
                break;
            }
            case 12: {
                this.lcdCanvas.rotateRight();
                break;
            }
            default: {
                System.err.println("-E- doShiftMove: illegal cmd!");
            }
        }
        this.setBusyFor(1.0E-5);
        if (this.debug) {
            this.msg("doShiftMove " + cmd);
        }
    }

    public void doSetFunction() {
        if (this.debug) {
            this.msg("doSetFunction: " + this.hex(this.command_word));
        }
        if ((this.command_word & 0x30) == 48 && (this.command_old & 0x30) == 48) {
            if (this.debug) {
                this.msg("doSetFunction: multiple 0x0030's: resetting!");
            }
            this.doInitialize();
            return;
        }
        if ((this.command_word & 0x10) > 0) {
            this.four_bit_mode = false;
        } else {
            if (this.debug) {
                this.msg("doSetFunction: setting 4-bit interface!");
            }
            this.four_bit_mode = true;
            this.four_bit_first = true;
        }
        if ((this.command_word & 8) > 0) {
            this.lcdCanvas.selectTwoLines(true);
        } else {
            this.lcdCanvas.selectTwoLines(false);
        }
        if ((this.command_word & 4) > 0) {
            System.err.println("-E- Cannot change character font, ignored!");
        }
        this.lcdCanvas.repaint(20L);
        this.setBusyFor(1.0E-5);
    }

    public void doSetCGAddress() {
        this.cg_address = this.command_word & 0x3F;
        this.active_memory = 14;
        this.setBusyFor(1.0E-5);
        if (this.debug) {
            this.msg("doSetCGAddress: " + this.cg_address);
        }
    }

    public void doSetDataAddress() {
        this.data_address = this.command_word & 0x7F;
        this.active_memory = 13;
        this.setBusyFor(1.0E-5);
        if (this.debug) {
            this.msg("doSetDataAddress: " + this.data_address);
        }
    }

    public void doReadBusy() {
        this.msg("doReadBusy: NOT IMPLEMENTED HERE, see evaluate!");
    }

    public void doWriteData() {
        if (this.debug) {
            this.msg("doWriteData...");
        }
        this.writeData(this.command_word & 0xFF);
        this.setBusyFor(1.0E-5);
    }

    public void doReadData() {
        int value = this.readData();
        if (this.debug) {
            this.msg("doReadData:" + value);
        }
        this.setBusyFor(1.0E-5);
    }

    public void setCGAddress(int address) {
        this.cg_address = address;
        this.active_memory = 14;
    }

    public void setDataAddress(int address) {
        this.data_address = address;
        this.active_memory = 13;
    }

    public void writeData(int value) {
        if (this.active_memory == 13) {
            if (this.debug) {
                this.msg("writing data memory, addr= " + this.data_address + " data= " + value);
            }
            if (this.shift_not_move) {
                this.lcdCanvas.setDataAt(this.data_address, value);
                if (this.incr_not_decr) {
                    this.lcdCanvas.rotateLeft();
                } else {
                    this.lcdCanvas.rotateRight();
                }
                this.updateDataAddress();
                this.lcdCanvas.setCursorAddress(this.data_address);
                this.lcdCanvas.repaint(20L);
            } else {
                this.lcdCanvas.setDataAt(this.data_address, value);
                this.updateDataAddress();
                this.lcdCanvas.setCursorAddress(this.data_address);
                this.lcdCanvas.repaint(20L);
            }
        } else {
            if (this.debug) {
                this.msg("writing CG memory, addr= " + this.cg_address + " data= " + value);
            }
            this.lcdCanvas.writeCGRam(this.cg_address, value);
            this.updateCGAddress();
            this.lcdCanvas.repaint(20L);
        }
    }

    public void updateDataAddress() {
        if (this.incr_not_decr) {
            this.incrementDataAddress();
        } else {
            this.decrementDataAddress();
        }
    }

    public void incrementDataAddress() {
        this.data_address = this.data_address + 1 & 0x7F;
    }

    public void decrementDataAddress() {
        this.data_address = this.data_address - 1 & 0x7F;
    }

    public void updateCGAddress() {
        this.cg_address = this.incr_not_decr ? this.cg_address + 1 & 0x3F : this.cg_address - 1 & 0x3F;
    }

    public int readData() {
        if (this.active_memory == 13) {
            int value = this.lcdCanvas.getDataAt(this.data_address);
            this.updateDataAddress();
            if (this.debug) {
                this.msg("reading data memory, addr= " + this.data_address + " data= " + value);
            }
            return value;
        }
        int value = this.lcdCanvas.readCGRam(this.cg_address);
        this.updateCGAddress();
        if (this.debug) {
            this.msg("reading CG memory, addr= " + this.cg_address + " data= " + value);
        }
        return value;
    }

    public int readAddress() {
        if (this.active_memory == 13) {
            int value = this.lcdCanvas.getDataAt(this.data_address);
            if (this.debug) {
                this.msg("reading data address= " + value);
            }
            return value;
        }
        int value = this.lcdCanvas.readCGRam(this.cg_address);
        if (this.debug) {
            this.msg("reading CG address= " + value);
        }
        return value;
    }

    void buildGUI() {
        this.topFrame = new JFrame("TextLCD " + this.getName());
        this.topFrame.setBackground(Color.lightGray);
        this.topFrame.setDefaultCloseOperation(1);
        this.lcdCanvas = new TextLCDCanvas(this.n_rows, this.n_cols);
        this.buildControlPanel();
        this.topFrame.getContentPane().add("Center", this.lcdCanvas);
        this.topFrame.getContentPane().add("South", this.controlPanel);
        this.topFrame.pack();
    }

    void buildControlPanel() {
        this.controlPanel = new JPanel(new FlowLayout(0));
        this.controlPanel.setBackground(Color.lightGray);
        this.debugCheckbox = new JCheckBox("messages");
        this.debugCheckbox.setSelected(this.getLocalDebug());
        this.debugCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TextLCD.this.setLocalDebug(TextLCD.this.debugCheckbox.isSelected());
            }
        });
        this.controlPanel.add(this.debugCheckbox);
    }

    void buildGUICallbacks() {
        this.topFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                TextLCD.this.topFrame.setVisible(false);
            }
        });
    }

    public void changeName() {
        this.message("-E- TextLCD.changeName(): NOT IMPLEMENTED YET!");
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.n_rows + " " + this.n_cols);
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.n_rows = Integer.parseInt(st.nextToken());
            this.n_cols = Integer.parseInt(st.nextToken());
            this.lcdCanvas.setSize(this.n_rows, this.n_cols);
            this.topFrame.pack();
            if (this.debug) {
                this.message("TextLCD.initialize: " + this.toString());
            }
        }
        catch (Exception e) {
            ExceptionTracer.trace(e);
            ExceptionTracer.message("-E- TextLCD.initialize(): " + s);
        }
        return true;
    }

    public Component getPropertySheet() {
        return this.topFrame;
    }

    public void configure() {
        if (this.topFrame == null) {
            this.buildGUI();
            this.buildGUICallbacks();
        }
        this.topFrame.setVisible(true);
    }

    public void mousePressed(MouseEvent me) {
        if (this.debug) {
            this.message("-I- TextLCD: mousePressed");
        }
        this.topFrame.setVisible(!this.topFrame.isShowing());
    }

    public void elaborate(Object arg) {
        if (this.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        if (this.simulator == null) {
            return;
        }
        this.doInitialize();
        this.disableDataBusDrivers(0.0);
    }

    public void evaluate(Object arg) {
        SimEvent evt = (SimEvent)arg;
        if (evt == null) {
            return;
        }
        Port target = evt.getTargetPort();
        if (target == this.port_E || target == this.port_RW || target == this.port_RS) {
            if (this.debug) {
                this.msg("control signal event on " + target);
            }
        } else {
            if (this.debug) {
                this.msg("ignoring data change on " + target);
            }
            return;
        }
        SignalStdLogic1164 signal_E = (SignalStdLogic1164)this.port_E.getSignal();
        SignalStdLogic1164 signal_RW = (SignalStdLogic1164)this.port_RW.getSignal();
        if (signal_E == null) {
            return;
        }
        StdLogic1164 value_RW = this.port_RW.getValueOrU();
        if (value_RW.is_1()) {
            if (signal_E.hasRisingEdge()) {
                int data = this.readAddress() & 0x7F;
                if (this.busy) {
                    data |= 0x80;
                }
                if (this.debug) {
                    this.msg("...reading: " + data + " " + this.busy);
                }
                this.enableDataBusDrivers(data, 3.0E-7);
                return;
            }
            if (signal_E.hasFallingEdge()) {
                this.disableDataBusDrivers(3.0E-8);
                return;
            }
        } else {
            if (signal_RW.hasFallingEdge()) {
                this.disableDataBusDrivers(3.0E-8);
                return;
            }
            if (value_RW.is_0() && signal_E.hasFallingEdge()) {
                if (this.busy) {
                    System.err.println("-W- TextLCD is busy, ignoring command: " + this.buildCommandWord() + " at t=" + this.simulator.getSimTime());
                } else {
                    int new_command = this.buildCommandWord();
                    this.decode(new_command);
                }
            }
        }
    }

    private int buildCommandWord() {
        int command_word = 0;
        if (this.port_RS.getValueOrU().isHigh_1H()) {
            command_word |= 0x200;
        }
        if (this.port_RW.getValueOrU().isHigh_1H()) {
            command_word |= 0x100;
        }
        if (this.port_D7.getValueOrU().isHigh_1H()) {
            command_word |= 0x80;
        }
        if (this.port_D6.getValueOrU().isHigh_1H()) {
            command_word |= 0x40;
        }
        if (this.port_D5.getValueOrU().isHigh_1H()) {
            command_word |= 0x20;
        }
        if (this.port_D4.getValueOrU().isHigh_1H()) {
            command_word |= 0x10;
        }
        if (this.port_D3.getValueOrU().isHigh_1H()) {
            command_word |= 8;
        }
        if (this.port_D2.getValueOrU().isHigh_1H()) {
            command_word |= 4;
        }
        if (this.port_D1.getValueOrU().isHigh_1H()) {
            command_word |= 2;
        }
        if (this.port_D0.getValueOrU().isHigh_1H()) {
            command_word |= 1;
        }
        if (this.debug) {
            this.msg("...buildCommandWord: " + this.hex(command_word));
        }
        return command_word;
    }

    public void decode(int command) {
        if (this.debug) {
            this.msg("...decoding: " + this.hex(command));
        }
        if (this.four_bit_mode) {
            if (this.four_bit_first) {
                this.command_old = this.command_word;
                this.command_word = command & 0xF0;
                this.four_bit_first = false;
                if (this.debug) {
                    this.msg("...4-bit: got higher nibble: " + this.hex(this.command_word));
                }
                return;
            }
            this.command_word = this.command_word | (command & 0xF0) >> 4 | command & 0x300;
            this.four_bit_first = true;
            if (this.debug) {
                this.msg("...4-bit: got command: " + this.hex(this.command_word));
            }
        } else {
            this.command_old = this.command_word;
            this.command_word = command;
        }
        if (this.command_word == 0) {
            return;
        }
        if (this.command_word >= 768) {
            this.doReadData();
        } else if (this.command_word >= 512) {
            this.doWriteData();
        } else if (this.command_word >= 256) {
            this.doReadBusy();
        } else if (this.command_word >= 128) {
            this.doSetDataAddress();
        } else if (this.command_word >= 64) {
            this.doSetCGAddress();
        } else if (this.command_word >= 32) {
            this.doSetFunction();
        } else if (this.command_word >= 16) {
            this.doShiftMove();
        } else if (this.command_word >= 8) {
            this.doSetDisplayOn();
        } else if (this.command_word >= 4) {
            this.doSetEntryMode();
        } else if (this.command_word >= 2) {
            this.doCursorHome();
        } else if (this.command_word >= 1) {
            this.doClearDisplay();
        } else {
            System.err.println("-E- internal error: illegal command word: " + this.hex(this.command_word));
        }
    }

    public SimObject copy() {
        TextLCD tmp = null;
        try {
            tmp = (TextLCD)this.getClass().newInstance();
            tmp.setEditor(this.getEditor());
            tmp.setVisible(this.isVisible());
            tmp.setName(this.getName());
            tmp.setClassLoader(this.getClassLoader());
            return tmp;
        }
        catch (Exception e) {
            this.message("-E- Internal error in SimObject.copy(): " + e);
            return null;
        }
    }

    private void disableDataBusDrivers(double delay) {
        if (this.simulator == null) {
            return;
        }
        StdLogic1164 value = this.value_H;
        double time = this.simulator.getSimTime() + delay;
        if (this.debug) {
            this.msg("...disableDataBusDrivers: " + time);
        }
        int i = 0;
        while (i < 8) {
            Port port = this.ports[i + 3];
            Signal signal = port.getSignal();
            if (signal != null) {
                this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, time, value, (Object)port));
            }
            ++i;
        }
    }

    private void enableDataBusDrivers(int data, double delay) {
        if (this.simulator == null) {
            return;
        }
        double time = this.simulator.getSimTime() + delay;
        if (this.debug) {
            this.msg("enableDataBusDrivers: " + data + " " + time);
        }
        int mask = 128;
        int i = 0;
        while (i < 8) {
            StdLogic1164 value;
            Port port = this.ports[i + 3];
            Signal signal = port.getSignal();
            StdLogic1164 stdLogic1164 = value = (data & mask) > 0 ? this.value_1 : this.value_0;
            if (signal != null) {
                this.simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal, time, value, (Object)port));
            }
            mask >>>= 1;
            ++i;
        }
    }

    public void setBusyFor(double delta_t) {
        if (this.simulator == null) {
            return;
        }
        double time = this.simulator.getSimTime();
        this.simulator.scheduleWakeup(this, time + delta_t, this);
        this.busy = true;
        if (this.debug) {
            this.msg("setBusyFor(): " + delta_t + " at " + time);
        }
    }

    public void wakeup(Object arg) {
        if (this.debug) {
            this.msg("wakeup: " + this.simulator.getSimTime());
        }
        this.busy = false;
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName();
    }

    public String hex(int i) {
        return Integer.toHexString(i);
    }

    public String toString() {
        return "TextLCD: " + this.getFullName();
    }

    public void msg(String s) {
        System.out.println("-#- TextLCD." + s);
    }

    public static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception e) {}
    }

    public static void main(String[] argv) {
        TextLCD cc = new TextLCD();
        cc.topFrame.setVisible(true);
        cc.lcdCanvas.setAutoRepaintEnable(true);
        cc.decode(1);
        cc.decode(2);
        cc.decode(6);
        cc.decode(131);
        int i = 0;
        while (i < 10) {
            cc.decode(512 + i + 65);
            TextLCD.sleep(200);
            ++i;
        }
        TextLCD.sleep(1000);
        cc.decode(14);
        cc.decode(4);
        cc.decode(208);
        int i2 = 0;
        while (i2 < 10) {
            cc.decode(512 + i2 + 97);
            TextLCD.sleep(200);
            ++i2;
        }
        TextLCD.sleep(1000);
        cc.decode(7);
        cc.decode(153);
        int i3 = 0;
        while (i3 < 10) {
            cc.decode(512 + i3 + 48);
            TextLCD.sleep(200);
            ++i3;
        }
        cc.decode(5);
        cc.decode(231);
        int i4 = 0;
        while (i4 < 10) {
            cc.decode(512 + i4 + 65);
            TextLCD.sleep(200);
            ++i4;
        }
        TextLCD.sleep(1000);
        cc.decode(48);
        TextLCD.sleep(100);
        cc.decode(6);
        cc.decode(128);
        int i5 = 0;
        while (i5 < 40) {
            cc.decode(768);
            ++i5;
        }
        cc.decode(3);
        int i6 = 0;
        while (i6 < 15) {
            cc.decode(20);
            ++i6;
        }
        TextLCD.sleep(2000);
        cc.decode(56);
        int i7 = 0;
        while (i7 < 63) {
            cc.decode(64 + i7);
            cc.decode(512 + i7);
            ++i7;
        }
        int i8 = 0;
        while (i8 < 63) {
            cc.decode(64 + i8);
            cc.decode(768);
            ++i8;
        }
        while (true) {
            int addr;
            if ((addr = (int)(Math.random() * 80.0)) > 39) {
                addr += 24;
            }
            int value = (int)(Math.random() * 255.999);
            cc.lcdCanvas.setCursorAddress(addr);
            cc.lcdCanvas.setDataAt(addr, value);
            cc.lcdCanvas.repaintAt(addr);
            if (Math.random() > 0.98) {
                TextLCD.sleep(2000);
                cc.doClearDisplay();
            }
            TextLCD.sleep(30);
        }
    }
}

