/*
 * Decompiled with CFR 0.152.
 */
package hades.models.special;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JComponent;
import javax.swing.JFrame;
import jfig.gui.ImageHelper;
import jfig.utils.SetupManager;

public class GraphicsLCDCanvas
extends JComponent {
    private Image bufferImage;
    private Graphics bufferGraphics;
    private int[][] bufferMemory;
    private Color lcdBackground;
    private Color lcdInactivePixel;
    private Color lcdActivePixel;
    private int n_rows = 64;
    private int n_pages = this.n_rows / 8;
    private int n_columns = 128;
    private int left_border = 5;
    private int top_border = 5;
    private int pixel_size = 3;
    private int pixel_spacer = 1;
    private int width = 100;
    private int height = 100;
    private boolean display_enable = true;
    private int n_writes = 0;
    private int n_changed = 0;
    private int n_unchanged = 0;
    private int n_not_showing = 0;

    public GraphicsLCDCanvas() {
        this.setDefaultSize();
        this.createDefaultColors();
        this.createBufferImage();
        this.initializeBufferMemory();
        this.repaint();
    }

    public void setDefaultSize() {
        this.setSize(128, 64);
    }

    public void setSize(int n_columns, int n_rows) {
        this.n_columns = n_columns;
        this.n_rows = n_rows;
        this.n_pages = n_rows / 8;
    }

    public void createDefaultColors() {
        this.lcdBackground = SetupManager.getColor("Hades.GraphicsLCDCanvas.lcdBackground", new Color(191, 223, 0));
        this.lcdInactivePixel = SetupManager.getColor("Hades.GraphicsLCDCanvas.lcdInactivePixel", new Color(181, 210, 0));
        this.lcdActivePixel = SetupManager.getColor("Hades.GraphicsLCDCanvas.lcdActivePixel", new Color(0, 0, 0));
        this.setBackground(this.lcdBackground);
    }

    public void createBufferImage() {
        this.width = this.left_border * 2 + this.n_columns * this.pixel_size + (this.n_columns - 1) * this.pixel_spacer;
        this.height = this.top_border * 2 + this.n_rows * this.pixel_size + (this.n_rows - 1) * this.pixel_spacer;
        this.bufferImage = ImageHelper.createImage(this.width, this.height);
        this.bufferGraphics = this.bufferImage.getGraphics();
        this.bufferGraphics.setColor(this.lcdBackground);
        this.bufferGraphics.fillRect(0, 0, this.width, this.height);
    }

    public void drawIntoBuffer(int page, int col, int data) {
        int row = page << 3;
        int x0 = this.left_border + col * this.pixel_size + (col - 1) * this.pixel_spacer;
        int y0 = this.top_border + row * this.pixel_size + (row - 1) * this.pixel_spacer;
        boolean dark = false;
        int mask = 1;
        int d = 0;
        while (d < 8) {
            boolean bl = dark = (data & mask) > 0;
            if (dark) {
                this.bufferGraphics.setColor(this.lcdActivePixel);
            } else {
                this.bufferGraphics.setColor(this.lcdInactivePixel);
            }
            this.bufferGraphics.fillRect(x0, y0, this.pixel_size, this.pixel_size);
            y0 = y0 + this.pixel_size + this.pixel_spacer;
            mask <<= 1;
            ++d;
        }
    }

    public void initializeBufferMemory() {
        this.bufferMemory = new int[this.n_rows / 8][this.n_columns];
        int p = 0;
        while (p < this.n_pages) {
            int c = 0;
            while (c < this.n_columns) {
                this.bufferMemory[p][c] = 0;
                ++c;
            }
            ++p;
        }
    }

    public void write(int page, int col, int data) {
        int newData;
        int oldData = this.bufferMemory[page][col];
        this.bufferMemory[page][col] = newData = data & 0xFF;
        this.drawIntoBuffer(page, col, data);
        ++this.n_writes;
        if (oldData != newData) {
            if (this.isShowing()) {
                ++this.n_changed;
                this.repaint(100L);
            } else {
                ++this.n_not_showing;
            }
        } else {
            ++this.n_unchanged;
        }
        if ((this.n_writes & 0xFFF) == 4095) {
            System.out.println("-X- GraphicsLCDCanvas: repaint stats:  n_writes=" + this.n_writes + " n_repaints=" + this.n_changed + " n_ignores=" + this.n_unchanged + " n_invisible=" + this.n_not_showing);
        }
    }

    public int read(int page, int col) {
        return this.bufferMemory[page][col] & 0xFF;
    }

    public void clearDisplay() {
        int p = 0;
        while (p < this.n_pages) {
            int c = 0;
            while (c < this.n_columns) {
                this.bufferMemory[p][c] = 0;
                this.drawIntoBuffer(p, c, 0);
                ++c;
            }
            ++p;
        }
    }

    public void enableDisplay(boolean b) {
        this.display_enable = b;
    }

    public boolean isOpaque() {
        return true;
    }

    public boolean isDoubleBuffered() {
        return true;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.display_enable) {
            if (this.bufferImage != null) {
                g.drawImage(this.bufferImage, 0, 0, this);
            } else {
                GraphicsLCDCanvas.msg("-E- " + this.toString() + " internal: bufferImage null!");
            }
        } else {
            g.clearRect(0, 0, this.width, this.height);
        }
    }

    public void paintComponent(Graphics g) {
        this.paint(g);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public static void msg(String msg) {
        System.out.println(msg);
    }

    public static void main(String[] argv) {
        System.out.println("GraphicsLCDCanvas selftest, please wait...");
        JFrame frame = new JFrame("GraphicsLCDCanvas selftest");
        frame.setSize(100, 50);
        frame.setVisible(true);
        ImageHelper.setVisibleParent(frame);
        GraphicsLCDCanvas lcd = new GraphicsLCDCanvas();
        frame.getContentPane().add("Center", lcd);
        frame.pack();
        frame.setVisible(true);
        try {
            Thread.sleep(3000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        long t1 = System.currentTimeMillis();
        int iter = 0;
        while (true) {
            int p = 0;
            while (p < lcd.n_pages) {
                int c = 0;
                while (c < lcd.n_columns) {
                    int data = (int)(256.0 * Math.random());
                    lcd.write(p, c, data);
                    ++c;
                }
                ++p;
            }
            lcd.repaint(20L);
            if ((++iter & 0x1F) != 31) continue;
            long t2 = System.currentTimeMillis();
            System.out.println("...iterations: " + iter + " iters/sec= " + 1.0 * (double)iter / (double)(t2 - t1));
        }
    }
}

