/*
 * Decompiled with CFR 0.152.
 */
package hades.models.ruge;

import hades.gui.PropertySheet;
import hades.manager.DesignManager;
import hades.models.StdLogic1164;
import hades.models.ruge.Color_DIN_IEC_62;
import hades.models.ruge.ColoredRectangle;
import hades.models.ruge.ColoredValueLabel;
import hades.models.ruge.IntegerSignal;
import hades.signals.Signal;
import hades.signals.SignalStdLogic1164;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimObject;
import hades.utils.NameMangler;
import hades.utils.StringTokenizer;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import jfig.utils.ExceptionTracer;

public class RAM_64K
extends SimObject {
    StdLogic1164 output_0;
    StdLogic1164 output_1;
    StdLogic1164 output_X;
    StdLogic1164 output_Z;
    Port port_nWE;
    Port port_nME;
    Port port_ADDR;
    Port port_DIN;
    Port port_DOUT;
    Integer value_ADDR;
    Integer value_DIN;
    Integer value_DOUT;
    private int n_words = 65536;
    private int address;
    private int[] data;
    String resourcename = "/hades/models/rtl/RAM_64K.rom";
    public static final int TRISTATED = -2;
    public static final int UNDEFINED = -1;
    public static final double t_access = 3.0E-8;
    public static final double t_tristate = 5.0E-9;
    public static final double t_undefined = 6.0E-9;
    static /* synthetic */ Class class$hades$models$ruge$IntegerSignal;

    public RAM_64K() {
        this.ports = new Port[5];
        this.ports[0] = new Port(this, "ADDR", 0, null, class$hades$models$ruge$IntegerSignal == null ? (class$hades$models$ruge$IntegerSignal = RAM_64K.class$("hades.models.ruge.IntegerSignal")) : class$hades$models$ruge$IntegerSignal);
        this.port_ADDR = this.ports[0];
        this.ports[1] = new Port(this, "DIN", 0, null, class$hades$models$ruge$IntegerSignal == null ? (class$hades$models$ruge$IntegerSignal = RAM_64K.class$("hades.models.ruge.IntegerSignal")) : class$hades$models$ruge$IntegerSignal);
        this.port_DIN = this.ports[1];
        this.ports[2] = new Port(this, "DOUT", 1, null, class$hades$models$ruge$IntegerSignal == null ? (class$hades$models$ruge$IntegerSignal = RAM_64K.class$("hades.models.ruge.IntegerSignal")) : class$hades$models$ruge$IntegerSignal);
        this.port_DOUT = this.ports[2];
        this.ports[3] = new Port(this, "nME", 0, null);
        this.port_nME = this.ports[3];
        this.ports[4] = new Port(this, "nWE", 0, null);
        this.port_nWE = this.ports[4];
        this.data = new int[this.n_words];
        this.address = -1;
        this.output_X = new StdLogic1164(1);
        this.output_Z = new StdLogic1164(4);
        this.output_0 = new StdLogic1164(2);
        this.output_1 = new StdLogic1164(3);
        this.initRAM();
    }

    public boolean needsExternalResources() {
        return true;
    }

    public String[] getExternalResources() {
        String[] externals = new String[]{this.getResourcename()};
        return externals;
    }

    public void initRAM() {
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = -1;
            ++i;
        }
    }

    public void printSramContent() {
        StringBuffer sb = new StringBuffer();
        sb.append("-I- " + this.toString() + "contents:");
        int i = 0;
        while (i < this.data.length) {
            sb.append("   " + i + " ");
            if (this.data[i] == -1) {
                sb.append("XXXX");
            } else {
                sb.append("" + Integer.toString(this.data[i], 16));
            }
            sb.append("\n");
            ++i;
        }
        this.message(sb.toString());
    }

    public String getResourcename() {
        return this.resourcename;
    }

    public void setResourcename(String s) {
        this.resourcename = s;
        this.initialize("" + this.versionId + " " + s);
    }

    public boolean initialize(String s) {
        int versionID = 1001;
        this.resourcename = "";
        try {
            StringTokenizer st = new StringTokenizer(s);
            int n_tokens = st.countTokens();
            if (n_tokens == 1) {
                this.resourcename = NameMangler.decodeUnicodeEscapes(st.nextToken());
            } else if (n_tokens == 2) {
                this.versionId = Integer.parseInt(st.nextToken());
                this.resourcename = NameMangler.decodeUnicodeEscapes(st.nextToken());
            } else {
                throw new Exception("need 1 or 2 args, but got: " + s);
            }
            this.parseRAM(this.resourcename);
        }
        catch (Exception e) {
            this.message("-E- RAM_64K.initialize(): " + e);
            this.message("-E- offending input is '" + s + "'");
            ExceptionTracer.trace(e);
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + NameMangler.encodeWithUnicodeEscapes(this.resourcename));
    }

    /*
     * Unable to fully structure code
     */
    public void parseRAM(String resourcename) {
        is = null;
        br = null;
        line = null;
        valueString = null;
        addr = 0;
        row = 0;
        try {
            is = DesignManager.getDesignManager().getInputStream(this, resourcename);
            br = new BufferedReader(new InputStreamReader(is));
        }
        catch (Exception ee) {
            this.message("-E- in RAM_64K.parseRAM(): resource file not found: ");
            this.message("    " + resourcename);
        }
        try {
            while ((line = br.readLine()) != null) {
                st = new StringTokenizer(line, " \t:");
                addr = Integer.parseInt(st.nextToken(), 16);
                valueString = st.nextToken();
                if (valueString.length() != 2) ** GOTO lbl27
                row = Integer.parseInt(valueString, 16);
                this.setData(addr, row);
                continue;
lbl-1000:
                // 1 sources

                {
                    row = Integer.parseInt(valueString.substring(0, 2), 16);
                    this.setData(addr, row);
                    ++addr;
                    valueString = valueString.substring(2, valueString.length());
lbl27:
                    // 2 sources

                    ** while (valueString.length() >= 2)
                }
lbl28:
                // 1 sources

            }
        }
        catch (Exception e) {
            this.message("-E- in RAM_64K.parseRAM(): " + e);
            ExceptionTracer.trace(e);
        }
    }

    private void setData(int address, int value) {
        if (address < 0 || address > this.data.length - 1) {
            this.message("-E- RAM.setData(): out-of-range address: " + address);
            this.message("-W- address and data ignored!");
            return;
        }
        this.data[address] = value;
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this RAM_64K...");
        }
        String[] fields = new String[]{"instance name:", "name", "RAM data file/resource name:", "resourcename"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("RAM_64K parameters:\nspecify the Java resource name of the RAM data file, \ne.g. '/hades/examples/b-tutorial/ampel-43.rom'. \nEach line of that file should contain an address and the \ncorresponding data in hex, e.g. '0001:D3' or '03FF:20' \nThe RAM will parse that file after clicking on OK or Apply. ");
        this.propertySheet.setVisible(true);
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        if (this.simulator != null) {
            this.scheduleOutputs(-1, 6.0E-9);
        }
    }

    private StdLogic1164 getValue(Signal signal, StdLogic1164 defaultValue) {
        StdLogic1164 value = null;
        if (signal == null) {
            value = defaultValue;
        } else {
            value = (StdLogic1164)signal.getValue();
            if (value == null) {
                value = defaultValue;
            }
        }
        return value;
    }

    public void evaluate(Object arg) {
        boolean needsEval;
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        SignalStdLogic1164 signal_nWE = (SignalStdLogic1164)this.port_nWE.getSignal();
        SignalStdLogic1164 signal_nME = (SignalStdLogic1164)this.port_nME.getSignal();
        IntegerSignal signal_ADDR = (IntegerSignal)this.port_ADDR.getSignal();
        if (signal_nWE == null || signal_nME == null || signal_ADDR == null) {
            this.scheduleOutputs(-1, 3.0E-8);
            return;
        }
        boolean bl = needsEval = signal_ADDR.hasEvent() || signal_nWE.hasEvent() || signal_nME.hasEvent();
        if (!needsEval) {
            return;
        }
        StdLogic1164 value_nWE = this.getValue(signal_nWE, this.output_X);
        StdLogic1164 value_nME = this.getValue(signal_nME, this.output_X);
        if (signal_nME.hasFallingEdge()) {
            this.latchAdress(signal_ADDR);
            this.scheduleOutputs(this.address, 3.0E-8);
        } else if (signal_nME.hasRisingEdge()) {
            this.scheduleOutputs(-2, 5.0E-9);
            if (value_nWE.is_0()) {
                this.writeRAM();
            }
        } else if (value_nME.is_0()) {
            if (signal_nWE.hasRisingEdge()) {
                this.writeRAM();
            } else if (value_nWE.is_1()) {
                this.scheduleOutputs(this.address, 3.0E-8);
            } else if (value_nWE.is_0()) {
                this.scheduleOutputs(-2, 5.0E-9);
            }
        } else if (value_nME.is_1()) {
            this.scheduleOutputs(-2, 5.0E-9);
        } else {
            this.scheduleOutputs(-1, 6.0E-9);
        }
    }

    protected void latchAdress(IntegerSignal signal_A) {
        Integer value_ADDR = (Integer)signal_A.getValue();
        this.address = value_ADDR == null ? -1 : value_ADDR & 0xFFFF;
        this.dbg("-I- RAM.latchAdress: " + this.address);
    }

    private void writeRAM() {
        int value;
        try {
            value = (Integer)this.port_DIN.getSignal().getValue();
        }
        catch (Exception e) {
            value = -1;
        }
        if (this.address < 0) {
            this.message("-E- invalid RAM address: " + this.address + ", write ignored!");
            return;
        }
        this.data[this.address] = value;
        this.dbg("-I- RAM.writeRAM: address= " + this.address + " data=" + value);
    }

    private void scheduleOutputs(int index, double t_delay) {
        this.dbg("-I- RAM.scheduleOutputs: " + index + " delay: " + t_delay);
        double time = this.simulator.getSimTime() + t_delay;
        Signal signal = this.port_DOUT.getSignal();
        if (signal == null) {
            return;
        }
        Integer value = this.address > 0 ? new Integer(this.data[this.address]) : new Integer(-1);
        SimEvent event = new SimEvent(signal, time, value, this.port_DOUT);
        this.simulator.scheduleEvent(event);
        this.updateDisplay(this.address, value);
    }

    public void updateDisplay(int address, int value) {
        if (this.symbol == null || !this.symbol.isVisible()) {
            return;
        }
        Color c = Color_DIN_IEC_62.getColor((int)value);
        Enumeration E = this.symbol.getMembers().elements();
        while (E.hasMoreElements()) {
            Object tmp = E.nextElement();
            if (tmp instanceof ColoredRectangle) {
                ((ColoredRectangle)tmp).setColor(c);
                continue;
            }
            if (!(tmp instanceof ColoredValueLabel)) continue;
            ((ColoredValueLabel)tmp).setColor(c);
            ((ColoredValueLabel)tmp).setText("A[" + address + "]: " + value);
        }
        if (this.symbol.painter != null) {
            this.symbol.painter.paint(this.symbol, 50);
        }
    }

    public void dbg(String msg) {
        System.out.println(msg);
    }

    public String toString() {
        return "RAM_64K: " + this.getFullName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

