/*
 * Decompiled with CFR 0.152.
 */
package hades.models.ruge;

import hades.gui.PropertySheet;
import hades.models.StdLogic1164;
import hades.models.ruge.Color_DIN_IEC_62;
import hades.models.ruge.ColoredRectangle;
import hades.models.ruge.ColoredValueLabel;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.utils.StringTokenizer;
import java.awt.Color;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import jfig.utils.ExceptionTracer;

public class Mux
extends SimObject
implements Simulatable,
Serializable {
    protected Port port_S;
    protected Port port_A1;
    protected Port port_A0;
    protected Port port_Y;
    protected Integer next_Y;
    protected Integer value_U;
    protected double delay;
    protected double defaultdelay = 1.0E-8;
    static /* synthetic */ Class class$hades$models$ruge$IntegerSignal;
    static /* synthetic */ Class class$hades$signals$SignalStdLogic1164;

    public Mux() {
        this.ports = new Port[4];
        this.ports[0] = new Port(this, "A0", 0, null, class$hades$models$ruge$IntegerSignal == null ? (class$hades$models$ruge$IntegerSignal = Mux.class$("hades.models.ruge.IntegerSignal")) : class$hades$models$ruge$IntegerSignal);
        this.ports[1] = new Port(this, "A1", 0, null, class$hades$models$ruge$IntegerSignal == null ? (class$hades$models$ruge$IntegerSignal = Mux.class$("hades.models.ruge.IntegerSignal")) : class$hades$models$ruge$IntegerSignal);
        this.ports[2] = new Port(this, "S", 0, null, class$hades$signals$SignalStdLogic1164 == null ? (class$hades$signals$SignalStdLogic1164 = Mux.class$("hades.signals.SignalStdLogic1164")) : class$hades$signals$SignalStdLogic1164);
        this.ports[3] = new Port(this, "Y", 1, null, class$hades$models$ruge$IntegerSignal == null ? (class$hades$models$ruge$IntegerSignal = Mux.class$("hades.models.ruge.IntegerSignal")) : class$hades$models$ruge$IntegerSignal);
        this.port_A0 = this.ports[0];
        this.port_A1 = this.ports[1];
        this.port_S = this.ports[2];
        this.port_Y = this.ports[3];
        this.next_Y = this.value_U = new Integer(-1);
        this.delay = this.defaultdelay;
    }

    public double getDelay() {
        return this.delay;
    }

    public void setDelay(double _delay) {
        this.delay = _delay;
    }

    public void setDelay(String s) {
        try {
            this.delay = new Double(s);
        }
        catch (Exception e) {
            this.message("-E- Illegal number format in String '" + s + "'");
            this.message("-w- Using default value: " + this.defaultdelay);
            this.delay = this.defaultdelay;
        }
    }

    public void elaborate(Object arg) {
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        boolean isX = false;
        Signal signal_A0 = this.port_A0.getSignal();
        if (signal_A0 == null) {
            this.next_Y = this.value_U;
        } else {
            Signal signal_A1 = this.port_A1.getSignal();
            if (signal_A1 == null) {
                this.next_Y = this.value_U;
            } else {
                Signal signal_S = this.port_S.getSignal();
                if (signal_S == null) {
                    this.next_Y = this.value_U;
                } else {
                    Integer a0 = (Integer)signal_A0.getValue();
                    Integer a1 = (Integer)signal_A1.getValue();
                    StdLogic1164 s = (StdLogic1164)signal_S.getValue();
                    this.next_Y = s.is_1() ? a1 : (s.is_0() ? a0 : this.value_U);
                }
            }
        }
        Signal signal_Y = this.port_Y.getSignal();
        if (signal_Y == null) {
            return;
        }
        SimKernel simulator = this.parent.getSimulator();
        double time = simulator.getSimTime() + this.delay;
        simulator.scheduleEvent(new SimEvent(signal_Y, time, this.next_Y, this.port_Y));
        this.updateColors();
    }

    public void updateColors() {
        if (this.symbol == null || !this.symbol.isVisible()) {
            return;
        }
        Color c = Color_DIN_IEC_62.getColor((int)this.next_Y);
        Enumeration E = this.symbol.getMembers().elements();
        while (E.hasMoreElements()) {
            Object tmp = E.nextElement();
            if (tmp instanceof ColoredRectangle) {
                ((ColoredRectangle)tmp).setColor(c);
                continue;
            }
            if (!(tmp instanceof ColoredValueLabel)) continue;
            ((ColoredValueLabel)tmp).setColor(c);
            ((ColoredValueLabel)tmp).setText("" + this.next_Y);
        }
        if (this.symbol.painter != null) {
            this.symbol.painter.paint(this.symbol, 50);
        }
    }

    public boolean initialize(String s) {
        try {
            StringTokenizer st = new StringTokenizer(s);
            this.versionId = Integer.parseInt(st.nextToken());
            this.delay = new Double(st.nextToken());
        }
        catch (Exception e) {
            this.message("-E- Error in " + this.toString() + ".initialize: " + e);
            ExceptionTracer.trace(e);
            this.delay = this.defaultdelay;
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.delay);
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "propagation delay [sec]:", "delay"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, propagation delay\nand output value:");
        this.propertySheet.setVisible(true);
    }

    public String toString() {
        return "Mux: " + this.getFullName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

