/*
 * Decompiled with CFR 0.152.
 */
package hades.models.ruge;

import hades.gui.PropertySheet;
import hades.models.ruge.Color_DIN_IEC_62;
import hades.models.ruge.ColoredRectangle;
import hades.models.ruge.ColoredValueLabel;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.utils.StringTokenizer;
import java.awt.Color;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import jfig.utils.ExceptionTracer;

public class Adder
extends SimObject
implements Simulatable,
Serializable {
    protected Port port_A;
    protected Port port_B;
    protected Port port_SUM;
    protected Integer sum;
    protected Integer value_U;
    protected double delay;
    protected double defaultdelay = 1.0E-8;
    static /* synthetic */ Class class$hades$models$ruge$IntegerSignal;

    public Adder() {
        this.ports = new Port[3];
        this.ports[0] = new Port(this, "A", 0, null, class$hades$models$ruge$IntegerSignal == null ? (class$hades$models$ruge$IntegerSignal = Adder.class$("hades.models.ruge.IntegerSignal")) : class$hades$models$ruge$IntegerSignal);
        this.ports[1] = new Port(this, "B", 0, null, class$hades$models$ruge$IntegerSignal == null ? (class$hades$models$ruge$IntegerSignal = Adder.class$("hades.models.ruge.IntegerSignal")) : class$hades$models$ruge$IntegerSignal);
        this.ports[2] = new Port(this, "SUM", 1, null, class$hades$models$ruge$IntegerSignal == null ? (class$hades$models$ruge$IntegerSignal = Adder.class$("hades.models.ruge.IntegerSignal")) : class$hades$models$ruge$IntegerSignal);
        this.port_A = this.ports[0];
        this.port_B = this.ports[1];
        this.port_SUM = this.ports[2];
        this.sum = this.value_U = new Integer(-1);
        this.delay = this.defaultdelay;
    }

    public double getDelay() {
        return this.delay;
    }

    public void setDelay(double _delay) {
        this.delay = _delay;
    }

    public void setDelay(String s) {
        try {
            this.delay = new Double(s);
        }
        catch (Exception e) {
            this.message("-E- Illegal number format in String '" + s + "'");
            this.message("-w- Using default value: " + this.defaultdelay);
            this.delay = this.defaultdelay;
        }
    }

    public void elaborate(Object arg) {
    }

    public void evaluate(Object arg) {
        Signal signal_A;
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        if ((signal_A = this.port_A.getSignal()) == null) {
            this.sum = this.value_U;
        } else {
            Signal signal_B = this.port_B.getSignal();
            if (signal_B == null) {
                this.sum = this.value_U;
            } else {
                Integer a = (Integer)signal_A.getValue();
                Integer b = (Integer)signal_B.getValue();
                if (a == null) {
                    this.message("-E- Internal in Adder.evaluate: value a null");
                    a = new Integer(17);
                }
                if (b == null) {
                    this.message("-E- Internal in Adder.evaluate: value b null");
                    b = new Integer(17);
                }
                this.sum = new Integer(a + b);
            }
        }
        Signal signal_SUM = this.port_SUM.getSignal();
        if (signal_SUM == null) {
            return;
        }
        SimKernel simulator = this.parent.getSimulator();
        double time = simulator.getSimTime() + this.delay;
        simulator.scheduleEvent(new SimEvent(signal_SUM, time, this.sum, this.port_SUM));
        this.updateColors();
    }

    public void updateColors() {
        if (this.symbol == null || !this.symbol.isVisible()) {
            return;
        }
        Color c = Color_DIN_IEC_62.getColor((int)this.sum);
        Enumeration E = this.symbol.getMembers().elements();
        while (E.hasMoreElements()) {
            Object tmp = E.nextElement();
            if (tmp instanceof ColoredRectangle) {
                ((ColoredRectangle)tmp).setColor(c);
                continue;
            }
            if (!(tmp instanceof ColoredValueLabel)) continue;
            ((ColoredValueLabel)tmp).setColor(c);
            ((ColoredValueLabel)tmp).setText("" + this.sum);
        }
        if (this.symbol.painter != null) {
            this.symbol.painter.paint(this.symbol, 50);
        }
    }

    public boolean initialize(String s) {
        try {
            StringTokenizer st = new StringTokenizer(s);
            this.versionId = Integer.parseInt(st.nextToken());
            this.delay = new Double(st.nextToken());
        }
        catch (Exception e) {
            this.message("-E- Error in " + this.toString() + ".initialize: " + e);
            ExceptionTracer.trace(e);
            this.delay = this.defaultdelay;
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.delay);
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "delay [sec]:", "delay"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name and\nadder propagation delay:");
        this.propertySheet.setVisible(true);
    }

    public String toString() {
        return "Adder: " + this.getFullName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

