/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.memory;

import hades.gui.PropertySheet;
import hades.models.Const1164;
import hades.models.PortStdLogic1164;
import hades.models.PortStdLogicVector;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.rtlib.GenericRtlibObject;
import hades.signals.Signal;
import hades.signals.SignalStdLogic1164;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimObject;
import hades.utils.HexFormat;
import hades.utils.StringTokenizer;
import hades.utils.TimeFormatter;
import java.awt.Point;
import java.io.PrintWriter;

public class USART8251
extends GenericRtlibObject {
    public static final int DATA_INVALID = -1;
    public static final int STATE_RESET = 0;
    public static final int STATE_WAIT_FOR_SYNC1 = 1;
    public static final int STATE_WAIT_FOR_SYNC2 = 2;
    public static final int STATE_ACTIVE = 3;
    public static final int STATE_INVALID = 4;
    public static final int ASYNC_RATE_1 = 1;
    public static final int ASYNC_RATE_16 = 2;
    public static final int ASYNC_RATE_64 = 3;
    public static final int ASYNC_RATE_MASK = 3;
    public static final int ASYNC_5_BITS = 0;
    public static final int ASYNC_6_BITS = 4;
    public static final int ASYNC_7_BITS = 8;
    public static final int ASYNC_8_BITS = 12;
    public static final int ASYNC_BITS_MASK = 12;
    public static final int ASYNC_NO_PARITY = 0;
    public static final int ASYNC_ODD_PARITY = 16;
    public static final int ASYNC_DISABLE_PARITY = 32;
    public static final int ASYNC_EVEN_PARITY = 48;
    public static final int ASYNC_PARITY_MASK = 48;
    public static final int ASYNC_0_STOP = 0;
    public static final int ASYNC_1_STOP = 64;
    public static final int ASYNC_15_STOP = 128;
    public static final int ASYNC_2_STOP = 192;
    public static final int ASYNC_STOPBITS_MASK = 192;
    public static final int SYNC_MASK = 3;
    public static final int SYNC_MODE = 0;
    public static final int SYNC_INTERNAL = 0;
    public static final int SYNC_EXTERNAL = 64;
    public static final int SYNC_SCS = 128;
    public static final int CMD_TXEN = 1;
    public static final int CMD_DTR = 2;
    public static final int CMD_RXE = 4;
    public static final int CMD_SBRK = 8;
    public static final int CMD_ER = 16;
    public static final int CMD_RTS = 32;
    public static final int CMD_IR = 64;
    public static final int CMD_EH = 128;
    public static final int CMD_IDLE = 38;
    public static final int STATUS_TXRDY = 1;
    public static final int STATUS_RXRDY = 2;
    public static final int STATUS_TXEMPTY = 4;
    public static final int STATUS_PE = 8;
    public static final int STATUS_OE = 16;
    public static final int STATUS_FE = 32;
    public static final int STATUS_SYNDET = 64;
    public static final int STATUS_DSR = 128;
    public static final int STATUS_OK = 0;
    public static final int TXS_EMPTY = -1;
    public static final int TXS_IDLE = 0;
    public static final int TXS_STARTBIT = 1;
    public static final int TXS_BIT0 = 2;
    public static final int TXS_BIT1 = 3;
    public static final int TXS_BIT2 = 4;
    public static final int TXS_BIT3 = 5;
    public static final int TXS_BIT4 = 6;
    public static final int TXS_BIT5 = 7;
    public static final int TXS_BIT6 = 8;
    public static final int TXS_BIT7 = 9;
    public static final int TXS_STOP1 = 10;
    public static final int TXS_STOP2 = 11;
    public static final int TXS_PEVEN = 12;
    public static final int TXS_PODD = 13;
    public static final int TXS_WAIT_FOR_CTS = 14;
    public static final int TXS_SEND_BREAK = 99;
    public static final int RXS_EMPTY = -1;
    public static final int RXS_BREAK = 19;
    public static final int RXS_IDLE = 20;
    public static final int RXS_CONFIRM_STARTBIT = 21;
    public static final int RXS_BIT0 = 23;
    public static final int RXS_BIT1 = 24;
    public static final int RXS_BIT2 = 25;
    public static final int RXS_BIT3 = 26;
    public static final int RXS_BIT4 = 27;
    public static final int RXS_BIT5 = 28;
    public static final int RXS_BIT6 = 29;
    public static final int RXS_BIT7 = 30;
    public static final int RXS_STOP1 = 31;
    public static final int RXS_STOP2 = 32;
    public static final int RXS_CHECK_EVEN = 33;
    public static final int RXS_CHECK_ODD = 34;
    public static final int RXS_SYNC1_DETECT = 38;
    public static final int RXS_SYNC2_DETECT = 39;
    public static final int DEBUG_OFF = 0;
    public static final int DEBUG_ON = 1;
    protected PortStdLogic1164 RESET;
    protected PortStdLogic1164 CnD;
    protected PortStdLogic1164 nRD;
    protected PortStdLogic1164 nWR;
    protected PortStdLogic1164 nCS;
    protected PortStdLogic1164 nDSR;
    protected PortStdLogic1164 nDTR;
    protected PortStdLogic1164 nCTS;
    protected PortStdLogic1164 nRTS;
    protected PortStdLogic1164 TXD;
    protected PortStdLogic1164 TXRDY;
    protected PortStdLogic1164 TXE;
    protected PortStdLogic1164 nTXC;
    protected PortStdLogic1164 RXD;
    protected PortStdLogic1164 RXRDY;
    protected PortStdLogic1164 nRXC;
    protected PortStdLogic1164 SYNDET;
    protected PortStdLogicVector DATA;
    protected PortStdLogic1164 nDDRIVE;
    protected StdLogic1164 value_U = Const1164.__U;
    protected StdLogic1164 value_X = Const1164.__X;
    protected StdLogic1164 value_Z = Const1164.__Z;
    protected StdLogic1164 value_0 = Const1164.__0;
    protected StdLogic1164 value_1 = Const1164.__1;
    protected StdLogicVector vector_ZZZ = null;
    protected StdLogicVector vector_XXX = null;
    protected int modeRegister;
    protected int commandRegister;
    protected int statusRegister;
    protected int transmitRegister;
    protected int receiveRegister;
    protected int sync1Character;
    protected int sync2Character;
    protected int state;
    protected Transmitter transmitter;
    protected Receiver receiver;
    protected CTSHandler ctshandler;
    protected int debugFlags = 0;
    protected double t_access = 5.0E-8;

    public USART8251() {
        this.setWidth(8);
        this.transmitter = new Transmitter();
        this.receiver = new Receiver();
        this.ctshandler = new CTSHandler();
        this.constructPorts();
        this.reset8251();
    }

    public void constructPorts() {
        this.nCS = new PortStdLogic1164(this, "nCS", 0, null);
        this.nRD = new PortStdLogic1164(this, "nRD", 0, null);
        this.nWR = new PortStdLogic1164(this, "nWR", 0, null);
        this.CnD = new PortStdLogic1164(this, "CnD", 0, null);
        this.RESET = new PortStdLogic1164(this, "RESET", 0, null);
        this.nDDRIVE = new PortStdLogic1164(this, "nDDRIVE", 1, null);
        this.nDSR = new PortStdLogic1164(this, "nDSR", 0, null);
        this.nDTR = new PortStdLogic1164(this, "nDTR", 1, null);
        this.nCTS = new PortStdLogic1164(this, "nCTS", 0, null);
        this.nRTS = new PortStdLogic1164(this, "nRTS", 1, null);
        this.TXD = new PortStdLogic1164(this, "TXD", 1, null);
        this.TXRDY = new PortStdLogic1164(this, "TXRDY", 1, null);
        this.TXE = new PortStdLogic1164(this, "TXE", 1, null);
        this.nTXC = new PortStdLogic1164(this, "nTXC", 0, null);
        this.RXD = new PortStdLogic1164(this, "RXD", 0, null);
        this.RXRDY = new PortStdLogic1164(this, "RXRDY", 1, null);
        this.nRXC = new PortStdLogic1164(this, "nRXC", 0, null);
        this.SYNDET = new PortStdLogic1164(this, "SYNDET", 2, null);
        this.DATA = new PortStdLogicVector((SimObject)this, "DATA", 2, null, this.n_bits);
        this.ports = new Port[]{this.nCS, this.nRD, this.nWR, this.CnD, this.RESET, this.nDDRIVE, this.nDSR, this.nDTR, this.nCTS, this.nRTS, this.TXD, this.TXRDY, this.TXE, this.nTXC, this.RXD, this.RXRDY, this.nRXC, this.SYNDET, this.DATA};
        this.nRXC.setHandler(this.receiver);
        this.nTXC.setHandler(this.transmitter);
        this.nCTS.setHandler(this.ctshandler);
        this.vector_ZZZ = new StdLogicVector(this.n_bits, Const1164.__Z);
        this.vector_XXX = new StdLogicVector(this.n_bits, Const1164.__X);
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        this.transmitter.setSimulator(this.simulator);
        this.receiver.setSimulator(this.simulator);
        this.invalidate();
    }

    public void evaluate(Object arg) {
        try {
            Port tp = ((SimEvent)arg).getTargetPort();
            if (tp != this.nCS && tp != this.nRD && tp != this.nWR && tp != this.RESET) {
                return;
            }
            StdLogic1164 reset = this.RESET.getValueOrU();
            if (reset.is_1H()) {
                this.reset();
                return;
            }
            if (!reset.is_0L()) {
                this.invalidate();
                return;
            }
            StdLogic1164 chipSelect = this.nCS.getValueOrU();
            if (chipSelect.is_1H()) {
                return;
            }
            if (!chipSelect.is_0L()) {
                this.invalidate();
                return;
            }
            StdLogic1164 value_nRD = this.nRD.getValueOrU();
            StdLogic1164 value_nWR = this.nWR.getValueOrU();
            StdLogic1164 value_CnD = this.CnD.getValueOrU();
            SignalStdLogic1164 signal_nWR = (SignalStdLogic1164)this.nWR.getSignal();
            if (value_nRD.is_UXZ() || value_nWR.is_UXZ()) {
                this.dbg(".evaluate: nRD or nWR are undefined, invalidating!");
                this.invalidate();
                return;
            }
            if (value_nRD.is_0L() && value_nWR.is_0L()) {
                this.dbg(".evaluate: both nRD and nWR are low, invalidating!");
                this.invalidate();
                return;
            }
            if (signal_nWR != null && signal_nWR.hasRisingEdge()) {
                this.handleWriteCommand();
            } else if (signal_nWR != null && signal_nWR.hasFallingEdge() && value_CnD.is_0() && this.state == 3) {
                this.statusRegister &= 0xFFFFFFFE;
                this.statusRegister &= 0xFFFFFFFB;
                this.schedule(this.TXE, this.value_0, this.simulator.getSimTime() + this.t_access);
                this.schedule(this.TXRDY, this.value_0, this.simulator.getSimTime() + this.t_access);
            } else if (value_nRD.is_0L()) {
                this.handleReadCommand();
            } else if (value_nRD.is_1H()) {
                this.schedule(this.DATA, this.vector_ZZZ, this.simulator.getSimTime() + this.t_access);
                this.schedule(this.nDDRIVE, this.value_1, this.simulator.getSimTime() + this.t_access);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void handleWriteCommand() {
        block14: {
            try {
                StdLogic1164 cnd = this.CnD.getValueOrU();
                if (cnd.is_UXZ()) {
                    this.dbg("USART.handleWriteCommand: address undefined. Ignored");
                    return;
                }
                int data = this.getData();
                if (data == -1) {
                    this.dbg("USART.handleWriteCommand: data undefined. Ignored");
                    return;
                }
                if (cnd.is_1()) {
                    switch (this.state) {
                        case 0: {
                            this.writeModeRegister(data & 0xFF);
                            if (this.isSyncMode()) {
                                this.setState(1);
                                break;
                            }
                            this.setState(3);
                            break;
                        }
                        case 1: {
                            this.setSync1Character(data & 0xFF);
                            if (this.isSyncModeSCS()) {
                                this.setState(2);
                                break;
                            }
                            this.setState(3);
                            break;
                        }
                        case 2: {
                            this.setSync2Character(data & 0xFF);
                            this.setState(3);
                            break;
                        }
                        case 3: {
                            this.writeCommandRegister(data & 0xFF);
                            break;
                        }
                        case 4: {
                            this.dbg("state=STATE_INVALID: reset required.");
                            Thread.dumpStack();
                            break;
                        }
                        default: {
                            Thread.dumpStack();
                        }
                    }
                    this.dbg("USART.handleWriteCommand: new state is " + this.state);
                    break block14;
                }
                this.transmitRegister = data & 0xFF;
                this.transmitter.setTransmitData(data & 0xFF);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void handleReadCommand() {
        try {
            double t = this.simulator.getSimTime() + this.t_access;
            StdLogic1164 cnd = this.CnD.getValueOrU();
            if (cnd.is_UXZ()) {
                this.dbg(".handleReadCommand: CnD undefined. Ignored");
                return;
            }
            int data = 0;
            if (cnd.is_1()) {
                this.updateStatusRegister();
                data = this.statusRegister;
            } else {
                data = this.receiveRegister;
                this.statusRegister &= 0xFFFFFFFD;
                this.schedule(this.RXRDY, Const1164.__0, t);
                this.receiver.setRxReceipt(true);
            }
            this.schedule(this.DATA, new StdLogicVector(this.n_bits, data), t);
            this.schedule(this.nDDRIVE, this.value_0, t);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void updateStatusRegister() {
        int mask = 58;
        this.statusRegister &= mask;
        StdLogic1164 dsr = this.nDSR.getValueOrU();
        StdLogic1164 syndet = this.SYNDET.getValueOrU();
        StdLogic1164 txempty = this.TXE.getValueOrU();
        if (syndet.is_1H()) {
            this.statusRegister |= 0x40;
        }
        if (txempty.is_1H()) {
            this.statusRegister |= 4;
        }
        if (dsr.is_0L()) {
            this.statusRegister |= 0x80;
        }
        this.dbg("-#- updateStatusRegister: " + HexFormat.getHexString(this.statusRegister & 0xFF, 2));
    }

    public void writeModeRegister(int value) {
        this.dbg("USART.writeModeRegister: " + HexFormat.getHexString(value, 2));
        this.modeRegister = value & 0xFF;
    }

    public void writeCommandRegister(int value) {
        this.dbg("USART.writeCommandRegister: " + HexFormat.getHexString(value, 2));
        this.commandRegister = value & 0xFF;
        if ((value & 0x10) != 0) {
            this.dbg("writeCommandRegister: performing error-reset");
            int mask = -57;
            this.statusRegister &= mask;
            this.receiver.setRxReceipt(true);
        }
        if ((value & 0x40) != 0) {
            this.dbg("writeCommandRegister: performing internal reset");
            this.state = 0;
            this.reset();
        }
        if ((value & 0x80) != 0) {
            throw new RuntimeException("Hunt-Mode not implemented. Ignored");
        }
        if ((value & 8) != 0) {
            this.transmitter.enterBreakMode();
        }
        double t0 = this.simulator.getSimTime() + this.t_access;
        this.schedule(this.nDTR, this.to1164((this.commandRegister & 2) == 0), t0);
        this.schedule(this.nRTS, this.to1164((this.commandRegister & 0x20) == 0), t0);
    }

    public void reset8251() {
        this.setState(0);
        this.transmitter.resetTransmitter();
    }

    public StdLogic1164 to1164(boolean b) {
        if (b) {
            return Const1164.__1;
        }
        return Const1164.__0;
    }

    public void setState(int value) {
        this.dbg("USART.setState: " + value);
        this.state = value;
    }

    public boolean isSyncMode() {
        return (this.modeRegister & 3) == 0;
    }

    public boolean isSyncModeSCS() {
        return this.isSyncMode() && (this.modeRegister & 0x80) == 128;
    }

    public int getPrescalerRate() {
        int tmp = this.modeRegister & 3;
        switch (tmp) {
            case 1: {
                return 1;
            }
            case 2: {
                return 16;
            }
            case 3: {
                return 64;
            }
        }
        throw new IllegalArgumentException("Prescaler rate: " + tmp);
    }

    public int getDataBitsCount() {
        int tmp = this.modeRegister & 0xC;
        switch (tmp) {
            case 0: {
                return 5;
            }
            case 4: {
                return 6;
            }
            case 8: {
                return 7;
            }
            case 12: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Data bits count: " + tmp);
    }

    public int getStopBitCount() {
        int tmp = this.modeRegister & 0xC0;
        switch (tmp) {
            case 0: {
                return 0;
            }
            case 64: {
                return 1;
            }
            case 192: {
                return 2;
            }
            case 128: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Stop bits count: " + tmp);
    }

    public boolean isReceiverEnabled() {
        return (this.commandRegister & 4) != 0;
    }

    public boolean isTransmitterEnabled() {
        return (this.commandRegister & 1) != 0;
    }

    public boolean isSendBreakMode() {
        return (this.commandRegister & 8) != 0;
    }

    public boolean isParityEnabled() {
        return (this.modeRegister & 0x10) != 0;
    }

    public boolean isEvenParityEnabled() {
        return (this.modeRegister & 0x30) == 48;
    }

    public boolean isOddParityEnabled() {
        return (this.modeRegister & 0x30) == 16;
    }

    public boolean getOddParity(int txchar) {
        int data = txchar & 0xFF;
        int mask = 1;
        boolean odd = false;
        int i = 0;
        while (i < 8) {
            if ((data & mask) != 0) {
                odd = !odd;
            }
            mask <<= 1;
            ++i;
        }
        this.dbg("getOddParity: " + HexFormat.getHexString(txchar, 2) + " " + odd);
        return odd;
    }

    public void reset() {
        double time = this.simulator.getSimTime();
        this.state = 0;
        this.modeRegister = 205;
        this.commandRegister = 38;
        this.statusRegister = 4;
        this.schedule(this.TXD, this.value_1, time + this.t_access);
        this.schedule(this.TXRDY, this.value_0, time + this.t_access);
        this.schedule(this.TXE, this.value_1, time + this.t_access);
        this.schedule(this.RXRDY, this.value_0, time + this.t_access);
        this.schedule(this.nDTR, this.value_0, time + this.t_access);
        this.schedule(this.nRTS, this.value_0, time + this.t_access);
        this.schedule(this.DATA, this.vector_ZZZ, time + this.t_access);
        this.schedule(this.nDDRIVE, this.value_1, time + this.t_access);
    }

    public void invalidate() {
        this.dbg("USART.invalidate");
        this.modeRegister = -1;
        this.commandRegister = -1;
        this.statusRegister = 4;
        this.updateStatusRegister();
        double time = this.simulator.getSimTime();
        this.schedule(this.TXD, this.value_X, time + this.t_access);
        this.schedule(this.TXRDY, this.value_X, time + this.t_access);
        this.schedule(this.TXE, this.value_X, time + this.t_access);
        this.schedule(this.RXRDY, this.value_X, time + this.t_access);
        this.schedule(this.nDTR, this.value_X, time + this.t_access);
        this.schedule(this.nRTS, this.value_X, time + this.t_access);
        this.schedule(this.DATA, this.vector_XXX, time + this.t_access);
        this.schedule(this.nDDRIVE, this.value_1, time + this.t_access);
    }

    public boolean[] getDataBits(int c, int n_databits) {
        boolean[] databits = new boolean[n_databits];
        int mask = c;
        int i = 0;
        while (i < n_databits) {
            databits[i] = (mask & 1) > 0;
            mask >>>= 1;
            ++i;
        }
        return databits;
    }

    public boolean getParityBit(boolean[] databits, boolean even_parity) {
        boolean parity = false;
        int i = 0;
        while (i < databits.length) {
            if (databits[i]) {
                parity = !parity;
            }
            ++i;
        }
        if (even_parity) {
            parity = !parity;
        }
        return parity;
    }

    public StdLogic1164 getRegisterBitAs1164(int reg, int index) {
        if ((reg & 1 << index) != 0) {
            return this.value_1;
        }
        return this.value_0;
    }

    public void schedule(Port port, Object value, double time) {
        Signal s = port.getSignal();
        if (s == null) {
            return;
        }
        this.simulator.scheduleEvent(new SimEvent(s, time, value, port));
    }

    public int getData() {
        StdLogicVector v = this.DATA.getVectorOrUUU();
        if (v.has_UXZ()) {
            return -1;
        }
        return (int)(v.getValue() & 0xFFL);
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            if (st.hasMoreTokens()) {
                this.versionId = Integer.parseInt(st.nextToken());
            }
            if (st.hasMoreTokens()) {
                this.n_bits = Integer.parseInt(st.nextToken());
                this.constructStandardValues();
                this.constructPorts();
            }
            if (st.hasMoreTokens()) {
                this.setDebugFlags(Integer.parseInt(st.nextToken()));
            }
            if (st.hasMoreTokens()) {
                this.t_access = Double.valueOf(st.nextToken());
            }
        }
        catch (Exception e) {
            this.message("-E- USART8251.initialize(): " + e + " " + s);
            e.printStackTrace();
        }
        return true;
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.n_bits + " " + this.debugFlags + " " + this.t_access);
    }

    public int getModeRegister() {
        return this.modeRegister;
    }

    public int getCommandRegister() {
        return this.commandRegister;
    }

    public int getTransmitRegister() {
        return this.transmitRegister;
    }

    public int getReceiveRegister() {
        return this.receiveRegister;
    }

    public int getStatusRegister() {
        return this.statusRegister;
    }

    public int getSync1Character() {
        return this.sync1Character;
    }

    public int getSync2Character() {
        return this.sync2Character;
    }

    public int getDebugFlags() {
        return this.debugFlags;
    }

    public void setModeRegister(int v) {
        this.modeRegister = v & 0xFF;
    }

    public void setCommandRegister(int v) {
        this.commandRegister = v & 0xFF;
    }

    public void setTransmitRegister(int v) {
        this.transmitRegister = v & 0xFF;
    }

    public void setReceiveRegister(int v) {
        this.receiveRegister = v & 0xFF;
    }

    public void setStatusRegister(int v) {
        this.statusRegister = v & 0xFF;
    }

    public void setSync1Character(int v) {
        this.sync1Character = v & 0xFF;
    }

    public void setSync2Character(int v) {
        this.sync2Character = v & 0xFF;
    }

    public void setDebugFlags(int v) {
        this.debugFlags = v;
    }

    public void setModeRegister(String s) {
        this.setModeRegister(this._stoi(s));
    }

    public void setCommandRegister(String s) {
        this.setCommandRegister(this._stoi(s));
    }

    public void setTransmitRegister(String s) {
        this.setTransmitRegister(this._stoi(s));
    }

    public void setReceiveRegister(String s) {
        this.setReceiveRegister(this._stoi(s));
    }

    public void setStatusRegister(String s) {
        this.setStatusRegister(this._stoi(s));
    }

    public void setSync1Character(String s) {
        this.setSync1Character(this._stoi(s));
    }

    public void setSync2Character(String s) {
        this.setSync2Character(this._stoi(s));
    }

    public void setDebugFlags(String s) {
        this.setDebugFlags(this._stoi(s));
    }

    private int _stoi(String s) {
        try {
            StdLogicVector v = new StdLogicVector(this.n_bits, 0L);
            v.parse(s);
            int i = (int)v.getValue();
            return i;
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            return 0;
        }
    }

    public void configure() {
        String[] fields = new String[]{"instance name:", "name", "data bus width: [8 .. 32]:", "width", "mode register", "modeRegister", "command register", "commandRegister", "status register", "statusRegister", "transmit buffer", "transmitRegister", "receive buffer", "receiveRegister", "sync character 1", "sync1Character", "sync character 2", "sync2Character", "debug flags", "debugFlags"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, data bus width,\nand register values\n");
        this.propertySheet.setVisible(true);
    }

    public void dbg(String s) {
        if (this.debugFlags == 1) {
            System.out.println("-#- " + this.getName() + ": " + s);
        }
    }

    public String getToolTip(Point position, long millis) {
        return this.getName() + "\n" + this.getClass().getName() + "\n" + "mode: " + this.getDataBitsCount() + (this.isEvenParityEnabled() ? "E" : (this.isOddParityEnabled() ? "O" : "N")) + this.getStopBitCount() + " " + (this.isSyncMode() ? "SYNC" : "ASYNC x" + this.getPrescalerRate()) + "\n" + "txchar: " + Integer.toHexString(this.transmitter.txchar);
    }

    class CTSHandler
    extends SimObject {
        public void evaluate(SimEvent event) {
            StdLogic1164 tmp = USART8251.this.nCTS.getValueOrU();
            if (tmp.is_0L()) {
                if (USART8251.this.isTransmitterEnabled() && USART8251.this.transmitter.isIdleState() && USART8251.this.transmitter.isEmpty()) {
                    USART8251.this.schedule(USART8251.this.TXE, Const1164.__1, this.simulator.getSimTime() + USART8251.this.t_access);
                } else {
                    USART8251.this.schedule(USART8251.this.TXE, Const1164.__0, this.simulator.getSimTime() + USART8251.this.t_access);
                }
            } else if (tmp.is_1H()) {
                USART8251.this.schedule(USART8251.this.TXE, Const1164.__0, this.simulator.getSimTime() + USART8251.this.t_access);
            } else {
                USART8251.this.schedule(USART8251.this.TXE, Const1164.__X, this.simulator.getSimTime() + USART8251.this.t_access);
            }
        }
    }

    class Receiver
    extends SimObject {
        int rxstate = 20;
        int prescaler;
        int rxtmp = -1;
        int rxbuffer = -1;
        boolean rxreceipt = false;

        public void elaborate(Object arg) {
            Thread.dumpStack();
        }

        public void evaluate(Object arg) {
            StdLogic1164 clock = USART8251.this.nRXC.getValueOrU();
            if (clock.is_1H()) {
                if (!USART8251.this.isReceiverEnabled()) {
                    this.rxbuffer = -1;
                    this.rxstate = 20;
                    return;
                }
                if (this.rxstate == 20) {
                    StdLogic1164 data = USART8251.this.RXD.getValueOrU();
                    if (data.is_0L()) {
                        USART8251.this.dbg("Receiver: detected startbit  at t=" + TimeFormatter.format(this.simulator.getSimTime()));
                        this.prescaler = USART8251.this.getPrescalerRate();
                        if (this.prescaler > 1) {
                            this.rxstate = 21;
                            this.rxtmp = 0;
                        } else {
                            this.rxstate = 23;
                            this.rxtmp = 0;
                        }
                        USART8251.this.statusRegister &= 0xFFFFFFFD;
                        USART8251.this.schedule(USART8251.this.RXRDY, Const1164.__0, this.simulator.getSimTime() + USART8251.this.t_access);
                    }
                } else {
                    --this.prescaler;
                    if (this.prescaler == USART8251.this.getPrescalerRate() / 2) {
                        this.sampleRXD();
                    }
                    if (this.prescaler <= 0) {
                        this.prescaler = USART8251.this.getPrescalerRate();
                    }
                    if (this.prescaler > USART8251.this.getPrescalerRate()) {
                        USART8251.this.dbg("Receiver: adjusting prescaler to new limit: " + this.prescaler + " " + USART8251.this.getPrescalerRate());
                        this.prescaler = USART8251.this.getPrescalerRate();
                    }
                }
            }
        }

        public void sampleRXD() {
            StdLogic1164 data = USART8251.this.RXD.getValueOrU();
            double now = this.simulator.getSimTime();
            switch (this.rxstate) {
                case 20: {
                    USART8251.this.dbg("Receiver.sampleRXD: state is IDLE. Internal error!");
                    break;
                }
                case 21: {
                    if (data.is_0L()) {
                        USART8251.this.dbg("Receiver: confirmed startbit at t=" + TimeFormatter.format(now));
                        this.rxstate = 23;
                        break;
                    }
                    USART8251.this.dbg("Receiver: failed to confirm startbit at t=" + TimeFormatter.format(now));
                    USART8251.this.statusRegister |= 0x20;
                    this.rxstate = 20;
                    break;
                }
                case 23: {
                    if (data.is_1H()) {
                        ++this.rxtmp;
                    }
                    this.rxstate = 24;
                    break;
                }
                case 24: {
                    if (data.is_1H()) {
                        this.rxtmp += 2;
                    }
                    this.rxstate = 25;
                    break;
                }
                case 25: {
                    if (data.is_1H()) {
                        this.rxtmp += 4;
                    }
                    this.rxstate = 26;
                    break;
                }
                case 26: {
                    if (data.is_1H()) {
                        this.rxtmp += 8;
                    }
                    this.rxstate = 27;
                    break;
                }
                case 27: {
                    if (data.is_1H()) {
                        this.rxtmp += 16;
                    }
                    if (USART8251.this.getDataBitsCount() == 5) {
                        this.rxstate = this.checkParityMode();
                        break;
                    }
                    this.rxstate = 28;
                    break;
                }
                case 28: {
                    if (data.is_1H()) {
                        this.rxtmp += 32;
                    }
                    if (USART8251.this.getDataBitsCount() == 6) {
                        this.rxstate = this.checkParityMode();
                        break;
                    }
                    this.rxstate = 29;
                    break;
                }
                case 29: {
                    if (data.is_1H()) {
                        this.rxtmp += 64;
                    }
                    if (USART8251.this.getDataBitsCount() == 7) {
                        this.rxstate = this.checkParityMode();
                        break;
                    }
                    this.rxstate = 30;
                    break;
                }
                case 30: {
                    if (data.is_1H()) {
                        this.rxtmp += 128;
                    }
                    this.rxstate = this.checkParityMode();
                    break;
                }
                case 33: {
                    boolean even;
                    boolean bit = data.is_1H();
                    boolean bl = even = !USART8251.this.getOddParity(this.rxtmp);
                    if (even != bit) {
                        USART8251.this.statusRegister |= 8;
                        USART8251.this.dbg("Receiver: even parity check failed, char=" + HexFormat.getHexString(this.rxtmp, 2) + " parity= " + data);
                    } else {
                        USART8251.this.dbg("Receiver: even parity ok     at t=" + TimeFormatter.format(now));
                    }
                    this.rxstate = 31;
                    break;
                }
                case 34: {
                    if (data.is_1H() != USART8251.this.getOddParity(this.rxtmp)) {
                        USART8251.this.statusRegister |= 8;
                        USART8251.this.dbg("-W- receiver: odd parity check failed, char=" + HexFormat.getHexString(this.rxtmp, 2) + " parity= " + data);
                    } else {
                        USART8251.this.dbg("Receiver: odd parity ok      at t=" + TimeFormatter.format(now));
                    }
                    this.rxstate = 31;
                    break;
                }
                case 31: {
                    if (!data.is_1H()) {
                        USART8251.this.statusRegister |= 0x20;
                        USART8251.this.dbg("Receiver: frame error        at t=" + TimeFormatter.format(now));
                    }
                    if (this.rxbuffer != -1 && !this.rxreceipt) {
                        USART8251.this.statusRegister |= 0x10;
                        USART8251.this.dbg("Receiver: data overrun       at t=" + TimeFormatter.format(now));
                    }
                    this.rxbuffer = this.rxtmp;
                    USART8251.this.receiveRegister = this.rxtmp & 0xFF;
                    this.rxreceipt = false;
                    USART8251.this.dbg("Receiver: received char= 0x" + HexFormat.getHexString(this.rxtmp, 2));
                    USART8251.this.statusRegister |= 2;
                    USART8251.this.schedule(USART8251.this.RXRDY, Const1164.__1, now + USART8251.this.t_access);
                    this.rxstate = 20;
                    break;
                }
                default: {
                    USART8251.this.dbg("Receiver.sampleRXD: unknown state: " + this.rxstate);
                }
            }
        }

        public int checkParityMode() {
            int _rxstate = USART8251.this.isEvenParityEnabled() ? 33 : (USART8251.this.isOddParityEnabled() ? 34 : 31);
            return _rxstate;
        }

        public void setRxReceipt(boolean b) {
            this.rxreceipt = b;
        }
    }

    class Transmitter
    extends SimObject {
        int txstate;
        int prescaler;
        int txchar;
        int txbuffer;

        public Transmitter() {
            this.resetTransmitter();
        }

        public void setTransmitData(int value) {
            if (!this.isEmpty()) {
                USART8251.this.dbg("Transmitter.setTransmitData overrun at t=" + TimeFormatter.format(this.simulator.getSimTime()));
                USART8251.this.dbg("The new data value '" + HexFormat.getHexString(value, 2) + "' is ignored and lost.");
                return;
            }
            this.txbuffer = value & 0xFF;
            USART8251.this.dbg("Transmitter: setTransmitData at t= " + TimeFormatter.format(this.simulator.getSimTime()));
            USART8251.this.dbg("Transmitter: transmitting char= 0x" + HexFormat.getHexString(this.txbuffer, 2));
        }

        public void resetTransmitter() {
            this.txstate = 0;
            this.txchar = -1;
            this.txbuffer = -1;
            if (this.simulator != null) {
                double t0 = this.simulator.getSimTime() + USART8251.this.t_access;
                USART8251.this.schedule(USART8251.this.TXD, Const1164.__1, t0);
                USART8251.this.schedule(USART8251.this.TXRDY, Const1164.__1, t0);
                USART8251.this.schedule(USART8251.this.TXE, Const1164.__1, t0);
            }
        }

        public void enterBreakMode() {
            this.txstate = 99;
            if (this.simulator != null) {
                double t0 = this.simulator.getSimTime() + USART8251.this.t_access;
                USART8251.this.schedule(USART8251.this.TXD, Const1164.__0, t0);
            }
        }

        public boolean isEmpty() {
            return this.txbuffer == -1;
        }

        public boolean isIdleState() {
            return this.txstate == 0;
        }

        public void elaborate(Object arg) {
            Thread.dumpStack();
            this.prescaler = 0;
            this.txstate = 0;
        }

        public void evaluate(Object arg) {
            SignalStdLogic1164 stxc = (SignalStdLogic1164)USART8251.this.nTXC.getSignal();
            if (stxc != null && stxc.hasFallingEdge()) {
                if (this.txstate == 14) {
                    if (USART8251.this.nCTS.getValueOrU().is_0L()) {
                        this.txstate = 1;
                        this.prescaler = 1;
                    }
                } else if (this.txstate == 0) {
                    this.sendOneBit();
                } else {
                    --this.prescaler;
                    if (this.prescaler <= 0) {
                        this.prescaler = USART8251.this.getPrescalerRate();
                        this.sendOneBit();
                    }
                    if (this.prescaler > USART8251.this.getPrescalerRate()) {
                        USART8251.this.dbg("Transmitter: adjusting prescaler to new limit: " + this.prescaler + " " + USART8251.this.getPrescalerRate());
                        this.prescaler = USART8251.this.getPrescalerRate();
                    }
                }
            }
        }

        public void sendOneBit() {
            double t0 = this.simulator.getSimTime() + USART8251.this.t_access;
            switch (this.txstate) {
                case 99: {
                    if (USART8251.this.isSendBreakMode()) break;
                    this.txstate = 0;
                    USART8251.this.schedule(USART8251.this.TXD, Const1164.__1, t0);
                    break;
                }
                case 0: {
                    if (!USART8251.this.isTransmitterEnabled()) break;
                    if (this.isEmpty()) {
                        this.txstate = 0;
                        break;
                    }
                    if (USART8251.this.nCTS.getValueOrU().is_0L()) {
                        this.txstate = 1;
                        this.prescaler = 1;
                        break;
                    }
                    this.txstate = 14;
                    break;
                }
                case 14: {
                    this.txstate = 1;
                    break;
                }
                case 1: {
                    this.txchar = this.txbuffer;
                    this.txbuffer = -1;
                    USART8251.this.schedule(USART8251.this.TXD, Const1164.__0, t0);
                    USART8251.this.schedule(USART8251.this.TXRDY, Const1164.__1, t0);
                    this.txstate = 2;
                    break;
                }
                case 2: {
                    USART8251.this.schedule(USART8251.this.TXD, USART8251.this.to1164((this.txchar & 1) != 0), t0);
                    this.txstate = 3;
                    break;
                }
                case 3: {
                    USART8251.this.schedule(USART8251.this.TXD, USART8251.this.to1164((this.txchar & 2) != 0), t0);
                    this.txstate = 4;
                    break;
                }
                case 4: {
                    USART8251.this.schedule(USART8251.this.TXD, USART8251.this.to1164((this.txchar & 4) != 0), t0);
                    this.txstate = 5;
                    break;
                }
                case 5: {
                    USART8251.this.schedule(USART8251.this.TXD, USART8251.this.to1164((this.txchar & 8) != 0), t0);
                    this.txstate = 6;
                    break;
                }
                case 6: {
                    USART8251.this.schedule(USART8251.this.TXD, USART8251.this.to1164((this.txchar & 0x10) != 0), t0);
                    if (USART8251.this.getDataBitsCount() == 5) {
                        this.txstate = this.checkParityMode();
                        break;
                    }
                    this.txstate = 7;
                    break;
                }
                case 7: {
                    USART8251.this.schedule(USART8251.this.TXD, USART8251.this.to1164((this.txchar & 0x20) != 0), t0);
                    if (USART8251.this.getDataBitsCount() == 6) {
                        this.txstate = this.checkParityMode();
                        break;
                    }
                    this.txstate = 8;
                    break;
                }
                case 8: {
                    USART8251.this.schedule(USART8251.this.TXD, USART8251.this.to1164((this.txchar & 0x40) != 0), t0);
                    if (USART8251.this.getDataBitsCount() == 7) {
                        this.txstate = this.checkParityMode();
                        break;
                    }
                    this.txstate = 9;
                    break;
                }
                case 9: {
                    USART8251.this.schedule(USART8251.this.TXD, USART8251.this.to1164((this.txchar & 0x80) != 0), t0);
                    this.txstate = this.checkParityMode();
                    break;
                }
                case 12: {
                    USART8251.this.schedule(USART8251.this.TXD, USART8251.this.to1164(!USART8251.this.getOddParity(this.txchar)), t0);
                    this.txstate = 10;
                    break;
                }
                case 13: {
                    USART8251.this.schedule(USART8251.this.TXD, USART8251.this.to1164(USART8251.this.getOddParity(this.txchar)), t0);
                    this.txstate = 10;
                    break;
                }
                case 10: {
                    USART8251.this.schedule(USART8251.this.TXD, Const1164.__1, t0);
                    USART8251.this.statusRegister |= 4;
                    if (USART8251.this.isTransmitterEnabled() && USART8251.this.nCTS.getValueOrU().isLow_0L() && this.isEmpty()) {
                        USART8251.this.schedule(USART8251.this.TXE, Const1164.__1, t0);
                    }
                    if (USART8251.this.getStopBitCount() > 1) {
                        this.txstate = 11;
                        break;
                    }
                    this.txstate = 0;
                    break;
                }
                case 11: {
                    USART8251.this.schedule(USART8251.this.TXD, Const1164.__1, t0);
                    this.txstate = 0;
                    break;
                }
                default: {
                    USART8251.this.dbg("Transmitter.sendOneBit: unknown state: " + this.txstate);
                }
            }
        }

        public int checkParityMode() {
            int _txstate = USART8251.this.isEvenParityEnabled() ? 12 : (USART8251.this.isOddParityEnabled() ? 13 : 10);
            return _txstate;
        }
    }
}

