/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.memory;

import hades.gui.MemoryEditorFrame;
import hades.models.PortStdLogic1164;
import hades.models.PortStdLogicVector;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.rtlib.memory.GenericMemory;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimObject;
import hades.simulator.Wakeable;

public class RealTimeClock
extends GenericMemory
implements Wakeable {
    protected PortStdLogicVector port_A;
    protected PortStdLogicVector port_DIN;
    protected PortStdLogicVector port_DOUT;
    protected PortStdLogic1164 port_nWE;
    protected PortStdLogic1164 port_nCS;
    protected PortStdLogic1164 port_nOE;
    public static final double t_access = 3.0E-8;
    public static final double t_tristate = 5.0E-9;
    public static final double t_undefined = 6.0E-9;
    public static final double t_setup = 6.0E-9;
    public static final double t_min_we_cycle = 6.0E-9;
    protected double t_tick = 0.01;
    public static final int ADDR_MILLIS = 0;
    public static final int ADDR_SECOND = 1;
    public static final int ADDR_MINUTE = 2;
    public static final int ADDR_HOUR = 3;
    public static final int ADDR_DAY = 4;
    public static final int ADDR_MONTH = 5;
    public static final int ADDR_YEAR = 6;
    public static final int[] limits = new int[]{999, 59, 59, 23, 31, 11, 65535};

    public RealTimeClock() {
        this.n_bits = 16;
        this.n_words = 8;
        this.constructStandardValues();
        this.createMemory();
        this.initializeWithZeroes();
        this.constructPorts();
    }

    protected void constructPorts() {
        this.port_A = new PortStdLogicVector((SimObject)this, "A", 0, null, this.getAddressBusWidth());
        this.port_DIN = new PortStdLogicVector((SimObject)this, "DIN", 0, null, this.n_bits);
        this.port_DOUT = new PortStdLogicVector((SimObject)this, "DOUT", 1, null, this.n_bits);
        this.port_nWE = new PortStdLogic1164(this, "nWE", 0, null);
        this.port_nCS = new PortStdLogic1164(this, "nCS", 0, null);
        this.port_nOE = new PortStdLogic1164(this, "nOE", 0, null);
        this.ports = new Port[6];
        this.ports[0] = this.port_A;
        this.ports[1] = this.port_DIN;
        this.ports[2] = this.port_DOUT;
        this.ports[3] = this.port_nWE;
        this.ports[4] = this.port_nCS;
        this.ports[5] = this.port_nOE;
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        if (this.getDataAt(3) == -1L) {
            this.initializeWithZeroes();
        }
        if (this.simulator != null && this.port_DOUT.getSignal() != null) {
            this.simulator.scheduleEvent(new SimEvent(this.port_DOUT.getSignal(), 0.0, this.vector_UUU.copy(), this.port_DOUT));
        }
        if (this.simulator != null) {
            this.simulator.scheduleWakeup(this, 0.0 + this.t_tick, this);
        }
    }

    public void wakeup(Object arg) {
        if (SimObject.debug) {
            System.err.println("-#-" + this.toString() + ".wakeup: " + arg);
        }
        int millis = (int)this.getDataAt(0);
        int second = (int)this.getDataAt(1);
        int minute = (int)this.getDataAt(2);
        int hour = (int)this.getDataAt(3);
        int day = (int)this.getDataAt(4);
        int month = (int)this.getDataAt(5);
        int year = (int)this.getDataAt(6);
        if ((millis += (int)(1000.0 * this.t_tick)) > 999) {
            millis = 0;
            if (++second > 59) {
                second = 0;
                if (++minute > 59) {
                    minute = 0;
                    if (++hour > 23) {
                        hour = 0;
                        if (++day > 31) {
                            day = 0;
                            if (++month > 11) {
                                month = 0;
                                ++year;
                            }
                        }
                    }
                }
            }
        }
        this.setDataAt(6, year);
        this.setDataAt(5, month);
        this.setDataAt(4, day);
        this.setDataAt(3, hour);
        this.setDataAt(2, minute);
        this.setDataAt(1, second);
        this.setDataAt(0, millis);
        this.simulator.scheduleWakeup(this, this.simulator.getSimTime() + this.t_tick, this);
        this.notifyWriteListeners(0, millis, millis);
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        double time = this.simulator.getSimTime() + 3.0E-8;
        StdLogicVector vector_A = this.port_A.getVectorOrUUU();
        StdLogicVector vector_DIN = this.port_DIN.getVectorOrUUU();
        StdLogicVector vector_DOUT = null;
        StdLogic1164 value_nCS = this.port_nCS.getValueOrU();
        StdLogic1164 value_nOE = this.port_nOE.getValueOrU();
        StdLogic1164 value_nWE = this.port_nWE.getValueOrU();
        int addr = 0;
        long data = 0L;
        long old_data = 0L;
        if (!value_nCS.is_01()) {
            if (!value_nWE.is_1()) {
                this.message("-W- RealTimeClock: write enable active but chip select undefined: data would be lost. Ignored!");
            }
            vector_DOUT = this.vector_XXX.copy();
        } else if (value_nCS.is_1()) {
            vector_DOUT = this.vector_ZZZ.copy();
        } else if (!value_nWE.is_01()) {
            this.message("-W- RealTimeClock: chip select active but write enable active: data would be lost. Ignored!");
            vector_DOUT = value_nOE.is_1() ? this.vector_ZZZ.copy() : this.vector_XXX.copy();
        } else if (value_nWE.is_1()) {
            if (value_nOE.is_1()) {
                vector_DOUT = this.vector_ZZZ.copy();
            } else if (value_nOE.is_0()) {
                if (vector_A.has_UXZ()) {
                    this.message("-W- RealTimeClock: address undefined during read cycle");
                    vector_DOUT = this.vector_XXX.copy();
                } else {
                    addr = (int)vector_A.getValue();
                    data = this.getDataAt(addr);
                    vector_DOUT = new StdLogicVector(this.n_bits, data);
                    this.notifyReadListeners(addr, data);
                }
            } else {
                this.message("-W- RealTimeClock: nOE undefined during read cycle");
                vector_DOUT = this.vector_XXX.copy();
            }
        } else if (value_nWE.is_0()) {
            if (vector_A.has_UXZ()) {
                this.message("-W- RealTimeClock: write enable active but address undefined: data would be lost. Ignored!");
            } else if (vector_DIN.has_UXZ()) {
                this.message("-W- RealTimeClock: write enable active but data input undefined: data would be lost. Ignored!");
            } else {
                addr = (int)vector_A.getValue();
                data = (int)vector_DIN.getValue();
                old_data = this.getDataAt(addr);
                this.setDataAt(addr, data);
                this.notifyWriteListeners(addr, old_data, data);
            }
            vector_DOUT = this.vector_ZZZ.copy();
        }
        Signal signal_DOUT = this.port_DOUT.getSignal();
        if (signal_DOUT != null) {
            this.simulator.scheduleEvent(new SimEvent(signal_DOUT, time, vector_DOUT, this.port_DOUT));
        }
    }

    public void configure() {
        if (this.MEF == null) {
            int n_lines = 8;
            this.MEF = new MemoryEditorFrame(this, n_lines, 1, "Edit " + this.getName() + " " + this.getClass().getName());
            this.addMemoryListener(this.MEF);
        }
        this.MEF.pack();
        this.MEF.setVisible(true);
    }
}

