/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.memory;

import hades.models.PortStdLogic1164;
import hades.models.PortStdLogicVector;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.rtlib.memory.GenericMemory;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimObject;

public class RAMoe
extends GenericMemory {
    protected PortStdLogicVector port_A;
    protected PortStdLogicVector port_DIN;
    protected PortStdLogicVector port_DOUT;
    protected PortStdLogic1164 port_nWE;
    protected PortStdLogic1164 port_nCS;
    protected PortStdLogic1164 port_nOE;
    public static final double t_access = 3.0E-8;
    public static final double t_tristate = 5.0E-9;
    public static final double t_undefined = 6.0E-9;
    public static final double t_setup = 6.0E-9;
    public static final double t_min_we_cycle = 6.0E-9;

    public RAMoe() {
        this.constructPorts();
    }

    protected void constructPorts() {
        this.port_A = new PortStdLogicVector((SimObject)this, "A", 0, null, this.getAddressBusWidth());
        this.port_DIN = new PortStdLogicVector((SimObject)this, "DIN", 0, null, this.n_bits);
        this.port_DOUT = new PortStdLogicVector((SimObject)this, "DOUT", 1, null, this.n_bits);
        this.port_nWE = new PortStdLogic1164(this, "nWE", 0, null);
        this.port_nCS = new PortStdLogic1164(this, "nCS", 0, null);
        this.port_nOE = new PortStdLogic1164(this, "nOE", 0, null);
        this.ports = new Port[6];
        this.ports[0] = this.port_A;
        this.ports[1] = this.port_DIN;
        this.ports[2] = this.port_DOUT;
        this.ports[3] = this.port_nWE;
        this.ports[4] = this.port_nCS;
        this.ports[5] = this.port_nOE;
    }

    public boolean canChangeSize() {
        return !this.isConnected();
    }

    public void setSize(int n_words) {
        this.resize(n_words, this.getBitsPerWord());
    }

    public void setBitsPerWord(int n_bits) {
        this.resize(this.getSize(), n_bits);
    }

    public boolean resize(int n_words, int n_bits) {
        this.n_words = n_words;
        this.n_bits = n_bits;
        this.data = new long[n_words];
        this.initializeWithZeroes();
        this.constructStandardValues();
        this.constructPorts();
        return true;
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        if (this.simulator != null && this.port_DOUT.getSignal() != null) {
            this.simulator.scheduleEvent(new SimEvent(this.port_DOUT.getSignal(), 0.0, this.vector_UUU.copy(), this.port_DOUT));
        }
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        double time = this.simulator.getSimTime() + 3.0E-8;
        StdLogicVector vector_A = this.port_A.getVectorOrUUU();
        StdLogicVector vector_DIN = this.port_DIN.getVectorOrUUU();
        StdLogicVector vector_DOUT = null;
        StdLogic1164 value_nCS = this.port_nCS.getValueOrU();
        StdLogic1164 value_nOE = this.port_nOE.getValueOrU();
        StdLogic1164 value_nWE = this.port_nWE.getValueOrU();
        int addr = 0;
        long data = 0L;
        long old_data = 0L;
        if (!value_nCS.is_01()) {
            if (!value_nWE.is_1()) {
                this.warning("-W- RAMoe: nCS and nWE undefined: data might be lost.");
                this.checkInvalidateMemory();
            }
            vector_DOUT = this.vector_XXX.copy();
        } else if (value_nCS.is_1()) {
            vector_DOUT = this.vector_ZZZ.copy();
        } else if (!value_nWE.is_01()) {
            this.warning("-W- RAMoe: nCS active but nWE undefined: data might be lost.");
            this.checkInvalidateMemory();
            vector_DOUT = value_nOE.is_1() ? this.vector_ZZZ.copy() : this.vector_XXX.copy();
        } else if (value_nWE.is_1()) {
            if (value_nOE.is_1()) {
                vector_DOUT = this.vector_ZZZ.copy();
            } else if (value_nOE.is_0()) {
                if (vector_A.has_UXZ()) {
                    this.warning("-W- RAMoe: address undefined during read cycle");
                    vector_DOUT = this.vector_XXX.copy();
                } else {
                    addr = (int)vector_A.getValue();
                    data = this.getDataAt(addr);
                    vector_DOUT = new StdLogicVector(this.n_bits, data);
                    this.notifyReadListeners(addr, data);
                }
            } else {
                this.warning("-W- RAMoe: nOE undefined during read cycle");
                vector_DOUT = this.vector_XXX.copy();
            }
        } else if (value_nWE.is_0()) {
            if (vector_A.has_UXZ()) {
                this.warning("-W- RAMoe: address undefined during write cycle: complete memory contents might be lost");
                this.checkInvalidateMemory();
            } else if (vector_DIN.has_UXZ()) {
                this.warning("-W- RAMoe: write enable active but data input undefined: addressed data is invalidated!");
                addr = (int)vector_A.getValue();
                data = this.vector_XXX.getValue();
                old_data = this.getDataAt(addr);
                this.setDataAt(addr, data);
                this.notifyWriteListeners(addr, old_data, data);
            } else {
                addr = (int)vector_A.getValue();
                data = vector_DIN.getValue();
                old_data = this.getDataAt(addr);
                this.setDataAt(addr, data);
                this.notifyWriteListeners(addr, old_data, data);
            }
            vector_DOUT = this.vector_ZZZ.copy();
        }
        Signal signal_DOUT = this.port_DOUT.getSignal();
        if (signal_DOUT != null) {
            this.simulator.scheduleEvent(new SimEvent(signal_DOUT, time, vector_DOUT, this.port_DOUT));
        }
    }
}

