/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.memory;

import hades.models.PortStdLogic1164;
import hades.models.PortStdLogicVector;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.rtlib.memory.GenericMemory;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimObject;

public class MipsRegBank
extends GenericMemory {
    protected PortStdLogicVector port_AR0;
    protected PortStdLogicVector port_AR1;
    protected PortStdLogicVector port_AW0;
    protected PortStdLogicVector port_DR0;
    protected PortStdLogicVector port_DR1;
    protected PortStdLogicVector port_DW0;
    protected PortStdLogic1164 port_nWE;
    protected PortStdLogic1164 port_nCS;
    public static final double t_access = 3.0E-8;
    public static final double t_tristate = 5.0E-9;
    public static final double t_undefined = 6.0E-9;
    public static final double t_setup = 6.0E-9;
    public static final double t_min_we_cycle = 6.0E-9;

    public MipsRegBank() {
        this.n_words = 32;
        this.n_bits = 32;
        this.constructPorts();
    }

    protected void constructPorts() {
        this.port_AR0 = new PortStdLogicVector((SimObject)this, "AR0", 0, null, this.getAddressBusWidth());
        this.port_AR1 = new PortStdLogicVector((SimObject)this, "AR1", 0, null, this.getAddressBusWidth());
        this.port_AW0 = new PortStdLogicVector((SimObject)this, "AW0", 0, null, this.getAddressBusWidth());
        this.port_DW0 = new PortStdLogicVector((SimObject)this, "DW0", 0, null, this.n_bits);
        this.port_DR0 = new PortStdLogicVector((SimObject)this, "DR0", 1, null, this.n_bits);
        this.port_DR1 = new PortStdLogicVector((SimObject)this, "DR1", 1, null, this.n_bits);
        this.port_nWE = new PortStdLogic1164(this, "nWE", 0, null);
        this.port_nCS = new PortStdLogic1164(this, "nCS", 0, null);
        this.ports = new Port[8];
        this.ports[0] = this.port_AR0;
        this.ports[1] = this.port_AR1;
        this.ports[2] = this.port_AW0;
        this.ports[3] = this.port_DR0;
        this.ports[4] = this.port_DR1;
        this.ports[5] = this.port_DW0;
        this.ports[6] = this.port_nWE;
        this.ports[7] = this.port_nCS;
    }

    public long getDataAt(int addr) {
        if (addr == 0) {
            return 0L;
        }
        return super.getDataAt(addr);
    }

    public void setDataAt(int addr, long data) {
        if (addr == 0) {
            super.setDataAt(addr, 0L);
        } else {
            super.setDataAt(addr, data);
        }
    }

    public boolean canChangeSize() {
        return false;
    }

    public void setSize(int n_words) {
        this.resize(n_words, this.getBitsPerWord());
    }

    public void setBitsPerWord(int n_bits) {
        this.resize(this.getSize(), n_bits);
    }

    public boolean resize(int n_words, int n_bits) {
        this.n_words = n_words;
        this.n_bits = n_bits;
        this.data = new long[n_words];
        this.initializeWithZeroes();
        this.constructStandardValues();
        this.constructPorts();
        return true;
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        if (this.simulator == null) {
            return;
        }
        if (this.port_DR0.getSignal() != null) {
            this.simulator.scheduleEvent(new SimEvent(this.port_DR0.getSignal(), 0.0, this.vector_UUU.copy(), this.port_DR0));
        }
        if (this.port_DR1.getSignal() != null) {
            this.simulator.scheduleEvent(new SimEvent(this.port_DR1.getSignal(), 0.0, this.vector_UUU.copy(), this.port_DR1));
        }
    }

    public void evaluate(Object arg) {
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        double time = this.simulator.getSimTime() + 3.0E-8;
        StdLogicVector vector_AR0 = this.port_AR0.getVectorOrUUU();
        StdLogicVector vector_AR1 = this.port_AR1.getVectorOrUUU();
        StdLogicVector vector_AW0 = this.port_AW0.getVectorOrUUU();
        StdLogicVector vector_DW0 = this.port_DW0.getVectorOrUUU();
        StdLogicVector vector_DR0 = null;
        StdLogicVector vector_DR1 = null;
        StdLogic1164 value_nCS = this.port_nCS.getValueOrU();
        StdLogic1164 value_nWE = this.port_nWE.getValueOrU();
        int addr0 = 0;
        int addr1 = 0;
        int addrw = 0;
        long data0 = 0L;
        long old_data0 = 0L;
        long data1 = 0L;
        long dataw = 0L;
        if (value_nCS.is_1()) {
            vector_DR0 = this.vector_ZZZ.copy();
            vector_DR1 = this.vector_ZZZ.copy();
        } else if (!value_nCS.is_0()) {
            vector_DR0 = this.vector_UUU.copy();
            vector_DR1 = this.vector_UUU.copy();
            if (!value_nWE.is_1()) {
                this.message("-E- MipsRegBank.evaluate(): write enable active but chip select undefined: data would be lost. Ignored!");
            }
        } else {
            if (vector_AR0.has_UXZ()) {
                vector_DR0 = this.vector_UUU.copy();
            } else {
                addr0 = (int)vector_AR0.getValue();
                data0 = this.getDataAt(addr0);
                vector_DR0 = new StdLogicVector(this.n_bits, data0);
            }
            if (vector_AR1.has_UXZ()) {
                vector_DR1 = this.vector_UUU.copy();
            } else {
                addr1 = (int)vector_AR1.getValue();
                data1 = this.getDataAt(addr1);
                vector_DR1 = new StdLogicVector(this.n_bits, data1);
            }
            if (value_nWE.is_0()) {
                if (vector_AW0.has_UXZ()) {
                    this.message("-E- MipsRegBank.evaluate(): write enable active but address undefined: data would be lost. Ignored!");
                    vector_DR0 = this.vector_UUU.copy();
                    vector_DR1 = this.vector_UUU.copy();
                } else if (vector_DW0.has_UXZ()) {
                    this.message("-E- MipsRegBank.evaluate(): write enable active but data undefined: data would be lost. Ignored!");
                    vector_DR0 = this.vector_UUU.copy();
                    vector_DR1 = this.vector_UUU.copy();
                } else {
                    addrw = (int)vector_AW0.getValue();
                    dataw = vector_DW0.getValue();
                    old_data0 = this.getDataAt(addrw);
                    this.setDataAt(addrw, dataw);
                    this.notifyWriteListeners(addrw, old_data0, dataw);
                }
            } else if (!value_nWE.is_1()) {
                this.message("-E- MipsRegBank.evaluate(): write enable undefined: data would be lost. Ignored!");
                vector_DR0 = this.vector_UUU.copy();
                vector_DR1 = this.vector_UUU.copy();
            }
        }
        Signal signal_DR0 = this.port_DR0.getSignal();
        Signal signal_DR1 = this.port_DR1.getSignal();
        if (signal_DR0 != null) {
            this.simulator.scheduleEvent(new SimEvent(signal_DR0, time, vector_DR0, this.port_DR0));
        }
        if (signal_DR1 != null) {
            this.simulator.scheduleEvent(new SimEvent(signal_DR1, time, vector_DR1, this.port_DR1));
        }
    }
}

