/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.memory;

import hades.gui.MemoryEditorFrame;
import hades.models.PortStdLogic1164;
import hades.models.PortStdLogicVector;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.rtlib.memory.GenericMemory;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent;
import hades.simulator.SimObject;

public class MicroROM
extends GenericMemory {
    protected PortStdLogicVector port_A;
    protected PortStdLogicVector port_X;
    protected PortStdLogicVector port_E;
    protected PortStdLogicVector port_F;
    protected PortStdLogicVector port_G;
    protected PortStdLogicVector port_H;
    protected PortStdLogic1164[] port_D;
    public static final double t_access = 3.0E-8;
    public static final double t_tristate = 5.0E-9;
    public static final double t_undefined = 6.0E-9;

    public MicroROM() {
        this.n_bits = 44;
        this.n_words = 4096;
        this.constructPorts();
        this.createMemory();
        this.initializeWithZeroes();
    }

    protected void constructPorts() {
        this.port_A = new PortStdLogicVector((SimObject)this, "A", 0, null, 12);
        this.port_X = new PortStdLogicVector((SimObject)this, "X", 1, null, 12);
        this.port_E = new PortStdLogicVector((SimObject)this, "E", 1, null, 4);
        this.port_F = new PortStdLogicVector((SimObject)this, "F", 1, null, 4);
        this.port_G = new PortStdLogicVector((SimObject)this, "G", 1, null, 4);
        this.port_H = new PortStdLogicVector((SimObject)this, "H", 1, null, 4);
        this.port_D = new PortStdLogic1164[16];
        int i = 0;
        while (i < 16) {
            this.port_D[i] = new PortStdLogic1164(this, "D" + i, 1, null);
            ++i;
        }
        this.ports = new Port[22];
        int i2 = 0;
        i2 = 0;
        while (i2 < 16) {
            this.ports[i2] = this.port_D[i2];
            ++i2;
        }
        this.ports[i2++] = this.port_E;
        this.ports[i2++] = this.port_F;
        this.ports[i2++] = this.port_G;
        this.ports[i2++] = this.port_H;
        this.ports[i2++] = this.port_X;
        this.ports[i2++] = this.port_A;
    }

    public boolean canChangeSize() {
        return !this.isConnected();
    }

    public void setSize(int n_words) {
        this.resize(n_words, this.getBitsPerWord());
    }

    public void setBitsPerWord(int n_bits) {
        this.resize(this.getSize(), n_bits);
    }

    public boolean resize(int n_words, int n_bits) {
        return true;
    }

    public void elaborate(Object arg) {
        if (SimObject.debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
    }

    public void evaluate(Object arg) {
        long data;
        int addr;
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        double time = this.simulator.getSimTime() + 3.0E-8;
        StdLogicVector vector_A = this.port_A.getVectorOrUUU();
        StdLogicVector vector_D = null;
        if (vector_A.has_UXZ()) {
            addr = -1;
            data = -1L;
            vector_D = new StdLogicVector(this.n_bits);
        } else {
            addr = (int)vector_A.getValue();
            data = this.getDataAt(addr);
            vector_D = new StdLogicVector(this.n_bits, data);
            this.notifyReadListeners(addr, data);
        }
        int i = 0;
        while (i < 16) {
            this.scheduleSingleOutput(this.port_D[i], vector_D.getBitAt(i), time);
            ++i;
        }
        this.schedulePortOutput(this.port_E, vector_D.subset(19, 16), time);
        this.schedulePortOutput(this.port_F, vector_D.subset(23, 20), time);
        this.schedulePortOutput(this.port_G, vector_D.subset(27, 24), time);
        this.schedulePortOutput(this.port_H, vector_D.subset(31, 28), time);
        this.schedulePortOutput(this.port_X, vector_D.subset(43, 32), time);
    }

    void scheduleSingleOutput(Port port, StdLogic1164 value, double time) {
        Signal signal = port.getSignal();
        if (signal == null) {
            return;
        }
        this.simulator.scheduleEvent(SimEvent.createNewSimEvent(signal, time, value, port));
    }

    void schedulePortOutput(Port port, StdLogicVector value, double time) {
        Signal signal = port.getSignal();
        if (signal == null) {
            return;
        }
        this.simulator.scheduleEvent(SimEvent.createNewSimEvent(signal, time, value, port));
    }

    public void configure() {
        if (this.MEF == null) {
            int n_lines = Math.min(this.n_words, 32);
            this.MEF = new MemoryEditorFrame(this, n_lines, 1, "Edit " + this.toString());
            this.addMemoryListener(this.MEF);
        }
        this.MEF.pack();
        this.MEF.setVisible(true);
    }
}

