/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.memory;

import hades.models.StdLogicVector;
import hades.models.rtlib.memory.MR;
import hades.models.rtlib.memory.MREditorFrame;
import hades.simulator.SimEvent;
import hades.utils.NameMangler;
import hades.utils.StringTokenizer;
import java.io.BufferedReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;

public class MRPIP2
extends MR {
    private int[] defaultValues;
    private static String[] d_names = new String[]{"unused", "unused", "unused", "retBUF.enable", "IRpre.enable", "IR_MUX", "RX_BUF.enable", "AX=15", "IR.enable", "ADDR_BUF.enable", "C.enable", "ALU_BUF.enable", "RegBank.nWE", "unused", "PC_BUF.enable", "PC.enable", "PC_MUX.s1", "PC_MUX.s0", "MRR_BUF.enable", "MDR.enable", "MDF_BUF.enable", "unused", "nWE", "nOE"};
    static String[] labels = new String[]{"      u u                                                                     ", "      P P                                                                     ", "      C C                               A       R         P P                 ", "      m m               R               D   A   E u       C C M     M u       ", "      u u  n  n         E   I I R A     D   L   G n P     m m R     D n       ", "      x x  e  e         T   R R X X     R   U   S u C     u u R     R u       ", "      . .  x  x         B   p m B =     B   B   n s B     x x B M   B s n n   ", "      S S  s  s         U   r u U 1   I U   U   w e U P   s s U D   U e W O   ", "addr  1 0  A  B         F   e x F 5   R F C F   e d F C   1 0 F R   F d E E   name"};

    public MRPIP2() {
        this.cache_read_addr = -1;
    }

    @Override
    public void setDSize() {
        this.D_SIZE = 24;
    }

    @Override
    public void createTypesAndFieldsAndMemory() {
        int i;
        this.n_words = 256;
        this.n_fields = 4 + this.D_SIZE;
        this.alabel = new String[this.n_words];
        this.flength = new int[this.n_fields];
        this.flabel = new String[this.n_fields];
        this.fseparator = new boolean[this.n_fields];
        int f = 0;
        this.createField(f++, 1, "umux.s1");
        this.createField(f++, 1, "umux.s0");
        this.createField(f++, 8, "nextA");
        this.createField(f++, 8, "nextB");
        for (int j = 0; j < this.D_SIZE; ++j) {
            this.createField(f++, 1, d_names[j]);
        }
        this.fdata = new int[this.n_words][this.n_fields];
        for (i = 0; i < this.n_words; ++i) {
            this.alabel[i] = "___" + i;
            this.fdata[i] = new int[this.n_fields];
        }
        this.defaultValues = new int[this.n_fields];
        for (i = 0; i < this.n_fields; ++i) {
            this.defaultValues[i] = 0;
        }
        this.defaultValues[9] = 1;
        this.defaultValues[13] = 1;
        this.defaultValues[16] = 1;
        this.defaultValues[26] = 1;
        this.defaultValues[27] = 1;
        this.createDefaultValues(this.defaultValues);
        this.initializeWithDefaultValues();
        this.fseparator[0] = true;
        this.fseparator[4] = true;
        this.fseparator[8] = true;
        this.fseparator[12] = true;
        this.fseparator[16] = true;
        this.fseparator[20] = true;
        this.fseparator[24] = true;
    }

    @Override
    public void createField(int index, int length, String name) {
        this.flength[index] = length;
        this.flabel[index] = name;
    }

    @Override
    public void setData(int addr, int field, int value) {
        this.fdata[addr][field] = value & lengthMask[this.flength[field]];
        this.cache_read_addr = -1;
    }

    @Override
    public boolean save(PrintWriter PW) {
        PW.println("#MicroROM data");
        PW.println("" + this.n_words + " " + this.n_fields);
        for (int f = 0; f < this.n_fields; ++f) {
            PW.print(NameMangler.encodeWithUnicodeEscapes(this.getFieldName(f)));
            PW.print(' ');
        }
        PW.println();
        PW.println("#       u u                                                                      \n#       P P                                                 P P                  \n#       C C                               A       R         C C                  \n#       m m               R               D   A   E u       M M M     M u        \n#       u u  n  n         E   I I R A     D   L   G n P     U U R     D n        \n#       x x  e  e         T   R R X X     R   U   . u C     X X R     R u        \n#       . .  x  x         B   p m B =     B   B   n s B     . . B M   B s n n    \n#       s s  t  t         U   r u U 1   I U   U   W e U P   s s U D   U e W O    \n#       1 0  A  B         F   e x F 5   R F C F   E d F C   1 0 F R   F d E E    \n#                                                                                  ");
        for (int addr = 0; addr < this.n_words; ++addr) {
            PW.print(this.getHexString(addr, 4));
            PW.print(": ");
            for (int f = 0; f < this.n_fields; ++f) {
                if (this.isSeparator(f)) {
                    PW.print("  ");
                }
                PW.print(this.getHexString(this.getData(addr, f), this.getFieldChars(f)));
                PW.print(' ');
            }
            PW.print(NameMangler.encodeWithUnicodeEscapes(this.getStateLabel(addr)));
            PW.println();
        }
        PW.flush();
        return false;
    }

    @Override
    public boolean parse(BufferedReader reader) throws Exception {
        if (reader == null) {
            return false;
        }
        String line = null;
        int addr = 0;
        LineNumberReader br = null;
        try {
            br = new LineNumberReader(reader);
            line = br.readLine();
            if (!line.startsWith("#MicroROM data")) {
                this.message("-E- Not a microcode data file! ");
                this.message("...expected '#MicroROM data' on line 1,");
                this.message("...but got '" + line + "'");
                return true;
            }
            line = br.readLine();
            this.n_words = 256;
            this.n_fields = 28;
            line = br.readLine();
            StringTokenizer st = new StringTokenizer(line);
            while ((line = br.readLine()) != null && line != null) {
                if (line.startsWith("#") || line.startsWith(";")) continue;
                st = new StringTokenizer(line, " \t\r:");
                addr = Integer.parseInt(st.nextToken(), 16);
                for (int f = 0; f < this.n_fields; ++f) {
                    this.setData(addr, f, Integer.parseInt(st.nextToken(), 16));
                }
                StringBuffer buff = new StringBuffer(st.restOfLine());
                if (buff.length() > 0 && buff.charAt(0) == ' ') {
                    buff.deleteCharAt(0);
                }
                this.setStateLabel(addr, NameMangler.decodeUnicodeEscapes(buff.toString()));
            }
        }
        catch (Exception e) {
            this.message("-E- Not a valid microcode file: " + e);
            if (br != null) {
                this.message("on line " + br.getLineNumber() + " '" + line + "'");
            }
            this.message("error near input '" + line + "'");
        }
        this.cache_read_addr = -1;
        return true;
    }

    @Override
    public void setDataAt(int address, long value) {
        super.setDataAt(address, value);
        this.cache_read_addr = -1;
    }

    @Override
    public void elaborate(Object arg) {
        if (debug) {
            this.message(this.toString() + ".elaborate()");
        }
        this.simulator = this.parent.getSimulator();
        this.cache_read_addr = -1;
    }

    @Override
    public void evaluate(Object arg) {
        int addr;
        if (debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        double time = this.simulator.getSimTime() + 3.0E-8;
        StdLogicVector vector_A = this.port_A.getVectorOrUUU();
        if (vector_A.has_UXZ()) {
            addr = -1;
            this.cache_read_addr = -12;
        } else {
            addr = (int)vector_A.getValue();
            this.notifyReadListeners(addr, 0L);
            for (int i = 0; i < this.D_SIZE; ++i) {
                int fi = 4 + this.D_SIZE - 1 - i;
                if (!this.checkChange(addr, fi)) continue;
                this.scheduleSingleOutput(this.port_D[i], this.getData(addr, fi), time);
            }
            if (this.checkChange(addr, 0)) {
                this.scheduleSingleOutput(this.port_S1, this.getData(addr, 0), time);
            }
            if (this.checkChange(addr, 1)) {
                this.scheduleSingleOutput(this.port_S0, this.getData(addr, 1), time);
            }
            if (this.checkChange(addr, 2)) {
                this.schedulePortOutput(this.port_X, this.getData(addr, 2), time);
            }
            if (this.checkChange(addr, 3)) {
                this.schedulePortOutput(this.port_Y, this.getData(addr, 3), time);
            }
            this.cache_read_addr = addr;
        }
        if (this.port_STATE.getSignal() != null) {
            this.simulator.scheduleEvent(new SimEvent(this.port_STATE.getSignal(), time, this.getStateLabel(addr), this.port_STATE));
        }
        if (this.enableAnimationFlag && this.symbol != null && this.symbol.painter != null) {
            this.symbol.painter.paint(this.symbol, 50);
        }
    }

    boolean checkChange(int addr, int field) {
        boolean b;
        if (this.cache_read_addr < 0) {
            b = true;
        } else {
            boolean bl = b = this.getData(addr, field) != this.getData(this.cache_read_addr, field);
        }
        if (debug) {
            System.out.println("-F- checkChange: " + addr + " " + this.cache_read_addr + " " + field + " " + b);
        }
        return b;
    }

    @Override
    public void configure() {
        if (this.MEF == null) {
            int n_lines = Math.min(this.n_words, 32);
            this.MEF = new MREditorFrame(this, n_lines, 1, "Edit " + this.getName() + " " + this.getClass().getName());
            this.addMemoryListener(this.MEF);
            this.MEF.setLabels(labels);
            System.out.println("configure");
            this.MEF.setAskBool(true);
        }
        this.config_rest();
        if (!this.readfailed) {
            this.MEF.setSaveMIEnabled(true);
            this.MEF.setReloadEnabled(true);
            this.MEF.setnewTitle(this.resourcename);
        }
    }
}

