/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.memory;

import hades.gui.CloseableFrame;
import hades.models.rtlib.memory.MR;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;
import jfig.utils.SetupManager;

public class MRLabelCanvas
extends JComponent {
    private int width;
    private int height;
    private int border_width;
    private int border_height;
    private int n_columns;
    private int n_rows;
    private int n_words;
    private int n_chars_per_addr;
    private int x0_data;
    private Font textFont;
    private int char_width;
    private int char_height;
    private static String[] labels = new String[]{"addr    A  B s1s0  A B C D   E F G H    I J K L     state name"};

    public MRLabelCanvas(String[] _labels, Component master) {
        labels = _labels;
        this.n_chars_per_addr = 5;
        this.prepareGUI();
        this.n_words = labels.length;
        this.n_rows = labels[0].length();
        this.width = master != null ? master.getMinimumSize().width : 400;
        this.height = labels.length * this.char_height + 2 * this.border_height;
    }

    public MRLabelCanvas(MR microRom, Component master) {
        try {
            this.n_chars_per_addr = this.getAddrFieldWidth(this.n_words);
            int n_fields = microRom.getNumberOfFields();
            int x0 = this.n_chars_per_addr + 2 + 1;
            int[] field_x = new int[n_fields + 1];
            int i = 0;
            while (i < n_fields) {
                if (microRom.isSeparator(i)) {
                    x0 += 2;
                }
                field_x[i] = x0;
                int field_chars = Math.max(1, microRom.getFieldBits(i) / 4);
                x0 += field_chars + 1;
                ++i;
            }
            field_x[n_fields] = x0 + 2;
            int label_x = field_x[n_fields];
            int len = 0;
            int i2 = 0;
            while (i2 < n_fields) {
                len = Math.max(len, microRom.getFieldName(i2).length());
                ++i2;
            }
            char[][] matrix = new char[label_x + 15][len];
            int i3 = 0;
            while (i3 < matrix.length) {
                int j = 0;
                while (j < matrix[i3].length) {
                    matrix[i3][j] = 32;
                    ++j;
                }
                ++i3;
            }
            int i4 = 0;
            while (i4 < n_fields) {
                String name = microRom.getFieldName(i4);
                int jj = len - name.length();
                int j = 0;
                while (j < name.length()) {
                    matrix[field_x[i4]][jj + j] = name.charAt(j);
                    ++j;
                }
                ++i4;
            }
            labels = new String[len];
            int j = 0;
            while (j < len) {
                StringBuffer sb = new StringBuffer();
                int i5 = 0;
                while (i5 < matrix.length) {
                    sb.append(matrix[i5][j]);
                    ++i5;
                }
                MRLabelCanvas.labels[j] = sb.toString();
                ++j;
            }
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        this.n_chars_per_addr = 5;
        this.prepareGUI();
        this.n_words = labels.length;
        this.n_rows = labels[0].length();
        this.width = master != null ? master.getMinimumSize().width : 400;
        this.height = labels.length * this.char_height + 2 * this.border_height;
    }

    public int getAddrFieldWidth(int n_words) {
        if (n_words > 0x10000000) {
            return 8;
        }
        if (n_words > 0x1000000) {
            return 7;
        }
        if (n_words > 0x100000) {
            return 6;
        }
        if (n_words > 65536) {
            return 5;
        }
        if (n_words > 4096) {
            return 4;
        }
        if (n_words > 256) {
            return 3;
        }
        if (n_words > 16) {
            return 2;
        }
        return 1;
    }

    protected void prepareGUI() {
        this.setBackground(Color.lightGray);
        String fontname = SetupManager.getProperty("Hades.MemoryHexEditorField.FontName", "Monospaced");
        int fontsize = SetupManager.getInteger("Hades.MemoryHexEditorField.FontSize", 12);
        int fontstyle = SetupManager.getInteger("Hades.MemoryHexEditorField.FontStyle", 0);
        this.setFont(new Font(fontname, fontstyle, fontsize));
    }

    public void setFont(Font f) {
        this.textFont = f;
        FontMetrics fm = this.getFontMetrics(this.textFont);
        this.char_width = fm.charWidth('M');
        this.char_height = fm.getMaxDescent() + fm.getMaxAscent();
        this.border_width = 5;
        this.border_height = 5;
        this.width = this.n_columns * this.char_width + 2 * this.border_width;
        this.height = this.n_rows * this.char_height + 2 * this.border_height;
        this.x0_data = this.border_width;
    }

    public void paintBackgroundAndBorder(Graphics g) {
        super.paint(g);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.textFont == null) {
            this.prepareGUI();
        }
        g.setFont(this.textFont);
        g.setColor(Color.darkGray);
        int y = this.border_height + this.char_height;
        int x = this.x0_data;
        int i = 0;
        while (i < labels.length) {
            g.drawString(labels[i], x, y);
            y += this.char_height;
            ++i;
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public static void msg(String s) {
        System.out.println(s);
    }

    public static void main(String[] argv) {
        MRLabelCanvas.msg("-I- MRLabelCanvas selftest started...");
        SetupManager.loadGlobalProperties("hades/.hadesrc");
        SetupManager.loadLocalProperties(".hadesrc");
        CloseableFrame f = new CloseableFrame();
        f.setSize(100, 100);
        f.setVisible(true);
        MRLabelCanvas canvas = new MRLabelCanvas(new MR(), null);
        f.add("Center", canvas);
        f.pack();
        System.out.println(canvas.getFont());
    }
}

