/*
 * Decompiled with CFR 0.152.
 */
package hades.models.rtlib.io;

import hades.gui.PropertySheet;
import hades.models.StdLogic1164;
import hades.models.StdLogicVector;
import hades.models.rtlib.GenericRtlibObject;
import hades.signals.Signal;
import hades.simulator.Port;
import hades.simulator.SimEvent1164;
import hades.simulator.SimKernel;
import hades.simulator.SimObject;
import hades.simulator.Simulatable;
import hades.symbols.Label;
import hades.symbols.Symbol;
import hades.utils.StringTokenizer;
import java.awt.Point;
import java.io.PrintWriter;

public class SelectBit
extends GenericRtlibObject {
    protected Port port_A;
    protected Port port_Y;
    protected StdLogicVector value_A;
    protected StdLogic1164 value_Y;
    protected Label indexLabel;
    protected int n_subset;
    protected int bitIndex = 0;
    static /* synthetic */ Class class$hades$signals$SignalStdLogicVector;
    static /* synthetic */ Class class$hades$signals$SignalStdLogic1164;

    public void constructPorts() {
        this.clipToBounds();
        this.ports = new Port[2];
        this.ports[0] = new Port(this, "A", 0, null, class$hades$signals$SignalStdLogicVector == null ? (class$hades$signals$SignalStdLogicVector = SelectBit.class$("hades.signals.SignalStdLogicVector")) : class$hades$signals$SignalStdLogicVector, new Integer(this.n_bits));
        this.ports[1] = new Port(this, "Y", 1, null, class$hades$signals$SignalStdLogic1164 == null ? (class$hades$signals$SignalStdLogic1164 = SelectBit.class$("hades.signals.SignalStdLogic1164")) : class$hades$signals$SignalStdLogic1164);
        this.port_A = this.ports[0];
        this.port_Y = this.ports[1];
        this.value_Y = new StdLogic1164(0);
    }

    public void setSymbol(Symbol s) {
        this.symbol = s;
        this.symbol.setInstanceLabel(this.getName());
        this.indexLabel = new Label();
        this.indexLabel.initialize("0 450 2 <3:0>");
        this.symbol.addMember(this.indexLabel);
        this.symbol.update_bbox();
    }

    public int getBitIndex() {
        return this.bitIndex;
    }

    public void setBitIndex(String s) {
        try {
            this.bitIndex = Integer.parseInt(s);
        }
        catch (Exception e) {
            this.bitIndex = 0;
        }
        this.clipToBounds();
        this.updateSymbol();
        this.evaluate(null);
    }

    private void clipToBounds() {
        if (this.bitIndex < 0) {
            this.bitIndex = 0;
        }
        if (this.bitIndex >= this.n_bits) {
            this.bitIndex = this.n_bits - 1;
        }
    }

    public void evaluate(Object arg) {
        Signal signal_A;
        if (SimObject.debug) {
            System.err.println(this.toString() + ".evaluate()");
        }
        if ((signal_A = this.port_A.getSignal()) == null) {
            this.value_Y = new StdLogic1164(0);
        } else {
            this.value_A = (StdLogicVector)signal_A.getValue();
            this.value_Y = this.value_A.getBitAt(this.bitIndex);
        }
        SimKernel simulator = this.parent.getSimulator();
        double time = simulator.getSimTime() + this.delay;
        Signal signal_Y = this.port_Y.getSignal();
        if (signal_Y != null) {
            simulator.scheduleEvent(SimEvent1164.createNewSimEvent((Simulatable)signal_Y, time, this.value_Y, (Object)this.port_Y));
        }
    }

    public void updateSymbol() {
        if (this.indexLabel != null) {
            this.indexLabel.setText("<" + this.bitIndex + ">");
        }
    }

    public void write(PrintWriter ps) {
        ps.print(" " + this.versionId + " " + this.n_bits + " " + this.bitIndex + " " + this.delay);
    }

    public boolean initialize(String s) {
        StringTokenizer st = new StringTokenizer(s);
        try {
            this.versionId = Integer.parseInt(st.nextToken());
            this.n_bits = Integer.parseInt(st.nextToken());
            this.bitIndex = Integer.parseInt(st.nextToken());
            this.constructStandardValues();
            this.constructPorts();
            this.setDelay(st.nextToken());
        }
        catch (Exception e) {
            this.message("-E- " + this.toString() + ".initialize(): " + e + " " + s);
        }
        return true;
    }

    public void configure() {
        if (SimObject.debug) {
            this.message("-I- starting to configure this " + this.toString());
        }
        String[] fields = new String[]{"instance name:", "name", "number or bits:    [1 .. 32]:", "width", "output delay           [sec]:", "delay", "output bit index  [width-1..0]:", "bitIndex"};
        this.propertySheet = PropertySheet.getPropertySheet(this, fields);
        this.propertySheet.setHelpText("Specify instance name, bus width, delay,\noutput value\nand the index of the output bit");
        this.propertySheet.setVisible(true);
    }

    public String getToolTip(Point position, long millis) {
        return this.getClass().getName() + "   " + this.getName() + "\n" + "value<" + (this.n_bits - 1) + ":0>= " + this.vector.toHexString() + "\n" + "bit <" + this.bitIndex + ">= " + this.value_Y.getChar();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

